/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.ArrayList;
import java.util.List;
import org.projectodd.vdx.core.ElementListStringifier;
import org.projectodd.vdx.core.ElementStringifier;
import org.projectodd.vdx.core.ListListStringifier;
import org.projectodd.vdx.core.NonElementListStringifier;
import org.projectodd.vdx.core.Stringifier;

public class Stringify {
    private static boolean defaultsRegistered = false;
    private static final List<Stringifier> stringifiers = new ArrayList<Stringifier>();

    private Stringify() {
    }

    public static void registerStringifier(Stringifier stringifier) {
        stringifiers.add(stringifier);
    }

    public static String asString(Object value) {
        Stringify.registerDefaultStringifiers();
        Stringifier s = stringifiers.stream().filter(x -> x.handles(value)).findFirst().orElse(Stringifier.DEFAULT_STRINGIFIER);
        return s.asString(value);
    }

    private static void registerDefaultStringifiers() {
        if (!defaultsRegistered) {
            Stringify.registerStringifier(new ElementStringifier());
            Stringify.registerStringifier(new ElementListStringifier());
            Stringify.registerStringifier(new ListListStringifier(10));
            Stringify.registerStringifier(new NonElementListStringifier(3, 10));
            defaultsRegistered = true;
        }
    }
}

