/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.AbstractX509CertificateChainCredential;

public final class X509CertificateChainPrivateCredential
extends AbstractX509CertificateChainCredential {
    private final PrivateKey privateKey;

    public X509CertificateChainPrivateCredential(PrivateKey privateKey, X509Certificate ... certificateChain) {
        super(certificateChain);
        Assert.checkNotNullParam("privateKey", privateKey);
        if (!this.getFirstCertificate().getPublicKey().getAlgorithm().equals(privateKey.getAlgorithm())) {
            throw ElytronMessages.log.mismatchedPublicPrivateKeyAlgorithms();
        }
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

