/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store.impl.SecretKeyWrap;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;

public class KeystorePasswordStore
extends CredentialStoreSpi {
    public static final String KEY_STORE_PASSWORD_STORE = "KeyStorePasswordStore";
    public static final String NAME = "store.name";
    public static final String STORE_FILE = "store.file";
    public static final String STORE_PASSWORD = "store.password";
    public static final String MODIFIABLE = "store.modifiable";
    public static final String STORE_BASE = "store.base";
    public static final String CREATE_STORAGE = "create.storage";
    public static final String KEY_ALIAS = "key.alias";
    public static final String KEY_PASSWORD = "key.password";
    public static final String KEY_SIZE = "key.size";
    public static final String CRYPTO_ALGORITHM = "crypto.algorithm";
    public static final String RELOADABLE = "reloadable";
    public static final String DEFAULT_ADMIN_KEY_ALIAS = "ELY_ADMIN_KEY";
    private static final String KEYSTORE_TYPE = "JCEKS";
    private static final char[] EMPTY_PASSWORD = new char[0];
    private static final Set<String> supportedConfigurationAttributes;
    private String storeName;
    private boolean reloadable = false;
    private boolean modifiable = false;
    private File storeFile = null;
    private String storeBase = "";
    private char[] storagePassword = null;
    private String adminKeyAlias = null;
    private SecretKey adminKey = null;
    private int keySize = 128;
    private String cryptographicAlgorithm = "AES";
    private boolean createStorage = false;
    private KeyStore.ProtectionParameter adminKeyProtectionParam = null;
    private final ConcurrentHashMap<String, Entry> storage = new ConcurrentHashMap();

    @Override
    public void initialize(Map<String, String> attributes) throws CredentialStoreException {
        this.storeName = attributes.getOrDefault(NAME, "myStore");
        this.checkValidConfigurationAttributes(attributes.keySet());
        this.storeBase = attributes.get(STORE_BASE);
        this.storeFile = this.resolveFile(attributes.get(STORE_FILE), this.storeName);
        String pwdSpec = attributes.get(STORE_PASSWORD);
        if (pwdSpec != null) {
            this.storagePassword = this.convertPassword(this.loadPassword(pwdSpec, STORE_PASSWORD, attributes));
        }
        this.adminKeyAlias = attributes.get(KEY_ALIAS);
        if (this.adminKeyAlias == null) {
            this.adminKeyAlias = DEFAULT_ADMIN_KEY_ALIAS;
        }
        if (attributes.get(KEY_SIZE) != null) {
            this.keySize = Integer.parseInt(attributes.get(KEY_SIZE));
        }
        if (attributes.get(CRYPTO_ALGORITHM) != null) {
            this.cryptographicAlgorithm = attributes.get(CRYPTO_ALGORITHM);
        }
        if (attributes.get(MODIFIABLE) != null) {
            this.modifiable = Boolean.parseBoolean(attributes.get(MODIFIABLE));
        }
        if (attributes.get(CREATE_STORAGE) != null) {
            this.createStorage = Boolean.parseBoolean(attributes.get(CREATE_STORAGE));
        }
        if ((pwdSpec = attributes.get(KEY_PASSWORD)) != null) {
            char[] adminKeyPassword = this.convertPassword(this.loadPassword(pwdSpec, KEY_PASSWORD, attributes));
            this.adminKeyProtectionParam = new KeyStore.PasswordProtection(adminKeyPassword);
            this.destroyPassword(adminKeyPassword);
        } else {
            this.adminKeyProtectionParam = new KeyStore.PasswordProtection(this.storagePassword);
        }
        this.readKeyStore();
        this.initialized = true;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public <C extends Credential> boolean exists(String key, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
        if (credentialType.isAssignableFrom(PasswordCredential.class)) {
            return this.storage.get(key) != null;
        }
        throw new UnsupportedCredentialTypeException(this.resolveCredentialClassName(credentialType));
    }

    @Override
    public <C extends Credential> void store(String credentialAlias, C credential) throws CredentialStoreException, UnsupportedCredentialTypeException {
        if (!this.isInitialized()) {
            ElytronMessages.log.credentialStoreNotInitialized(this.storeName);
        }
        if (!this.reloadable) {
            if (!(credential instanceof PasswordCredential)) {
                throw new UnsupportedCredentialTypeException(this.resolveCredentialClassName(credential.getClass()));
            }
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            try {
                this.storage.put(credentialAlias, new Entry(this.resolveCredentialClassName(credential.getClass()), this.encryptEntry(passwordCredential)));
            }
            catch (GeneralSecurityException e) {
                throw new CredentialStoreException(e);
            }
        } else {
            throw ElytronMessages.log.reloadablecredentialStoreIsReadOnly(this.storeName);
        }
        this.storeToFile();
    }

    @Override
    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
        if (!credentialType.isAssignableFrom(PasswordCredential.class)) {
            throw new UnsupportedCredentialTypeException(this.resolveCredentialClassName(credentialType));
        }
        Entry entry = this.storage.get(credentialAlias);
        if (entry != null) {
            byte[] encryptedPasswordData = entry.getPayload();
            if (encryptedPasswordData != null) {
                try {
                    return (C)((Credential)credentialType.cast(this.decryptEntry(encryptedPasswordData)));
                }
                catch (GeneralSecurityException e) {
                    throw new CredentialStoreException(e);
                }
            }
            throw ElytronMessages.log.credentialAliasNotFoundNotFound(credentialAlias, this.storeName);
        }
        throw ElytronMessages.log.credentialAliasNotFoundNotFound(credentialAlias, this.storeName);
    }

    @Override
    public <C extends Credential> void remove(String credentialAlias, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
        if (!credentialType.isAssignableFrom(PasswordCredential.class)) {
            throw new UnsupportedCredentialTypeException(this.resolveCredentialClassName(credentialType));
        }
        if (this.storage.get(credentialAlias) != null) {
            if (!this.reloadable) {
                this.storage.remove(credentialAlias);
                this.storeToFile();
            } else {
                throw ElytronMessages.log.reloadablecredentialStoreIsReadOnly(this.storeName);
            }
        }
    }

    @Override
    public Set<String> getAliases() throws UnsupportedOperationException, CredentialStoreException {
        return Collections.unmodifiableSet(this.storage.keySet());
    }

    private <C extends Credential> String resolveCredentialClassName(Class<C> credentialClass) throws UnsupportedCredentialTypeException {
        return credentialClass.getName();
    }

    private synchronized void storeToFile() throws CredentialStoreException, UnsupportedCredentialTypeException {
        boolean storeFileActuallyCreated = false;
        if (this.createStorage && !this.storeFile.exists()) {
            try {
                this.storeFile.createNewFile();
                storeFileActuallyCreated = true;
            }
            catch (IOException e) {
                throw ElytronMessages.log.cannotWriteStorageFie(this.storeFile.getAbsolutePath(), this.storeName);
            }
        }
        try {
            KeyStore credentialStore = KeyStore.getInstance(KEYSTORE_TYPE);
            credentialStore.load(null, null);
            this.packToKeyStore(credentialStore);
            if (!this.storeFile.canWrite()) {
                throw ElytronMessages.log.cannotWriteStorageFie(this.storeFile.getAbsolutePath(), this.storeName);
            }
            try (FileOutputStream stream = new FileOutputStream(this.storeFile);){
                credentialStore.store(stream, this.storagePassword);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            if (storeFileActuallyCreated) {
                this.storeFile.delete();
            }
            throw new CredentialStoreException(e);
        }
    }

    private void packToKeyStore(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException, UnsupportedCredentialTypeException {
        keyStore.setEntry(this.adminKeyAlias, new KeyStore.SecretKeyEntry(this.adminKey), this.adminKeyProtectionParam);
        for (String alias : this.storage.keySet()) {
            byte[] entryBytes = Entry.serializeEntry(this.storage.get(alias));
            keyStore.setEntry(alias, new KeyStore.SecretKeyEntry(new SecretKeyWrap(entryBytes, "clear")), this.adminKeyProtectionParam);
        }
    }

    private void checkValidConfigurationAttributes(Set<String> attributes) throws CredentialStoreException {
        StringBuilder wrongAttributes = new StringBuilder();
        attributes.stream().filter(o -> !o.startsWith("store.password.")).filter(o -> !o.startsWith("key.password.")).filter(o -> !supportedConfigurationAttributes.contains(o)).forEach(o -> wrongAttributes.append(", ").append((String)o));
        if (wrongAttributes.length() > 0) {
            throw ElytronMessages.log.unsupportedPasswordStorageConfigurationAttributes(this.storeName, wrongAttributes.substring(2));
        }
    }

    private void readKeyStore() throws CredentialStoreException {
        if (!(!this.createStorage || this.storeFile.exists() && this.storeFile.canRead())) {
            try {
                this.adminKey = this.generateSecretKey();
            }
            catch (NoSuchAlgorithmException e) {
                ElytronMessages.log.info("Storage exception:", e);
                throw new CredentialStoreException(e);
            }
            return;
        }
        try {
            KeyStore vaultStorage = KeyStore.getInstance(KEYSTORE_TYPE);
            try (FileInputStream stream = new FileInputStream(this.storeFile);){
                vaultStorage.load(stream, this.storagePassword);
            }
            Enumeration<String> storedAliases = vaultStorage.aliases();
            while (storedAliases.hasMoreElements()) {
                String alias = storedAliases.nextElement();
                if (alias.equalsIgnoreCase(this.adminKeyAlias)) continue;
                KeyStore.SecretKeyEntry secret = (KeyStore.SecretKeyEntry)vaultStorage.getEntry(alias, this.adminKeyProtectionParam);
                if (secret.getSecretKey() != null) {
                    this.storage.put(alias, Entry.deserializeEntry(secret.getSecretKey().getEncoded()));
                    continue;
                }
                ElytronMessages.log.warn("Stored for alias='" + alias + "' is null.");
            }
            KeyStore.Entry adminKeyEntry = vaultStorage.getEntry(this.adminKeyAlias, this.adminKeyProtectionParam);
            SecretKey secretKey = this.adminKey = adminKeyEntry != null ? ((KeyStore.SecretKeyEntry)adminKeyEntry).getSecretKey() : null;
            if (this.adminKey == null) {
                throw ElytronMessages.log.storeAdminKeyNotPresent(this.storeName, this.adminKeyAlias);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
            throw ElytronMessages.log.cannotReadVaultStorage(this.storeFile.toString(), this.storeName, e);
        }
    }

    private SecretKey generateSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance(this.cryptographicAlgorithm);
        generator.init(this.keySize);
        return generator.generateKey();
    }

    private byte[] encryptEntry(PasswordCredential passwordCredential) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Assert.assertNotNull(passwordCredential);
        Cipher c = this.getCipher(1);
        if ("clear".equals(passwordCredential.getAlgorithm())) {
            Password p = passwordCredential.getPassword();
            return c.doFinal(KeystorePasswordStore.charArrayEncode(((ClearPassword)p).getPassword()));
        }
        throw new NoSuchAlgorithmException(passwordCredential.getAlgorithm());
    }

    private PasswordCredential decryptEntry(byte[] entry) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        Assert.assertNotNull(entry);
        Cipher c = this.getCipher(2);
        PasswordFactory passwordFactory = PasswordFactory.getInstance("clear");
        return new PasswordCredential(passwordFactory.generatePassword(new ClearPasswordSpec(KeystorePasswordStore.byteArrayDecode(c.doFinal(entry)))));
    }

    static char[] byteArrayDecode(byte[] buffer) {
        return new String(buffer, StandardCharsets.UTF_8).toCharArray();
    }

    static byte[] charArrayEncode(char[] buffer) {
        return Normalizer.normalize(new String(buffer), Normalizer.Form.NFKC).getBytes(StandardCharsets.UTF_8);
    }

    private Cipher getCipher(int mode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec adminKeySpec = new SecretKeySpec(this.adminKey.getEncoded(), this.cryptographicAlgorithm);
        Cipher c = Cipher.getInstance(this.cryptographicAlgorithm);
        c.init(mode, adminKeySpec);
        return c;
    }

    private void destroyPassword(char[] password) {
        if (password != null) {
            Arrays.fill(password, '\u0000');
        }
    }

    private Credential loadPassword(String credentialSpec, String nameSpace, Map<String, String> options) throws CredentialStoreException {
        Map<String, String> nameSpaceOnlyOptions = options.entrySet().stream().filter(p -> !((String)p.getKey()).equals(nameSpace) && ((String)p.getKey()).startsWith(nameSpace)).collect(Collectors.toMap(p -> ((String)p.getKey()).substring(nameSpace.length() + 1), Map.Entry::getValue));
        return this.resolveMasterCredential(credentialSpec, PasswordCredential.class, nameSpaceOnlyOptions);
    }

    private char[] convertPassword(Object password) {
        if (password != null) {
            if (password instanceof String) {
                return ((String)password).toCharArray();
            }
            if (password instanceof ClearPassword) {
                return ((ClearPassword)password).getPassword();
            }
            if (password instanceof PasswordCredential) {
                Password p = ((PasswordCredential)password).getPassword();
                if (p instanceof ClearPassword) {
                    return ((ClearPassword)p).getPassword();
                }
                return EMPTY_PASSWORD;
            }
            return Arrays.copyOf((char[])password, ((char[])password).length);
        }
        return EMPTY_PASSWORD;
    }

    private File resolveFile(String fileName, String defaultFileName) {
        String storage = (this.storeBase != null && !this.storeBase.isEmpty() ? this.storeBase + "/" : "") + (fileName != null ? fileName : defaultFileName);
        return new File(storage);
    }

    static {
        HashSet ca = new HashSet();
        Collections.addAll(ca, NAME, STORE_FILE, STORE_PASSWORD, STORE_BASE, CREATE_STORAGE, KEY_ALIAS, KEY_PASSWORD, KEY_SIZE, CRYPTO_ALGORITHM, RELOADABLE);
        supportedConfigurationAttributes = Collections.unmodifiableSet(ca);
    }

    public static class Entry
    implements Serializable {
        private static final int DEFAULT_VERSION = 1;
        private static final long serialVersionUID = -2347975176295725217L;
        private int version;
        private String className;
        private byte[] payload;

        public Entry(String className, byte[] payload) {
            this(1, className, payload);
        }

        public Entry(int version, String className, byte[] payload) {
            this.version = version;
            this.className = className;
            this.payload = payload;
        }

        public int getVersion() {
            return this.version;
        }

        public String getClassName() {
            return this.className;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public static byte[] serializeEntry(Entry entry) {
            byte[] className = entry.getClassName().getBytes(StandardCharsets.UTF_8);
            ByteStringBuilder b = new ByteStringBuilder();
            b.appendBE(entry.getVersion());
            b.appendBE(className.length);
            b.append(className);
            b.append(entry.getPayload());
            return b.toArray();
        }

        public static Entry deserializeEntry(byte[] data) {
            ByteIterator bi = ByteIterator.ofBytes(data);
            int version = bi.getBE32();
            int classNameLength = bi.getBE32();
            String className = bi.drainToUtf8(classNameLength);
            byte[] encrypted = bi.drain();
            return new Entry(version, className, encrypted);
        }
    }
}

