/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.generator.PatchGenerator;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.runner.PatchContentLoader;

abstract class PatchContentWriter {
    private static final String README = "README.txt";

    PatchContentWriter() {
    }

    abstract File getSourceFile(ContentItem var1) throws IOException;

    abstract File getTargetFile(ContentItem var1) throws IOException;

    protected void copyItems(Collection<ContentModification> modifications) throws IOException {
        for (ContentModification modification : modifications) {
            if (modification.getType() == ModificationType.REMOVE) continue;
            ContentItem item = modification.getItem();
            File source = this.getSourceFile(item);
            File target = this.getTargetFile(item);
            if (!source.exists()) {
                throw PatchGenerator.processingError("source item does not exist %s", source.getAbsolutePath());
            }
            IoUtils.copyFile((File)source, (File)target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void process(File targetRoot, File distributionRoot, Patch patch) throws IOException, XMLStreamException {
        FileOutputStream os;
        targetRoot.mkdirs();
        InputStream is = PatchContentWriter.class.getClassLoader().getResourceAsStream(README);
        try {
            File readme = new File(targetRoot, README);
            os = new FileOutputStream(readme);
            try {
                IoUtils.copyStream((InputStream)is, (OutputStream)os);
            }
            finally {
                IoUtils.safeClose((Closeable)os);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)is);
        }
        File patchXml = new File(targetRoot, "patch.xml");
        os = new FileOutputStream(patchXml);
        try {
            PatchXml.marshal((OutputStream)os, (Patch)patch);
        }
        finally {
            IoUtils.safeClose((Closeable)os);
        }
        PatchContentWriter.internalProcess(targetRoot, distributionRoot, patch);
    }

    static void internalProcess(File targetRoot, final File distributionRoot, Patch patch) throws IOException, XMLStreamException {
        final File bundles = new File(distributionRoot, "bundles");
        final File modules = new File(distributionRoot, "modules");
        for (final PatchElement element : patch.getElements()) {
            File elementRoot = new File(targetRoot, element.getId());
            final String base = element.getProvider().isAddOn() ? "system/add-ons" : "system/layers";
            final PatchContentLoader elementLoader = PatchContentLoader.create((File)elementRoot);
            PatchContentWriter elementWriter = new PatchContentWriter(){

                @Override
                File getSourceFile(ContentItem item) throws IOException {
                    if (item.getContentType() == ContentType.BUNDLE) {
                        File root = new File(bundles, base);
                        File layer = new File(root, element.getProvider().getName());
                        return PatchContentLoader.getModulePath((File)layer, (ModuleItem)((ModuleItem)item));
                    }
                    if (item.getContentType() == ContentType.MODULE) {
                        File root = new File(modules, base);
                        File layer = new File(root, element.getProvider().getName());
                        return PatchContentLoader.getModulePath((File)layer, (ModuleItem)((ModuleItem)item));
                    }
                    throw PatchGenerator.processingError("invalid content item for patch-element %s", item);
                }

                @Override
                File getTargetFile(ContentItem item) throws IOException {
                    return elementLoader.getFile(item);
                }
            };
            elementWriter.copyItems(element.getModifications());
        }
        File patchRoot = new File(targetRoot, patch.getPatchId());
        final PatchContentLoader targetLoader = PatchContentLoader.create((File)patchRoot);
        PatchContentWriter writer = new PatchContentWriter(){

            @Override
            File getSourceFile(ContentItem item) throws IOException {
                if (item.getContentType() == ContentType.MISC) {
                    return PatchContentLoader.getMiscPath((File)distributionRoot, (MiscContentItem)((MiscContentItem)item));
                }
                throw PatchGenerator.processingError("invalid content item for identity %s", item);
            }

            @Override
            File getTargetFile(ContentItem item) throws IOException {
                return targetLoader.getFile(item);
            }
        };
        writer.copyItems(patch.getModifications());
    }
}

