/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import java.io.InputStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerService;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.as.patching.tool.PatchingResult;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceRegistry;

public final class LocalPatchOperationStepHandler
implements OperationStepHandler {
    public static final OperationStepHandler INSTANCE = new LocalPatchOperationStepHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(true);
        final InstallationManager installationManager = (InstallationManager)registry.getRequiredService(InstallationManagerService.NAME).getValue();
        if (installationManager.requiresRestart()) {
            throw PatchLogger.ROOT_LOGGER.serverRequiresRestart();
        }
        try {
            PatchTool runner = PatchTool.Factory.create(installationManager);
            ContentVerificationPolicy policy = PatchTool.Factory.create(operation);
            int index = operation.get("input-stream-index").asInt(0);
            InputStream is = context.getAttachmentStream(index);
            installationManager.restartRequired();
            final PatchingResult result = runner.applyPatch(is, policy);
            context.restartRequired();
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        result.commit();
                    } else {
                        installationManager.clearRestartRequired();
                        context.revertRestartRequired();
                        result.rollback();
                    }
                }
            });
        }
        catch (PatchingException e) {
            ModelNode failureDescription = context.getFailureDescription();
            PatchOperationTarget.formatFailedResponse(e, failureDescription);
            installationManager.clearRestartRequired();
        }
    }
}

