/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.evidence.Evidence;

public final class IdentityLocator {
    private final String name;
    private final Principal principal;
    private final Evidence evidence;

    IdentityLocator(String name, Principal principal, Evidence evidence) {
        this.name = name;
        this.principal = principal;
        this.evidence = evidence;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        String name = this.name;
        if (name == null) {
            throw ElytronMessages.log.locatorFieldNotSet("name");
        }
        return name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Principal getPrincipal() {
        Principal principal = this.principal;
        if (principal == null) {
            throw ElytronMessages.log.locatorFieldNotSet("principal");
        }
        return principal;
    }

    public boolean hasPrincipal() {
        return this.principal != null;
    }

    public Evidence getEvidence() {
        Evidence evidence = this.evidence;
        if (evidence == null) {
            throw ElytronMessages.log.locatorFieldNotSet("evidence");
        }
        return evidence;
    }

    public boolean hasEvidence() {
        return this.evidence != null;
    }

    public static IdentityLocator fromName(String name) {
        Assert.checkNotNullParam("name", name);
        return new IdentityLocator(name, null, null);
    }

    public static IdentityLocator fromEvidence(Evidence evidence) {
        Assert.checkNotNullParam("evidence", evidence);
        Principal principal = evidence.getPrincipal();
        return new IdentityLocator(principal instanceof NamePrincipal ? principal.getName() : null, principal, evidence);
    }

    public static IdentityLocator fromPrincipal(Principal principal) {
        Assert.checkNotNullParam("principal", principal);
        return new IdentityLocator(principal instanceof NamePrincipal ? principal.getName() : null, principal, null);
    }

    public static class Builder {
        private String name;
        private Principal principal;
        private Evidence evidence;

        Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPrincipal(Principal principal) {
            this.principal = principal;
            return this;
        }

        public Builder setEvidence(Evidence evidence) {
            this.evidence = evidence;
            return this;
        }

        public boolean isEmpty() {
            return this.name == null && this.principal == null && this.evidence == null;
        }

        public IdentityLocator build() {
            return new IdentityLocator(this.name, this.principal, this.evidence);
        }
    }
}

