/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineFormat;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.parsing.InitialState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.command.ArgumentListState;
import org.jboss.as.cli.parsing.command.ArgumentValueNotFinishedException;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.cli.parsing.operation.HeaderListState;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.as.cli.parsing.operation.OperationRequestState;

public class ParserUtil {
    public static String parse(String commandLine, CommandLineParser.CallbackHandler handler) throws CommandFormatException {
        return ParserUtil.parse(commandLine, handler, true);
    }

    public static String parse(String commandLine, CommandLineParser.CallbackHandler handler, boolean strict) throws CommandFormatException {
        if (commandLine == null) {
            return null;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        return StateParser.parse(commandLine, callbackHandler, InitialState.INSTANCE, strict);
    }

    public static String parse(String commandLine, CommandLineParser.CallbackHandler handler, boolean strict, CommandContext ctx) throws CommandFormatException {
        if (commandLine == null) {
            return null;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        return StateParser.parse(commandLine, callbackHandler, InitialState.INSTANCE, strict, ctx);
    }

    public static String parseOperationRequest(String commandLine, CommandLineParser.CallbackHandler handler) throws CommandFormatException {
        if (commandLine == null) {
            return null;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        handler.setFormat(OperationFormat.INSTANCE);
        return StateParser.parse(commandLine, callbackHandler, OperationRequestState.INSTANCE);
    }

    public static String parseHeaders(String commandLine, CommandLineParser.CallbackHandler handler) throws CommandFormatException {
        if (commandLine == null) {
            return null;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        return StateParser.parse(commandLine, callbackHandler, HeaderListState.INSTANCE);
    }

    public static String parseCommandArgs(String commandLine, CommandLineParser.CallbackHandler handler) throws CommandFormatException {
        if (commandLine == null) {
            return null;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        return StateParser.parse(commandLine, callbackHandler, ArgumentListState.INSTANCE);
    }

    public static String parse(String str, CommandLineParser.CallbackHandler handler, ParsingState initialState) throws CommandFormatException {
        if (str == null) {
            return null;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        return StateParser.parse(str, callbackHandler, initialState);
    }

    protected static ParsingStateCallbackHandler getCallbackHandler(final CommandLineParser.CallbackHandler handler) {
        return new ParsingStateCallbackHandler(){
            private int nameValueSeparator = -1;
            private String name;
            final StringBuilder buffer = new StringBuilder();
            int bufferStartIndex = 0;
            boolean inValue;
            String delegateStateId;
            ParsingStateCallbackHandler delegate;
            CommandLineFormat format;

            @Override
            public void enteredState(ParsingContext ctx) throws CommandFormatException {
                String id = ctx.getState().getId();
                if (this.delegate != null) {
                    this.delegate.enteredState(ctx);
                    return;
                }
                if (!this.inValue && ctx.getState().updateValueIndex()) {
                    this.bufferStartIndex = ctx.getLocation();
                    this.inValue = ctx.getState().lockValueIndex();
                }
                if (id.equals("PROP_LIST")) {
                    handler.propertyListStart(ctx.getLocation());
                } else if ("ADDR_OP_SEP".equals(id)) {
                    handler.addressOperationSeparator(ctx.getLocation());
                } else if ("NAME_VALUE_SEPARATOR".equals(id)) {
                    this.nameValueSeparator = ctx.getLocation();
                    if (this.buffer.length() > 0) {
                        this.name = this.buffer.toString().trim();
                        this.buffer.setLength(0);
                    }
                } else if (id.equals("CMD")) {
                    this.format = CommandFormat.INSTANCE;
                    handler.setFormat(CommandFormat.INSTANCE);
                } else if (id.equals("OP_REQ")) {
                    this.format = OperationFormat.INSTANCE;
                    handler.setFormat(OperationFormat.INSTANCE);
                } else if ("HEADER_LIST".equals(id)) {
                    handler.headerListStart(ctx.getLocation());
                }
            }

            @Override
            public void leavingState(ParsingContext ctx) throws CommandFormatException {
                String id = ctx.getState().getId();
                if (this.delegateStateId != null && !id.equals(this.delegateStateId)) {
                    this.delegate.leavingState(ctx);
                    return;
                }
                if (id.equals("PROP_LIST")) {
                    if (!ctx.isEndOfContent()) {
                        handler.propertyListEnd(ctx.getLocation());
                    }
                } else if ("PROP".equals(id)) {
                    if (this.name != null) {
                        String value = this.getPropertyValue(ctx);
                        if (value != null) {
                            handler.property(this.name, value, this.bufferStartIndex);
                        } else {
                            handler.propertyName(this.bufferStartIndex, this.name);
                            if (this.nameValueSeparator != -1) {
                                handler.propertyNameValueSeparator(this.nameValueSeparator);
                            }
                        }
                    } else {
                        handler.propertyNoValue(this.bufferStartIndex, this.buffer.toString().trim());
                    }
                    if (!ctx.isEndOfContent() || this.format != null && this.format.isPropertySeparator(ctx.getCharacter()) && ctx.getError() == null) {
                        handler.propertySeparator(ctx.getLocation());
                    }
                    this.buffer.setLength(0);
                    this.name = null;
                    this.nameValueSeparator = -1;
                } else if ("PROP_VALUE".equals(id)) {
                    if (this.name == null) {
                        handler.property(null, this.buffer.toString(), this.bufferStartIndex);
                        this.buffer.setLength(0);
                        if (!ctx.isEndOfContent()) {
                            handler.propertySeparator(ctx.getLocation());
                        }
                    }
                } else if ("OP_NAME".equals(id)) {
                    String opName = this.buffer.toString().trim();
                    if (!opName.isEmpty()) {
                        handler.operationName(this.bufferStartIndex, opName);
                    }
                    this.buffer.setLength(0);
                } else if ("NODE".equals(id)) {
                    char ch = ctx.getCharacter();
                    if (this.buffer.length() == 0) {
                        if (ch == '/') {
                            handler.rootNode(this.bufferStartIndex);
                            handler.nodeSeparator(ctx.getLocation());
                        }
                    } else {
                        String value = this.buffer.toString().trim();
                        if (ch == '=') {
                            handler.nodeType(this.bufferStartIndex, value);
                            handler.nodeTypeNameSeparator(ctx.getLocation());
                        } else if (ch == ':') {
                            handler.nodeName(this.bufferStartIndex, value);
                        } else {
                            if (!".".equals(value)) {
                                if ("..".equals(value)) {
                                    handler.parentNode(ctx.getLocation() - 2);
                                } else if (".type".equals(value)) {
                                    handler.nodeType(ctx.getLocation() - 5);
                                } else if (ch == '/') {
                                    if ("".equals(value)) {
                                        handler.rootNode(ctx.getLocation());
                                    } else {
                                        handler.nodeName(this.bufferStartIndex, value);
                                    }
                                } else {
                                    handler.nodeTypeOrName(this.bufferStartIndex, value);
                                }
                            }
                            if (ch == '/' && value.charAt(value.length() - 1) != '/') {
                                handler.nodeSeparator(ctx.getLocation());
                            }
                        }
                    }
                    this.buffer.setLength(0);
                } else if ("HEADER_LIST".equals(id)) {
                    if (!ctx.isEndOfContent()) {
                        handler.headerListEnd(ctx.getLocation());
                    }
                } else if ("HEADER_NAME".equals(id)) {
                    String headerName = this.buffer.toString().trim();
                    if (!headerName.isEmpty()) {
                        this.name = headerName;
                        this.delegate = handler.headerName(this.bufferStartIndex, headerName);
                        if (this.delegate != null) {
                            this.delegateStateId = "HEADER";
                        }
                    }
                    this.buffer.setLength(0);
                } else if ("HEADER_VALUE".equals(id)) {
                    handler.header(this.name, this.buffer.toString(), this.bufferStartIndex);
                    this.buffer.setLength(0);
                    this.nameValueSeparator = -1;
                } else if ("HEADER".equals(id)) {
                    if (this.nameValueSeparator > 0) {
                        handler.headerNameValueSeparator(this.nameValueSeparator);
                        this.nameValueSeparator = -1;
                    }
                    this.name = null;
                    this.delegate = null;
                    this.delegateStateId = null;
                    if (!ctx.isEndOfContent() && ctx.getCharacter() == ';') {
                        handler.headerSeparator(ctx.getLocation());
                    }
                } else if ("OUT_REDIRECT".equals(id)) {
                    handler.outputTarget(this.bufferStartIndex, this.buffer.toString().trim());
                    this.buffer.setLength(0);
                }
                if (this.inValue && ctx.getState().lockValueIndex()) {
                    this.inValue = false;
                }
            }

            private String getPropertyValue(ParsingContext ctx) {
                String value = this.buffer.toString();
                if (value.trim().length() == 0) {
                    return null;
                }
                if (ctx.isEndOfContent() && ctx.getError() != null && ctx.getError() instanceof ArgumentValueNotFinishedException) {
                    return value.replaceAll("^\\s+", "");
                }
                return value.trim();
            }

            @Override
            public void character(ParsingContext ctx) throws CommandFormatException {
                if (this.delegate != null) {
                    this.delegate.character(ctx);
                    return;
                }
                this.buffer.append(ctx.getCharacter());
            }
        };
    }
}

