/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.List;
import java.util.stream.Collectors;
import org.projectodd.vdx.core.Stringifier;
import org.projectodd.vdx.core.Stringify;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.schema.SchemaElement;

public class NonElementListStringifier
implements Stringifier {
    private final int threshold;
    private final int limit;

    public NonElementListStringifier(int threshold, int limit) {
        if (limit <= threshold) {
            throw new IllegalArgumentException("limit must be greater than threshold");
        }
        this.threshold = threshold;
        this.limit = limit;
    }

    @Override
    public boolean handles(Object value) {
        return Stringifier.super.handles(value) && !SchemaElement.class.isAssignableFrom(((List)value).get(0).getClass());
    }

    @Override
    public Class handledClass() {
        return List.class;
    }

    @Override
    public String asString(Object value) {
        List list = (List)value;
        List<String> values = list.stream().map(Stringify::asString).distinct().limit(this.limit > 0 ? (long)this.limit : (long)list.size()).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        if (values.size() <= this.threshold) {
            sb.append(Util.asCommaString(values));
        } else {
            sb.append('\n');
            values.forEach(v -> sb.append("- ").append((String)v).append('\n'));
            if (this.limit < list.size()) {
                sb.append(String.format("(and %s more)\n", list.size() - this.limit));
            }
        }
        return sb.toString();
    }
}

