/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmMapper;

public final class MechanismRealmConfiguration {
    private final String realmName;
    private final NameRewriter preRealmRewriter;
    private final NameRewriter postRealmRewriter;
    private final NameRewriter finalRewriter;
    private final RealmMapper realmMapper;
    public static final MechanismRealmConfiguration NO_REALM = new MechanismRealmConfiguration("none", null, null, null, null);

    MechanismRealmConfiguration(String realmName, NameRewriter preRealmRewriter, NameRewriter postRealmRewriter, NameRewriter finalRewriter, RealmMapper realmMapper) {
        this.realmName = realmName;
        this.preRealmRewriter = preRealmRewriter;
        this.postRealmRewriter = postRealmRewriter;
        this.finalRewriter = finalRewriter;
        this.realmMapper = realmMapper;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public NameRewriter getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    public NameRewriter getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    public NameRewriter getFinalRewriter() {
        return this.finalRewriter;
    }

    public RealmMapper getRealmMapper() {
        return this.realmMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String realmName;
        private NameRewriter preRealmRewriter;
        private NameRewriter postRealmRewriter;
        private NameRewriter finalRewriter;
        private RealmMapper realmMapper;

        Builder() {
        }

        public Builder setRealmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public Builder setPreRealmRewriter(NameRewriter preRealmRewriter) {
            this.preRealmRewriter = preRealmRewriter;
            return this;
        }

        public Builder setPostRealmRewriter(NameRewriter postRealmRewriter) {
            this.postRealmRewriter = postRealmRewriter;
            return this;
        }

        public Builder setFinalRewriter(NameRewriter finalRewriter) {
            this.finalRewriter = finalRewriter;
            return this;
        }

        public Builder setRealmMapper(RealmMapper realmMapper) {
            this.realmMapper = realmMapper;
            return this;
        }

        public MechanismRealmConfiguration build() {
            Assert.checkNotNullParam("realmName", this.realmName);
            return new MechanismRealmConfiguration(this.realmName, this.preRealmRewriter, this.postRealmRewriter, this.finalRewriter, this.realmMapper);
        }
    }
}

