/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.server.AbstractMechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.sasl.util.AuthenticationCompleteCallbackSaslServerFactory;
import org.wildfly.security.sasl.util.AuthenticationTimeoutSaslServerFactory;
import org.wildfly.security.sasl.util.SaslMechanismInformation;
import org.wildfly.security.sasl.util.SecurityIdentitySaslServerFactory;
import org.wildfly.security.sasl.util.SetMechanismInformationSaslServerFactory;
import org.wildfly.security.sasl.util.TrustManagerSaslServerFactory;

public final class SaslAuthenticationFactory
extends AbstractMechanismAuthenticationFactory<SaslServer, SaslServerFactory, SaslException> {
    private final SaslServerFactory saslServerFactory;
    static final Map<String, String> QUERY_ALL = Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true");

    SaslAuthenticationFactory(SecurityDomain securityDomain, MechanismConfigurationSelector mechanismConfigurationSelector, SaslServerFactory saslServerFactory) {
        super(securityDomain, mechanismConfigurationSelector, saslServerFactory);
        this.saslServerFactory = saslServerFactory;
    }

    @Override
    SaslServer doCreate(String name, CallbackHandler callbackHandler, UnaryOperator<SaslServerFactory> factoryTransformation) throws SaslException {
        return new SecurityIdentitySaslServerFactory((SaslServerFactory)factoryTransformation.apply((SaslServerFactory)this.getFactory())).createSaslServer(name, "unknown", null, QUERY_ALL, callbackHandler);
    }

    @Override
    Collection<String> getAllSupportedMechNames() {
        String[] names = this.saslServerFactory.getMechanismNames(Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true"));
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        if (names.length == 1) {
            return Collections.singletonList(names[0]);
        }
        return Arrays.asList(names);
    }

    @Override
    Collection<Class<? extends Evidence>> getSupportedEvidenceTypes(String mechName) {
        return SaslMechanismInformation.getSupportedServerEvidenceTypes(mechName);
    }

    @Override
    Collection<String> getSupportedEvidenceAlgorithmNames(Class<? extends AlgorithmEvidence> evidenceType, String mechName) {
        return SaslMechanismInformation.getSupportedServerEvidenceAlgorithms(mechName, evidenceType);
    }

    @Override
    Collection<Class<? extends Credential>> getSupportedCredentialTypes(String mechName) {
        return SaslMechanismInformation.getSupportedServerCredentialTypes(mechName);
    }

    @Override
    Collection<String> getSupportedCredentialAlgorithmNames(Class<? extends AlgorithmCredential> credentialType, String mechName) {
        return SaslMechanismInformation.getSupportedServerCredentialAlgorithms(mechName, credentialType);
    }

    @Override
    boolean usesCredentials(String mechName) {
        return SaslMechanismInformation.needsServerCredentials(mechName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractMechanismAuthenticationFactory.Builder<SaslServer, SaslServerFactory, SaslException> {
        Builder() {
        }

        @Override
        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            super.setSecurityDomain(securityDomain);
            return this;
        }

        @Override
        public Builder setMechanismConfigurationSelector(MechanismConfigurationSelector mechanismConfigurationSelector) {
            super.setMechanismConfigurationSelector(mechanismConfigurationSelector);
            return this;
        }

        public Builder setFactory(SaslServerFactory factory) {
            super.setFactory(factory);
            return this;
        }

        public SaslAuthenticationFactory build() {
            AbstractDelegatingSaslServerFactory factory = new AuthenticationCompleteCallbackSaslServerFactory(new SetMechanismInformationSaslServerFactory((SaslServerFactory)this.getFactory()));
            if (!factory.delegatesThrough(TrustManagerSaslServerFactory.class)) {
                factory = new TrustManagerSaslServerFactory(factory, null);
            }
            factory = new AuthenticationTimeoutSaslServerFactory(factory, SecurityDomain.getScheduledExecutorService());
            return new SaslAuthenticationFactory(this.getSecurityDomain(), this.getMechanismConfigurationSelector(), factory);
        }
    }
}

