/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import org.wildfly.common.Assert;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;

public class SecretKeyWrap
implements SecretKey,
Serializable {
    private static final long serialVersionUID = -4338788143408230538L;
    private byte[] bytes;
    private String algorithm;

    public SecretKeyWrap(byte[] bytes, String algorithm) {
        Assert.assertNotNull(bytes);
        Assert.assertNotNull(algorithm);
        this.bytes = bytes;
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return this.bytes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        byte[] algorithmName = this.algorithm.getBytes(StandardCharsets.UTF_8);
        ByteStringBuilder b = new ByteStringBuilder();
        b.appendBE(algorithmName.length);
        b.append(algorithmName);
        b.append(this.bytes);
        out.writeObject(b.toArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ByteIterator bi = ByteIterator.ofBytes((byte[])in.readObject());
        int algorithmBytesLength = bi.getBE32();
        this.algorithm = bi.drainToUtf8(algorithmBytesLength);
        this.bytes = bi.drain();
    }
}

