/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.projectodd.vdx.core.DocElement;
import org.projectodd.vdx.core.DocWalker;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.Position;
import org.projectodd.vdx.core.Tree;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.ValidationError;
import org.projectodd.vdx.core.schema.SchemaElement;
import org.projectodd.vdx.core.schema.SchemaPathGate;
import org.projectodd.vdx.core.schema.SchemaPathPrefixProvider;
import org.projectodd.vdx.core.schema.SchemaWalker;

public class ValidationContext {
    private final URL document;
    private final List<String> lines;
    private final List<URL> schemas = new ArrayList<URL>();
    private Tree<SchemaElement> walkedSchemas = null;
    private Tree<DocElement> walkedDoc = null;
    private SchemaPathPrefixProvider prefixProvider = null;
    private SchemaPathGate pathGate = SchemaPathGate.DEFAULT;

    public ValidationContext(URL document, List<URL> schemas) throws IOException {
        this.document = document;
        BufferedReader reader = new BufferedReader(new InputStreamReader(document.openStream()));
        Object object = null;
        try {
            this.lines = reader.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (object != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
        Set<String> xmlnses = Util.extractXMLNS(this.lines);
        for (URL url : schemas) {
            if (!Util.providesXMLNS(xmlnses, url)) continue;
            this.schemas.add(url);
        }
    }

    public ValidationContext prefixProvider(SchemaPathPrefixProvider provider) {
        this.prefixProvider = provider;
        return this;
    }

    public ValidationContext pathGate(SchemaPathGate gate) {
        this.pathGate = gate;
        return this;
    }

    public int documentLineCount() {
        return this.lines.size();
    }

    public List<String> documentLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public List<String> extractLines(int start, int end) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int idx = start; idx < end; ++idx) {
            ret.add(this.lines.get(idx));
        }
        return ret;
    }

    public ErrorHandler.HandledResult handle(ValidationError error) {
        return error.type().handler().handle(this, error);
    }

    public List<List<SchemaElement>> alternateElementsForAttribute(String attribute) {
        return this.alternateElements(true, el -> el.attributes().contains(attribute));
    }

    public List<List<SchemaElement>> alternateElementsForElement(QName element) {
        return this.alternateElements(false, el -> el.qname().equals(element));
    }

    private List<List<SchemaElement>> alternateElements(boolean includeValue, Function<SchemaElement, Boolean> pred) {
        return this.schemaTree().pathsToValue(includeValue, pred).stream().filter(this::allowPath).map(this::schemaPathWithPrefix).collect(Collectors.toList());
    }

    private boolean allowPath(List<SchemaElement> path) {
        return this.pathGate.allowPath(path.stream().map(SchemaElement::qname).collect(Collectors.toList()), this);
    }

    public List<SchemaElement> schemaPathWithPrefix(List<SchemaElement> path) {
        List<QName> prefix;
        if (this.prefixProvider == null) {
            this.prefixProvider = (p, __) -> {
                List<List<DocElement>> prefixPaths = this.documentTree().pathsToValue(e -> e.name().equals(((QName)p.get(0)).getLocalPart()));
                if (!prefixPaths.isEmpty()) {
                    return prefixPaths.get(0).stream().map(e -> QName.valueOf(e.name())).collect(Collectors.toList());
                }
                return Collections.emptyList();
            };
        }
        if ((prefix = this.prefixProvider.prefixFor(path.stream().map(SchemaElement::qname).collect(Collectors.toList()), this)) != null && !prefix.isEmpty()) {
            ArrayList<SchemaElement> fullPath = new ArrayList<SchemaElement>();
            fullPath.addAll(prefix.stream().map(SchemaElement::new).collect(Collectors.toList()));
            fullPath.addAll(path);
            return fullPath;
        }
        return path;
    }

    public Set<String> attributesForElement(List<SchemaElement> path) {
        Tree tree = this.schemaTree();
        ArrayDeque<SchemaElement> pathStack = new ArrayDeque<SchemaElement>(path);
        while (tree != null && !pathStack.isEmpty()) {
            SchemaElement cur = (SchemaElement)pathStack.pop();
            tree = tree.children().stream().filter(t -> ((SchemaElement)t.value()).qname().equals(cur.qname())).findFirst().orElse(null);
        }
        HashSet<String> ret = new HashSet<String>();
        if (tree != null && !tree.isRoot()) {
            ret.addAll(tree.value().attributes());
        }
        return ret;
    }

    public Set<SchemaElement> elementsForElement(List<SchemaElement> path) {
        Tree tree = this.schemaTree();
        ArrayDeque<SchemaElement> pathStack = new ArrayDeque<SchemaElement>(path);
        while (tree != null && !pathStack.isEmpty()) {
            SchemaElement cur = (SchemaElement)pathStack.pop();
            tree = tree.children().stream().filter(t -> ((SchemaElement)t.value()).qname().equals(cur.qname())).findFirst().orElse(null);
        }
        HashSet<SchemaElement> ret = new HashSet<SchemaElement>();
        if (tree != null && !tree.isRoot()) {
            ret.addAll(tree.children().stream().map(Tree::value).collect(Collectors.toList()));
        }
        return ret;
    }

    public Position searchForward(int startLine, int startCol, Pattern regex) {
        int loopStartCol = startCol;
        for (int loopStartLine = startLine; loopStartLine < this.lines.size(); ++loopStartLine) {
            String line = this.lines.get(loopStartLine);
            Matcher matcher = regex.matcher(line);
            if (loopStartCol < line.length() && matcher.find(loopStartCol)) {
                return new Position(loopStartLine + 1, matcher.start() + 1);
            }
            loopStartCol = 0;
        }
        return null;
    }

    public Position searchBackward(int startLine, int startCol, Pattern regex) {
        int loopStartLine = startLine;
        int loopStartCol = startCol;
        while (loopStartLine >= 0) {
            String line = this.lines.get(loopStartLine);
            Matcher matcher = regex.matcher(line);
            if (loopStartCol >= line.length()) {
                loopStartCol = line.length() - 1;
            }
            if (loopStartCol >= 0 && matcher.find(loopStartCol)) {
                return new Position(loopStartLine + 1, matcher.start() + 1);
            }
            if (loopStartCol > 0) {
                --loopStartCol;
                continue;
            }
            --loopStartLine;
            loopStartCol = Integer.MAX_VALUE;
        }
        return null;
    }

    public List<List<DocElement>> pathsToDocElement(Function<DocElement, Boolean> pred) {
        return this.documentTree().pathsToValue(true, pred);
    }

    public List<DocElement> pathToDocElement(Function<DocElement, Boolean> pred) {
        List<List<DocElement>> paths = this.pathsToDocElement(pred);
        if (!paths.isEmpty()) {
            return paths.get(0);
        }
        return Collections.emptyList();
    }

    public List<DocElement> pathToDocElement(QName elementName, Position position) {
        return this.pathToDocElement(e -> e.qname().equals(elementName) && e.encloses(position));
    }

    public List<List<SchemaElement>> pathsToSchemaElement(Function<SchemaElement, Boolean> pred) {
        return this.schemaTree().pathsToValue(true, pred);
    }

    public List<SchemaElement> pathToSchemaElement(Function<SchemaElement, Boolean> pred) {
        List<List<SchemaElement>> paths = this.pathsToSchemaElement(pred);
        if (!paths.isEmpty()) {
            return paths.get(0);
        }
        return Collections.emptyList();
    }

    public List<SchemaElement> mapDocPathToSchemaPath(List<DocElement> path) {
        List pathQnames = path.stream().map(DocElement::qname).collect(Collectors.toList());
        QName elementName = (QName)pathQnames.get(pathQnames.size() - 1);
        return this.pathsToSchemaElement(e -> e.qname().equals(elementName)).stream().filter(p -> this.schemaPathWithPrefix((List<SchemaElement>)p).stream().map(SchemaElement::qname).collect(Collectors.toList()).equals(pathQnames)).findFirst().orElse(Collections.emptyList());
    }

    public List<SchemaElement> mapDocLocationToSchemaPath(QName elementName, Position position) {
        return this.mapDocPathToSchemaPath(this.pathToDocElement(elementName, position));
    }

    public List<List<DocElement>> docElementSiblings(List<DocElement> element, Function<DocElement, Boolean> pred) {
        List<DocElement> parentPath = element.subList(0, element.size() - 1);
        return this.pathsToDocElement(pred).stream().filter(p -> !p.equals(element)).filter(p -> p.subList(0, p.size() - 1).equals(parentPath)).collect(Collectors.toList());
    }

    public List<List<SchemaElement>> schemaElementSiblings(List<SchemaElement> element) {
        return this.schemaElementSiblings(element, __ -> true);
    }

    public List<List<SchemaElement>> schemaElementSiblings(List<SchemaElement> element, Function<SchemaElement, Boolean> pred) {
        List<SchemaElement> parentPath = element.subList(0, element.size() - 1);
        return this.pathsToSchemaElement(pred).stream().filter(p -> !p.equals(element)).filter(p -> p.subList(0, p.size() - 1).equals(parentPath)).collect(Collectors.toList());
    }

    private Tree<DocElement> documentTree() {
        if (this.walkedDoc == null) {
            this.walkedDoc = new DocWalker(this.document).walk();
        }
        return this.walkedDoc;
    }

    private Tree<SchemaElement> schemaTree() {
        if (this.walkedSchemas == null) {
            this.walkedSchemas = new SchemaWalker(this.schemas).walk();
        }
        return this.walkedSchemas;
    }
}

