/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.schema;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.projectodd.vdx.core.Tree;
import org.projectodd.vdx.core.schema.ComplexType;
import org.projectodd.vdx.core.schema.SchemaElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaWalker {
    private final Map<QName, ComplexType> types = new HashMap<QName, ComplexType>();
    private final Map<QName, SchemaElement> elements = new HashMap<QName, SchemaElement>();
    private final Map<String, URL> walkedSchemas = new HashMap<String, URL>();
    private final List<URL> schemaSources = new ArrayList<URL>();
    private final Tree<SchemaElement> tree = new Tree();

    public SchemaWalker(List<URL> schemas) {
        this.schemaSources.addAll(schemas);
    }

    public Tree<SchemaElement> walk() {
        if (this.walkedSchemas.isEmpty()) {
            this.schemaSources.forEach(this::walk);
        }
        this.resolveElementReferences(this.tree);
        this.applyBaseToTypes();
        this.applyTypesToElement(this.tree);
        return this.tree;
    }

    private void walk(final URL url) {
        if (this.walkedSchemas.containsValue(url)) {
            return;
        }
        final ArrayDeque<Tree<SchemaElement>> stack = new ArrayDeque<Tree<SchemaElement>>();
        stack.push(this.tree);
        DefaultHandler handler = new DefaultHandler(){
            private Map<String, String> namespaceMappings = null;
            private SchemaElement currentElement = null;
            private ComplexType currentType = null;
            private Deque<Tree<SchemaElement>> currentTypeElementsStack = null;
            private Tree<SchemaElement> currentTypeElementsTree = null;
            private int innerComplexTypeDepth = 0;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String nameAttr = attributes.getValue("name");
                switch (qName) {
                    case "xs:schema": {
                        String targetNS = attributes.getValue("targetNamespace");
                        this.namespaceMappings = SchemaWalker.this.extractNamespaceMappings(attributes);
                        this.namespaceMappings.put("DEFAULT", targetNS);
                        SchemaWalker.this.walkedSchemas.put(targetNS, url);
                        break;
                    }
                    case "xs:element": {
                        String refAttr = attributes.getValue("ref");
                        if (refAttr != null) {
                            this.currentElement = new SchemaElement(this.qname(refAttr), true);
                        } else {
                            QName elName = this.qname(nameAttr);
                            this.currentElement = new SchemaElement(elName, this.qname(attributes.getValue("type")));
                            SchemaWalker.this.elements.put(elName, this.currentElement);
                        }
                        this.activeStack().push(this.activeStack().peek().addChild(this.currentElement));
                        break;
                    }
                    case "xs:attribute": {
                        if (this.currentType != null) {
                            this.currentType.addAttribute(nameAttr);
                            break;
                        }
                        if (this.currentElement == null) break;
                        this.currentElement.addAttribute(nameAttr);
                        break;
                    }
                    case "xs:complexType": {
                        if (nameAttr != null) {
                            QName nameQName = this.qname(nameAttr);
                            this.currentType = (ComplexType)SchemaWalker.this.types.get(nameQName);
                            if (this.currentType == null) {
                                this.currentType = new ComplexType(nameQName);
                                SchemaWalker.this.types.put(nameQName, this.currentType);
                            }
                            this.currentTypeElementsStack = new ArrayDeque<Tree<SchemaElement>>();
                            this.currentTypeElementsTree = new Tree();
                            this.currentTypeElementsStack.push(this.currentTypeElementsTree);
                            break;
                        }
                        ++this.innerComplexTypeDepth;
                        break;
                    }
                    case "xs:extension": {
                        QName base = this.qname(attributes.getValue("base"));
                        if (this.currentType != null) {
                            this.currentType.base(base);
                            break;
                        }
                        if (this.currentElement == null) break;
                        this.currentElement.base(base);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                switch (qName) {
                    case "xs:element": {
                        if (this.activeStack().peek().value() != null && this.currentElement.name().equals(this.activeStack().peek().value().name())) {
                            this.activeStack().pop();
                            this.currentElement = this.activeStack().peek().value();
                            break;
                        }
                        this.currentElement = null;
                        break;
                    }
                    case "xs:complexType": {
                        if (this.innerComplexTypeDepth > 0) {
                            --this.innerComplexTypeDepth;
                            break;
                        }
                        if (this.currentType == null) break;
                        this.currentType.setElements(this.currentTypeElementsTree);
                        this.currentTypeElementsStack = null;
                        this.currentTypeElementsTree = null;
                        this.currentType = null;
                    }
                }
            }

            private QName qname(String name) {
                String local;
                String uri;
                if (name == null) {
                    return null;
                }
                if (name.contains(":")) {
                    String[] parts = name.split(":");
                    uri = this.namespaceMappings.get(parts[0]);
                    local = parts[1];
                } else {
                    uri = this.namespaceMappings.get("DEFAULT");
                    local = name;
                }
                return new QName(uri, local);
            }

            private Deque<Tree<SchemaElement>> activeStack() {
                return this.currentTypeElementsStack == null ? stack : this.currentTypeElementsStack;
            }
        };
        try (InputStream in = url.openStream();){
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(in));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> extractNamespaceMappings(Attributes attributes) {
        HashMap<String, String> namespaceMappings = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrName = attributes.getQName(i);
            if (attrName.equals("xmlns")) {
                namespaceMappings.put("DEFAULT", attributes.getValue(i));
                continue;
            }
            if (!attrName.startsWith("xmlns:")) continue;
            String[] parts = attrName.split(":");
            namespaceMappings.put(parts[1], attributes.getValue(i));
        }
        return namespaceMappings;
    }

    private void applyBaseToTypes() {
        this.types.values().stream().filter(type -> type.base() != null).forEach(type -> {
            ComplexType baseType = this.types.get(type.base());
            if (baseType != null) {
                baseType.elements().children().forEach(t -> type.elements().addChild((SchemaElement)((Object)t)));
                baseType.attributes().forEach(type::addAttribute);
            }
        });
    }

    private void resolveElementReferences(Tree<SchemaElement> tree) {
        SchemaElement el = tree.value();
        if (el != null && el.isReference()) {
            SchemaElement realEl = this.elements.get(el.qname());
            el.delegate(realEl);
        }
        tree.children().forEach(this::resolveElementReferences);
    }

    private void applyTypesToElement(Tree<SchemaElement> tree) {
        SchemaElement el = tree.value();
        if (el != null) {
            if (el.base() != null) {
                this.applyTypeToElement(this.types.get(el.base()), tree);
            }
            if (el.type() != null) {
                this.applyTypeToElement(this.types.get(el.type()), tree);
            }
        }
        tree.children().forEach(this::applyTypesToElement);
    }

    private void applyTypeToElement(ComplexType type, Tree<SchemaElement> tree) {
        if (type != null && !tree.value().isTypeApplied(type.name())) {
            tree.value().addAppliedType(type.name());
            tree.value().addAttributes(type.attributes());
            type.elements().children().forEach(tree::addChild);
        }
    }
}

