/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import org.wildfly.common.Assert;

@FunctionalInterface
public interface NameRewriter {
    public static final NameRewriter IDENTITY_REWRITER = original -> original;

    public String rewriteName(String var1);

    public static NameRewriter chain(NameRewriter rewriter1, NameRewriter rewriter2) {
        Assert.checkNotNullParam("rewriter1", rewriter1);
        Assert.checkNotNullParam("rewriter2", rewriter2);
        return n -> {
            if (n != null) {
                n = rewriter1.rewriteName(n);
            }
            if (n != null) {
                n = rewriter2.rewriteName(n);
            }
            return n;
        };
    }

    public static NameRewriter chain(NameRewriter ... nameRewriters) {
        Assert.checkNotNullParam("nameRewriters", nameRewriters);
        NameRewriter[] clone = (NameRewriter[])nameRewriters.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam("nameRewriters", i, clone[i]);
        }
        return n -> {
            for (NameRewriter r : clone) {
                if (n == null) {
                    return null;
                }
                n = r.rewriteName(n);
            }
            return n;
        };
    }

    public static NameRewriter aggregate(NameRewriter rewriter1, NameRewriter rewriter2) {
        Assert.checkNotNullParam("rewriter1", rewriter1);
        Assert.checkNotNullParam("rewriter2", rewriter2);
        return n -> {
            String rn = rewriter1.rewriteName(n);
            if (rn == null) {
                rn = rewriter2.rewriteName(n);
            }
            return rn;
        };
    }

    public static NameRewriter aggregate(NameRewriter ... nameRewriters) {
        Assert.checkNotNullParam("nameRewriters", nameRewriters);
        NameRewriter[] clone = (NameRewriter[])nameRewriters.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam("nameRewriters", i, clone[i]);
        }
        return n -> {
            if (n == null) {
                return null;
            }
            for (NameRewriter r : clone) {
                String rn = r.rewriteName(n);
                if (rn == null) continue;
                return rn;
            }
            return null;
        };
    }

    public static NameRewriter constant(String name) {
        return original -> name;
    }
}

