/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.JmxTarget;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.RunAsRolePermission;
import org.jboss.as.controller.access.rbac.StandardRole;
import org.jboss.as.controller.logging.ControllerLogger;

public class StandardRoleMapper
implements RoleMapper {
    private static final String IN_VM_ROLE = StandardRole.SUPERUSER.getOfficialForm();
    private static final RunAsRolePermission RUN_AS_IN_VM_ROLE = new RunAsRolePermission(IN_VM_ROLE);
    private final AuthorizerConfiguration authorizerConfiguration;

    public StandardRoleMapper(AuthorizerConfiguration authorizerConfiguration) {
        this.authorizerConfiguration = authorizerConfiguration;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetAttribute attribute) {
        return this.mapRoles(caller);
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetResource resource) {
        return this.mapRoles(caller);
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, JmxAction action, JmxTarget target) {
        return this.mapRoles(caller);
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Set<String> operationHeaderRoles) {
        return this.mapRoles(caller);
    }

    @Override
    public boolean canRunAs(Set<String> mappedRoles, String runAsRole) {
        if (runAsRole == null) {
            return false;
        }
        boolean hasRole = this.authorizerConfiguration.hasRole(runAsRole);
        boolean isSuperUser = mappedRoles.contains(StandardRole.SUPERUSER.toString());
        if (isSuperUser && !hasRole) {
            throw ControllerLogger.ROOT_LOGGER.unknownRole(runAsRole);
        }
        return hasRole && isSuperUser;
    }

    private Set<String> mapRoles(Caller caller) {
        HashSet<String> mappedRoles = new HashSet<String>();
        boolean traceEnabled = ControllerLogger.ACCESS_LOGGER.isTraceEnabled();
        if (caller.hasSubject()) {
            Map<String, AuthorizerConfiguration.RoleMapping> rolesToCheck;
            if (this.authorizerConfiguration.isMapUsingRealmRoles()) {
                rolesToCheck = new HashMap<String, AuthorizerConfiguration.RoleMapping>(this.authorizerConfiguration.getRoleMappings());
                Set<String> realmRoles = caller.getAssociatedRoles();
                for (String current : realmRoles) {
                    String roleName = current.toUpperCase(Locale.ENGLISH);
                    if (rolesToCheck.containsKey(roleName)) {
                        AuthorizerConfiguration.RoleMapping roleMapping = rolesToCheck.remove(roleName);
                        AuthorizerConfiguration.MappingPrincipal exclusion = roleMapping.isExcluded(caller);
                        if (exclusion == null) {
                            if (traceEnabled) {
                                ControllerLogger.ACCESS_LOGGER.tracef("User '%s' assigned role '%s' due to realm assignment and no exclusion in role mapping definition.", (Object)caller.getName(), (Object)roleName);
                            }
                            mappedRoles.add(roleName);
                            continue;
                        }
                        if (!traceEnabled) continue;
                        ControllerLogger.ACCESS_LOGGER.tracef("User '%s' NOT assigned role '%s' despite realm assignment due to exclusion match against %s.", (Object)caller.getName(), (Object)roleName, (Object)exclusion);
                        continue;
                    }
                    if (traceEnabled) {
                        ControllerLogger.ACCESS_LOGGER.tracef("User '%s' assigned role '%s' due to realm assignment and no role mapping to check for exclusion.", (Object)caller.getName(), (Object)roleName);
                    }
                    mappedRoles.add(roleName);
                }
            } else {
                rolesToCheck = this.authorizerConfiguration.getRoleMappings();
            }
            for (AuthorizerConfiguration.RoleMapping roleMapping : rolesToCheck.values()) {
                AuthorizerConfiguration.MappingPrincipal inclusion;
                boolean includeAll = roleMapping.includeAllAuthedUsers();
                AuthorizerConfiguration.MappingPrincipal mappingPrincipal = inclusion = !includeAll ? roleMapping.isIncluded(caller) : null;
                if (includeAll || inclusion != null) {
                    AuthorizerConfiguration.MappingPrincipal exclusion = roleMapping.isExcluded(caller);
                    if (exclusion == null) {
                        if (traceEnabled) {
                            if (includeAll) {
                                ControllerLogger.ACCESS_LOGGER.tracef("User '%s' assiged role '%s' due to include-all set on role.", (Object)caller.getName(), (Object)roleMapping.getName());
                            } else {
                                ControllerLogger.ACCESS_LOGGER.tracef("User '%s' assiged role '%s' due to match on inclusion %s", (Object)caller.getName(), (Object)roleMapping.getName(), (Object)inclusion);
                            }
                        }
                        mappedRoles.add(roleMapping.getName());
                        continue;
                    }
                    if (!traceEnabled) continue;
                    ControllerLogger.ACCESS_LOGGER.tracef("User '%s' denied membership of role '%s' due to exclusion %s", (Object)caller.getName(), (Object)roleMapping.getName(), (Object)exclusion);
                    continue;
                }
                if (!traceEnabled) continue;
                ControllerLogger.ACCESS_LOGGER.tracef("User '%s' not assigned role '%s' as no match on the include definition of the role mapping.", (Object)caller.getName(), (Object)roleMapping.getName());
            }
        } else {
            StandardRoleMapper.checkPermission(RUN_AS_IN_VM_ROLE);
            ControllerLogger.ACCESS_LOGGER.tracef("Assigning role '%s' for call with no assigned Subject (An IN-VM Call).", (Object)IN_VM_ROLE);
            mappedRoles.add(IN_VM_ROLE);
        }
        if (traceEnabled) {
            StringBuilder sb = new StringBuilder("User '").append(caller.getName()).append("' Assigned Roles { ");
            for (String string : mappedRoles) {
                sb.append("'").append(string).append("' ");
            }
            sb.append("}");
            ControllerLogger.ACCESS_LOGGER.trace(sb.toString());
        }
        return Collections.unmodifiableSet(mappedRoles);
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

