/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.management.ManagementWriteAttributeHandler;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class BaseNativeInterfaceResourceDefinition
extends SimpleResourceDefinition {
    protected static final String RUNTIME_CAPABILITY_NAME = "org.wildfly.management.native-interface";
    public static final RuntimeCapability<Void> NATIVE_MANAGEMENT_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.management.native-interface").build();
    protected static final PathElement RESOURCE_PATH = PathElement.pathElement("management-interface", "native-interface");
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setFlags(AttributeAccess.Flag.RESTART_ALL_SERVICES)).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF)).setNullSignificant(true)).build();
    public static final SimpleAttributeDefinition SERVER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-name", ModelType.STRING, true).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).build();
    public static final SimpleAttributeDefinition SASL_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-protocol", ModelType.STRING, true).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setDefaultValue(new ModelNode("remote"))).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).build();
    protected static final AttributeDefinition[] COMMON_ATTRIBUTES = new AttributeDefinition[]{SECURITY_REALM, SERVER_NAME, SASL_PROTOCOL};

    protected BaseNativeInterfaceResourceDefinition(SimpleResourceDefinition.Parameters parameters) {
        super(parameters.addAccessConstraints(SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES).addCapabilities(NATIVE_MANAGEMENT_CAPABILITY).setDeprecatedSince(ModelVersion.create(1, 7)));
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        AttributeDefinition[] attributeDefinitions = this.getAttributeDefinitions();
        ManagementWriteAttributeHandler writeHandler = new ManagementWriteAttributeHandler(attributeDefinitions);
        for (AttributeDefinition attr : attributeDefinitions) {
            resourceRegistration.registerReadWriteAttribute(attr, null, writeHandler);
        }
    }

    @Override
    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(NATIVE_MANAGEMENT_CAPABILITY);
    }

    protected abstract AttributeDefinition[] getAttributeDefinitions();

    protected static AttributeDefinition[] combine(AttributeDefinition[] commonAttributes, AttributeDefinition ... additionalAttributes) {
        AttributeDefinition[] combined = new AttributeDefinition[commonAttributes.length + additionalAttributes.length];
        System.arraycopy(commonAttributes, 0, combined, 0, commonAttributes.length);
        System.arraycopy(additionalAttributes, 0, combined, commonAttributes.length, additionalAttributes.length);
        return combined;
    }
}

