/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceProvider;
import org.jboss.dmr.ModelNode;

public class DelegatingResource
extends ResourceProvider.ResourceProviderRegistry
implements Resource {
    private final ResourceDelegateProvider delegateProvider;

    public DelegatingResource(final Resource delegate) {
        this(new ResourceDelegateProvider(){

            @Override
            public Resource getDelegateResource() {
                return delegate;
            }
        });
    }

    public DelegatingResource(ResourceDelegateProvider delegateProvider) {
        assert (delegateProvider != null);
        assert (delegateProvider.getDelegateResource() != null);
        this.delegateProvider = delegateProvider;
    }

    @Override
    public Resource clone() {
        return this.getDelegate().clone();
    }

    @Override
    public Resource getChild(PathElement element) {
        return this.getDelegate().getChild(element);
    }

    @Override
    public Set<Resource.ResourceEntry> getChildren(String childType) {
        return this.getDelegate().getChildren(childType);
    }

    @Override
    public Set<String> getChildrenNames(String childType) {
        return this.getDelegate().getChildrenNames(childType);
    }

    @Override
    public Set<String> getChildTypes() {
        return this.getDelegate().getChildTypes();
    }

    @Override
    public ModelNode getModel() {
        return this.getDelegate().getModel();
    }

    @Override
    public boolean hasChild(PathElement element) {
        return this.getDelegate().hasChild(element);
    }

    @Override
    public boolean hasChildren(String childType) {
        return this.getDelegate().hasChildren(childType);
    }

    @Override
    public boolean isModelDefined() {
        return this.getDelegate().isModelDefined();
    }

    @Override
    public boolean isProxy() {
        return this.getDelegate().isProxy();
    }

    @Override
    public boolean isRuntime() {
        return this.getDelegate().isRuntime();
    }

    @Override
    public Resource navigate(PathAddress address) {
        return this.getDelegate().navigate(address);
    }

    @Override
    public void registerChild(PathElement address, Resource resource) {
        this.getDelegate().registerChild(address, resource);
    }

    @Override
    public void registerChild(PathElement address, int index, Resource resource) {
        this.getDelegate().registerChild(address, index, resource);
    }

    @Override
    public Resource removeChild(PathElement address) {
        return this.getDelegate().removeChild(address);
    }

    @Override
    public Resource requireChild(PathElement element) {
        return this.getDelegate().requireChild(element);
    }

    @Override
    public void writeModel(ModelNode newModel) {
        this.getDelegate().writeModel(newModel);
    }

    private Resource getDelegate() {
        return this.delegateProvider.getDelegateResource();
    }

    @Override
    protected void registerResourceProvider(String type, ResourceProvider provider) {
        ResourceProvider.Tool.addResourceProvider(type, provider, this.getDelegate());
    }

    @Override
    public Set<String> getOrderedChildTypes() {
        return this.getDelegate().getOrderedChildTypes();
    }

    public static interface ResourceDelegateProvider {
        public Resource getDelegateResource();
    }
}

