/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.management.PatchResourceDefinition;
import org.jboss.as.patching.management.PatchStreamResourceOperationStepHandler;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.dmr.ModelNode;

public class PatchInfoHandler
extends PatchStreamResourceOperationStepHandler {
    public static final PatchInfoHandler INSTANCE = new PatchInfoHandler();

    @Override
    protected void execute(OperationContext context, ModelNode operation, InstalledIdentity installedIdentity) throws OperationFailedException {
        String patchId;
        ModelNode patchIdNode = PatchResourceDefinition.PATCH_ID_OPTIONAL.resolveModelAttribute(context, operation);
        String string = patchId = patchIdNode.isDefined() ? patchIdNode.asString() : null;
        if (patchId == null) {
            ModelNode readResource = new ModelNode();
            readResource.get("address").set(operation.get("address"));
            readResource.get("operation").set("read-resource");
            readResource.get("recursive").set(true);
            readResource.get("include-runtime").set(true);
            OperationStepHandler readResHandler = context.getRootResourceRegistration().getOperationHandler(PathAddress.EMPTY_ADDRESS, "read-resource");
            context.addStep(readResource, readResHandler, OperationContext.Stage.MODEL);
        } else {
            PatchableTarget.TargetInfo info;
            boolean verbose = PatchResourceDefinition.VERBOSE.resolveModelAttribute(context, operation).asBoolean();
            try {
                info = installedIdentity.getIdentity().loadTargetInfo();
            }
            catch (Exception e) {
                throw new OperationFailedException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(installedIdentity.getIdentity().getName()), e);
            }
            PatchingHistory.Iterator i = PatchingHistory.Factory.iterator(installedIdentity, info);
            ModelNode result = this.patchIdInfo(context, patchId, verbose, i);
            if (result == null) {
                context.getFailureDescription().set(PatchLogger.ROOT_LOGGER.patchNotFoundInHistory(patchId).getLocalizedMessage());
            }
            context.getResult().set(result);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected ModelNode patchIdInfo(OperationContext context, String patchId, boolean verbose, PatchingHistory.Iterator i) {
        while (i.hasNext()) {
            PatchingHistory.Entry entry = (PatchingHistory.Entry)i.next();
            if (!patchId.equals(entry.getPatchId())) continue;
            ModelNode result = new ModelNode();
            result.get("patch-id").set(entry.getPatchId());
            result.get("type").set(entry.getType().getName());
            result.get("description").set(entry.getMetadata().getDescription());
            String link = entry.getMetadata().getLink();
            if (link != null) {
                result.get("link").set(link);
            }
            Identity identity = entry.getMetadata().getIdentity();
            result.get("identity-name").set(identity.getName());
            result.get("identity-version").set(identity.getVersion());
            if (verbose) {
                ModelNode list = result.get("elements").setEmptyList();
                Patch metadata = entry.getMetadata();
                for (PatchElement e : metadata.getElements()) {
                    ModelNode element = new ModelNode();
                    element.get("patch-id").set(e.getId());
                    element.get("type").set(e.getProvider().isAddOn() ? "add-on" : "layer");
                    element.get("name").set(e.getProvider().getName());
                    element.get("description").set(e.getDescription());
                    list.add(element);
                }
            }
            return result;
        }
        return null;
    }
}

