/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Set;
import org.jboss.modules.ClassLoaderLocalLoader;
import org.jboss.modules.Dependency;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoaderDependency;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.ClassFilters;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public abstract class DependencySpec {
    final PathFilter importFilter;
    final PathFilter exportFilter;
    final PathFilter resourceImportFilter;
    final PathFilter resourceExportFilter;
    final ClassFilter classImportFilter;
    final ClassFilter classExportFilter;

    public PathFilter getImportFilter() {
        return this.importFilter;
    }

    public PathFilter getExportFilter() {
        return this.exportFilter;
    }

    public PathFilter getResourceImportFilter() {
        return this.resourceImportFilter;
    }

    public PathFilter getResourceExportFilter() {
        return this.resourceExportFilter;
    }

    public ClassFilter getClassImportFilter() {
        return this.classImportFilter;
    }

    public ClassFilter getClassExportFilter() {
        return this.classExportFilter;
    }

    DependencySpec(PathFilter importFilter, PathFilter exportFilter) {
        this(importFilter, exportFilter, PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll());
    }

    DependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter) {
        this.importFilter = importFilter;
        this.exportFilter = exportFilter;
        this.resourceImportFilter = resourceImportFilter;
        this.resourceExportFilter = resourceExportFilter;
        this.classImportFilter = classImportFilter;
        this.classExportFilter = classExportFilter;
    }

    abstract Dependency getDependency(Module var1);

    public static DependencySpec createLocalDependencySpec() {
        return DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll());
    }

    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter) {
        if (importFilter == null) {
            throw new IllegalArgumentException("importFilter is null");
        }
        if (exportFilter == null) {
            throw new IllegalArgumentException("exportFilter is null");
        }
        return new DependencySpec(importFilter, exportFilter){

            @Override
            Dependency getDependency(Module module) {
                return new ModuleClassLoaderDependency(this.exportFilter, this.importFilter, module.getClassLoaderPrivate());
            }

            public String toString() {
                return "dependency on local resources";
            }
        };
    }

    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter) {
        if (importFilter == null) {
            throw new IllegalArgumentException("importFilter is null");
        }
        if (exportFilter == null) {
            throw new IllegalArgumentException("exportFilter is null");
        }
        if (classImportFilter == null) {
            throw new IllegalArgumentException("classImportFilter is null");
        }
        if (classExportFilter == null) {
            throw new IllegalArgumentException("classExportFilter is null");
        }
        if (resourceImportFilter == null) {
            throw new IllegalArgumentException("resourceImportFilter is null");
        }
        if (resourceExportFilter == null) {
            throw new IllegalArgumentException("resourceExportFilter is null");
        }
        return new DependencySpec(importFilter, exportFilter, resourceImportFilter, resourceExportFilter, classImportFilter, classExportFilter){

            @Override
            Dependency getDependency(Module module) {
                return new ModuleClassLoaderDependency(this.exportFilter, this.importFilter, this.resourceExportFilter, this.resourceImportFilter, this.classExportFilter, this.classImportFilter, module.getClassLoaderPrivate());
            }

            public String toString() {
                return "dependency on filtered local resources";
            }
        };
    }

    public static DependencySpec createSystemDependencySpec(Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(ClassLoaderLocalLoader.SYSTEM, loaderPaths);
    }

    public static DependencySpec createSystemDependencySpec(Set<String> loaderPaths, boolean export) {
        return DependencySpec.createLocalDependencySpec(ClassLoaderLocalLoader.SYSTEM, loaderPaths, export);
    }

    public static DependencySpec createSystemDependencySpec(PathFilter importFilter, PathFilter exportFilter, Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(importFilter, exportFilter, ClassLoaderLocalLoader.SYSTEM, loaderPaths);
    }

    public static DependencySpec createClassLoaderDependencySpec(ClassLoader classLoader, Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(new ClassLoaderLocalLoader(classLoader), loaderPaths);
    }

    public static DependencySpec createClassLoaderDependencySpec(ClassLoader classLoader, Set<String> loaderPaths, boolean export) {
        return DependencySpec.createLocalDependencySpec(new ClassLoaderLocalLoader(classLoader), loaderPaths, export);
    }

    public static DependencySpec createClassLoaderDependencySpec(PathFilter importFilter, PathFilter exportFilter, ClassLoader classLoader, Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(importFilter, exportFilter, PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), new ClassLoaderLocalLoader(classLoader), loaderPaths);
    }

    public static DependencySpec createLocalDependencySpec(LocalLoader localLoader, Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), PathFilters.rejectAll(), localLoader, loaderPaths);
    }

    public static DependencySpec createLocalDependencySpec(LocalLoader localLoader, Set<String> loaderPaths, boolean export) {
        return DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), export ? PathFilters.getDefaultImportFilter() : PathFilters.rejectAll(), localLoader, loaderPaths);
    }

    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter, LocalLoader localLoader, Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(importFilter, exportFilter, PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), localLoader, loaderPaths);
    }

    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter, final LocalLoader localLoader, final Set<String> loaderPaths) {
        if (importFilter == null) {
            throw new IllegalArgumentException("importFilter is null");
        }
        if (exportFilter == null) {
            throw new IllegalArgumentException("exportFilter is null");
        }
        if (localLoader == null) {
            throw new IllegalArgumentException("localLoader is null");
        }
        if (loaderPaths == null) {
            throw new IllegalArgumentException("loaderPaths is null");
        }
        if (classImportFilter == null) {
            throw new IllegalArgumentException("classImportFilter is null");
        }
        if (classExportFilter == null) {
            throw new IllegalArgumentException("classExportFilter is null");
        }
        if (resourceImportFilter == null) {
            throw new IllegalArgumentException("resourceImportFilter is null");
        }
        if (resourceExportFilter == null) {
            throw new IllegalArgumentException("resourceExportFilter is null");
        }
        return new DependencySpec(importFilter, exportFilter, resourceImportFilter, resourceExportFilter, classImportFilter, classExportFilter){

            @Override
            Dependency getDependency(Module module) {
                return new LocalDependency(this.exportFilter, this.importFilter, this.resourceExportFilter, this.resourceImportFilter, this.classExportFilter, this.classImportFilter, localLoader, loaderPaths);
            }

            public String toString() {
                return "dependency on local loader " + localLoader;
            }
        };
    }

    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier) {
        return DependencySpec.createModuleDependencySpec(identifier, false);
    }

    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier, boolean export) {
        return DependencySpec.createModuleDependencySpec(identifier, export, false);
    }

    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier, boolean export, boolean optional) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), export ? PathFilters.acceptAll() : PathFilters.rejectAll(), null, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean export) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), export ? PathFilters.acceptAll() : PathFilters.rejectAll(), moduleLoader, identifier, false);
    }

    public static DependencySpec createModuleDependencySpec(ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean export, boolean optional) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), export ? PathFilters.acceptAll() : PathFilters.rejectAll(), moduleLoader, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(PathFilter exportFilter, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), exportFilter, null, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(PathFilter exportFilter, ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), exportFilter, moduleLoader, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(importFilter, exportFilter, PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), moduleLoader, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter, ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional) {
        if (importFilter == null) {
            throw new IllegalArgumentException("importFilter is null");
        }
        if (exportFilter == null) {
            throw new IllegalArgumentException("exportFilter is null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("identifier is null");
        }
        if (classImportFilter == null) {
            throw new IllegalArgumentException("classImportFilter is null");
        }
        if (classExportFilter == null) {
            throw new IllegalArgumentException("classExportFilter is null");
        }
        if (resourceImportFilter == null) {
            throw new IllegalArgumentException("resourceImportFilter is null");
        }
        if (resourceExportFilter == null) {
            throw new IllegalArgumentException("resourceExportFilter is null");
        }
        return new ModuleDependencySpec(importFilter, exportFilter, resourceImportFilter, resourceExportFilter, classImportFilter, classExportFilter, moduleLoader, identifier, optional);
    }
}

