/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Message;
import org.projectodd.vdx.core.Printer;
import org.projectodd.vdx.core.Stringifier;
import org.projectodd.vdx.core.Stringify;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;
import org.projectodd.vdx.core.schema.SchemaPathGate;
import org.projectodd.vdx.core.schema.SchemaPathPrefixProvider;

public class ErrorPrinter {
    private static final int CONTEXT_LINES = 3;
    private final Pattern LEADING_WHITESPACE_RE = Pattern.compile("^([ ]+)");
    private static final String POINTER = "^^^^";
    private static final char DASH = '=';
    private final URL docURL;
    private final ValidationContext context;
    private Printer printer = Printer.DEFAULT_PRINTER;

    public ErrorPrinter(URL document, List<URL> schemas) throws IOException {
        this.context = new ValidationContext(document, schemas);
        this.docURL = document;
    }

    public void print(ValidationError error) {
        ErrorHandler.HandledResult res = this.context.handle(error);
        if (res != null) {
            String[] docPathParts = this.docURL.getPath().split(File.separator);
            StringBuilder out = new StringBuilder().append('\n').append(this.divider(I18N.validationErrorIn(docPathParts[docPathParts.length - 1])));
            this.formatResult(out, res);
            out.append(this.divider()).append('\n');
            this.printer.println(out.toString());
        }
    }

    public ErrorPrinter printer(Printer printer) {
        if (printer == null) {
            throw new IllegalArgumentException("printer can't be null");
        }
        this.printer = printer;
        return this;
    }

    public ErrorPrinter stringifiers(List<Stringifier> stringifiers) {
        if (stringifiers != null) {
            stringifiers.forEach(Stringify::registerStringifier);
        }
        return this;
    }

    public ErrorPrinter pathGate(SchemaPathGate gate) {
        this.context.pathGate(gate);
        return this;
    }

    public ErrorPrinter prefixProvider(SchemaPathPrefixProvider prefixProvider) {
        this.context.prefixProvider(prefixProvider);
        return this;
    }

    private void formatResult(StringBuilder out, ErrorHandler.HandledResult result) {
        int linum = result.line();
        int maxLinumWidth = ("" + linum + 3).length();
        List<PrefixedLine> preambleLines = this.preambleLines(linum, maxLinumWidth);
        List<PrefixedLine> postambleLines = this.postambleLines(linum, maxLinumWidth);
        ArrayList<PrefixedLine> allLines = new ArrayList<PrefixedLine>();
        allLines.addAll(preambleLines);
        allLines.addAll(postambleLines);
        int removeSpaces = this.smallestPrefixWhitespace(allLines);
        out.append('\n').append(Util.withPrefix(" ", this.ambleString(preambleLines, removeSpaces))).append(this.alignPointerMessage(maxLinumWidth + result.column() + 2 - removeSpaces, result.primaryMessages())).append("\n").append(Util.withPrefix(" ", this.ambleString(postambleLines, removeSpaces)));
        if (!result.secondaryMessages().isEmpty()) {
            result.secondaryMessages().forEach(m -> out.append("\n").append(Util.withPrefix(" ", m.toString())).append("\n"));
        }
        if (!result.secondaryResults().isEmpty()) {
            result.secondaryResults().forEach(r -> this.formatResult(out, (ErrorHandler.HandledResult)r));
        } else {
            out.append("\n");
        }
        if (result.originalMessage() != null) {
            out.append(Util.withPrefix(" ", I18N.lookup(I18N.Key.ORIGINAL_ERROR))).append("\n").append(Util.withPrefix(" > ", result.originalMessage())).append("\n\n");
        }
    }

    private String linumPrefix(int linum, int maxWidth) {
        return String.format("%" + maxWidth + "s: ", linum + 1);
    }

    private List<PrefixedLine> extractLines(int maxLinumWidth, int start, int end) {
        ArrayList<PrefixedLine> ret = new ArrayList<PrefixedLine>();
        int linum = start;
        for (String line : this.context.extractLines(start, end)) {
            ret.add(new PrefixedLine(this.linumPrefix(linum, maxLinumWidth), line));
            ++linum;
        }
        return ret;
    }

    private List<PrefixedLine> preambleLines(int linum, int maxLinumWidth) {
        return this.extractLines(maxLinumWidth, 3 > linum ? 0 : linum - 3, linum);
    }

    private List<PrefixedLine> postambleLines(int linum, int maxLinumWidth) {
        return this.extractLines(maxLinumWidth, linum, 3 + linum > this.context.documentLineCount() ? this.context.documentLineCount() : linum + 3);
    }

    private int smallestPrefixWhitespace(List<PrefixedLine> lines) {
        int size = Integer.MAX_VALUE;
        for (PrefixedLine line : lines) {
            Matcher m = this.LEADING_WHITESPACE_RE.matcher(line.line);
            if (m.find()) {
                int len = m.group(1).length();
                size = len < size ? len : size;
                continue;
            }
            size = 0;
        }
        return size;
    }

    private String ambleString(List<PrefixedLine> lines, int removePrefixChars) {
        StringBuilder sb = new StringBuilder();
        lines.forEach(l -> sb.append(l.asString(removePrefixChars)).append('\n'));
        return sb.toString();
    }

    private String alignPointerMessage(int length, List<Message> msg) {
        if (msg.isEmpty()) {
            return String.format("%" + (length + POINTER.length()) + "s\n", POINTER);
        }
        String[] lines = String.join((CharSequence)"\n", msg.stream().map(Object::toString).collect(Collectors.toList())).split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%" + (length + lines[0].length() + POINTER.length() + 1) + "s", "^^^^ " + lines[0])).append('\n');
        for (int i = 1; i < lines.length; ++i) {
            sb.append(String.format("%" + (length + lines[i].length() + POINTER.length() + 1) + "s", lines[i])).append('\n');
        }
        return sb.toString();
    }

    private String divider() {
        return this.divider(null);
    }

    private String divider(String heading) {
        int dashes = heading != null ? 80 - heading.length() - 1 : 80;
        StringBuilder ret = new StringBuilder();
        if (heading != null) {
            ret.append(heading).append(' ');
        }
        for (int i = 0; i < dashes; ++i) {
            ret.append('=');
        }
        return ret.append('\n').toString();
    }

    private class PrefixedLine {
        public final String prefix;
        public final String line;

        PrefixedLine(String prefix, String line) {
            this.prefix = prefix;
            this.line = line.replaceAll("\t", "  ");
        }

        String asString(int removePrefixChars) {
            return String.format("%s%s", this.prefix, this.line.substring(removePrefixChars));
        }
    }
}

