/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.handlers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.projectodd.vdx.core.DocElement;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.ErrorType;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;
import org.projectodd.vdx.core.handlers.DuplicateElementHandler;
import org.projectodd.vdx.core.schema.SchemaElement;

public class UnexpectedElementHandler
implements ErrorHandler {
    @Override
    public ErrorHandler.HandledResult handle(ValidationContext ctx, ValidationError error) {
        QName el = error.element();
        String elName = el.getLocalPart();
        List<List<SchemaElement>> altElements = ctx.alternateElementsForElement(el);
        List<DocElement> path = ctx.pathToDocElement(e -> e.qname().equals(el) && e.encloses(error.position()));
        if (!path.isEmpty() && !ctx.docElementSiblings(path, e -> e.qname().equals(el)).isEmpty()) {
            return new DuplicateElementHandler().handle(ctx, ValidationError.from(error, ErrorType.DUPLICATE_ELEMENT).element(error.element()));
        }
        ErrorHandler.HandledResult response = ErrorHandler.HandledResult.from(error).primaryMessage(I18N.Key.ELEMENT_NOT_ALLOWED, elName);
        List<Object> otherElements = Collections.emptyList();
        if (error.alternatives().isEmpty()) {
            List<SchemaElement> schemaPath;
            List<DocElement> pathToDocElement = ctx.pathToDocElement(el, error.position());
            if (!pathToDocElement.isEmpty() && !(schemaPath = ctx.mapDocPathToSchemaPath(pathToDocElement.subList(0, pathToDocElement.size() - 1))).isEmpty()) {
                otherElements = Util.asSortedList(ctx.elementsForElement(schemaPath).stream().map(SchemaElement::name).collect(Collectors.toList()));
            }
        } else {
            otherElements = Util.asSortedList(error.alternatives());
        }
        if (!altElements.isEmpty()) {
            response.secondaryMessage(I18N.Key.ELEMENT_IS_ALLOWED_ON, elName, altElements);
        }
        if (!otherElements.isEmpty()) {
            response.primaryMessage(I18N.Key.ELEMENTS_ALLOWED_HERE, otherElements);
            String altSpelling = Util.alternateSpelling(elName, otherElements);
            if (altSpelling != null) {
                response.primaryMessage(I18N.Key.DID_YOU_MEAN, altSpelling);
            }
        }
        return response;
    }
}

