/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.Location;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Message;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;

public interface ErrorHandler {
    public HandledResult handle(ValidationContext var1, ValidationError var2);

    public static class HandledResult {
        private int line;
        private int column;
        private final String originalMessage;
        private List<Message> primaryMessages = new ArrayList<Message>();
        private List<Message> secondaryMessages = new ArrayList<Message>();
        private List<HandledResult> secondaryResults = new ArrayList<HandledResult>();

        public HandledResult(int line, int column, String originalMessage) {
            this.line = line;
            this.column = column;
            this.originalMessage = originalMessage;
        }

        public static HandledResult from(ValidationError err) {
            Location loc = err.location();
            return new HandledResult(loc.getLineNumber(), loc.getColumnNumber(), err.message());
        }

        public HandledResult line(int line) {
            this.line = line;
            return this;
        }

        public HandledResult column(int column) {
            this.column = column;
            return this;
        }

        public HandledResult primaryMessage(Message message) {
            if (message != null) {
                this.primaryMessages.add(message);
            }
            return this;
        }

        public HandledResult primaryMessage(I18N.Key key, Object ... args) {
            return this.primaryMessage(new Message(key, args));
        }

        public List<Message> primaryMessages() {
            return Collections.unmodifiableList(this.primaryMessages);
        }

        public HandledResult secondaryMessage(Message extraMessage) {
            if (extraMessage != null) {
                this.secondaryMessages.add(extraMessage);
            }
            return this;
        }

        public HandledResult secondaryMessage(I18N.Key key, Object ... args) {
            return this.secondaryMessage(new Message(key, args));
        }

        public List<Message> secondaryMessages() {
            return Collections.unmodifiableList(this.secondaryMessages);
        }

        public List<HandledResult> secondaryResults() {
            return Collections.unmodifiableList(this.secondaryResults);
        }

        public HandledResult secondaryResult(HandledResult extraResult) {
            if (extraResult != null) {
                this.secondaryResults.add(extraResult);
            }
            return this;
        }

        public int line() {
            return this.line;
        }

        public int column() {
            return this.column;
        }

        public String originalMessage() {
            return this.originalMessage;
        }

        public String toString() {
            return "[line=" + this.line + ", column=" + this.column + ", originalMessage='" + this.originalMessage + "', primaryMessages=" + this.primaryMessages + ", secondaryMessages=" + this.secondaryMessages + "]";
        }
    }
}

