/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.ifelse.BaseOperation;
import org.jboss.as.cli.handlers.ifelse.Operand;
import org.jboss.dmr.ModelNode;

class OrOperation
extends BaseOperation {
    static final String SYMBOL = "||";

    OrOperation() {
        super(SYMBOL, 2);
    }

    @Override
    public Object resolveValue(CommandContext ctx, ModelNode response) throws CommandLineException {
        for (Operand operand : this.getOperands()) {
            Object value = operand.resolveValue(ctx, response);
            if (!(value instanceof Boolean)) {
                throw new CommandFormatException("Expected boolean value from " + operand + " but received " + value);
            }
            if (!((Boolean)value).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsMoreArguments() {
        return true;
    }
}

