/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.parser.Parser;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.impl.CommandContextImpl;

public interface Console {
    public void addCompleter(CommandLineCompleter var1);

    public boolean isUseHistory();

    public CommandHistory getHistory();

    public void setCompletion(boolean var1);

    public void clearScreen();

    public void printColumns(Collection<String> var1);

    public void print(String var1);

    public void printNewLine();

    public String readLine(String var1);

    public String readLine(String var1, Character var2);

    public int getTerminalWidth();

    public int getTerminalHeight();

    public boolean isCompletionEnabled();

    public void interrupt();

    public void controlled();

    public boolean isControlled();

    public void continuous();

    public void setCallback(ConsoleCallback var1);

    public void start();

    public void stop();

    public boolean running();

    public void setPrompt(String var1);

    public void setPrompt(String var1, Character var2);

    public void redrawPrompt();

    public static final class Factory {
        public static Console getConsole(CommandContext ctx, Settings settings) throws CliInitializationException {
            return Factory.getConsole(ctx, null, null, settings);
        }

        public static Console getConsole(final CommandContext ctx, InputStream is, OutputStream os, final Settings settings) throws CliInitializationException {
            org.jboss.aesh.console.Console aeshConsole = null;
            try {
                aeshConsole = new org.jboss.aesh.console.Console(settings);
            }
            catch (Throwable e) {
                throw new CliInitializationException("Failed to initialize Aesh console", e);
            }
            final org.jboss.aesh.console.Console finalAeshConsole = aeshConsole;
            Console console = new Console(){
                private CommandContext cmdCtx;
                private org.jboss.aesh.console.Console console;
                private CommandHistory history;
                private boolean controlled;
                {
                    this.cmdCtx = ctx;
                    this.console = finalAeshConsole;
                    this.history = new HistoryImpl();
                }

                @Override
                public void addCompleter(final CommandLineCompleter completer) {
                    this.console.addCompletion(new Completion(){

                        @Override
                        public void complete(CompleteOperation co) {
                            String buffer;
                            ArrayList<String> candidates = new ArrayList<String>();
                            int offset = completer.complete(cmdCtx, co.getBuffer(), co.getCursor(), candidates);
                            co.setOffset(offset);
                            co.setCompletionCandidates(candidates);
                            String string = buffer = cmdCtx.getArgumentsString() == null ? co.getBuffer() : ctx.getArgumentsString() + co.getBuffer();
                            if (co.getCompletionCandidates().size() == 1 && co.getCompletionCandidates().get(0).getCharacters().startsWith(buffer)) {
                                co.doAppendSeparator(true);
                            } else {
                                co.doAppendSeparator(false);
                            }
                        }
                    });
                }

                @Override
                public boolean isUseHistory() {
                    return !settings.isHistoryDisabled();
                }

                @Override
                public CommandHistory getHistory() {
                    return this.history;
                }

                @Override
                public void setCompletion(boolean complete) {
                    this.console.setCompletionEnabled(complete);
                }

                @Override
                public void clearScreen() {
                    try {
                        this.console.clear();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void printColumns(Collection<String> list) {
                    String[] newList = new String[list.size()];
                    list.toArray(newList);
                    this.console.getShell().out().println(Parser.formatDisplayList(newList, this.console.getTerminalSize().getHeight(), this.console.getTerminalSize().getWidth()));
                }

                @Override
                public void print(String line) {
                    this.console.getShell().out().print(line);
                }

                @Override
                public void printNewLine() {
                    this.console.getShell().out().println();
                }

                @Override
                public String readLine(String prompt) {
                    return this.read(prompt, null);
                }

                @Override
                public String readLine(String prompt, Character mask) {
                    return this.read(prompt, mask);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                private String read(String prompt, Character mask) {
                    block13: {
                        int PID = -1;
                        try {
                            CommandContextImpl.CLIAeshConsoleCallback cliCallback;
                            ConsoleCallback callback = this.console.getConsoleCallback();
                            if (callback instanceof CommandContextImpl.CLIAeshConsoleCallback && (cliCallback = (CommandContextImpl.CLIAeshConsoleCallback)callback).hasActiveProcess()) {
                                PID = cliCallback.getProcessPID();
                                this.console.putProcessInBackground(PID);
                            }
                            Prompt origPrompt = null;
                            if (!this.console.getPrompt().getPromptAsString().equals(prompt)) {
                                origPrompt = this.console.getPrompt();
                                this.console.setPrompt(new Prompt(prompt, mask));
                                this.redrawPrompt();
                            }
                            try {
                                String string = this.console.getInputLine();
                                return string;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                break block13;
                            }
                            finally {
                                if (origPrompt != null) {
                                    this.console.setPrompt(origPrompt);
                                }
                            }
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (PID != -1) {
                                this.console.putProcessInForeground(PID);
                            }
                        }
                    }
                    return null;
                }

                @Override
                public int getTerminalWidth() {
                    return this.console.getTerminalSize().getWidth();
                }

                @Override
                public int getTerminalHeight() {
                    return this.console.getTerminalSize().getHeight();
                }

                @Override
                public boolean isCompletionEnabled() {
                    return settings.isCompletionDisabled();
                }

                @Override
                public void interrupt() {
                }

                @Override
                public void controlled() {
                    this.console.controlled();
                    this.controlled = true;
                }

                @Override
                public void continuous() {
                    this.console.continuous();
                    this.controlled = false;
                }

                @Override
                public boolean isControlled() {
                    return this.controlled;
                }

                @Override
                public void setCallback(ConsoleCallback consoleCallback) {
                    if (this.console != null) {
                        this.console.setConsoleCallback(consoleCallback);
                    }
                }

                @Override
                public void start() {
                    if (this.console != null) {
                        this.console.start();
                    }
                }

                @Override
                public void stop() {
                    if (this.console != null) {
                        this.console.stop();
                    }
                }

                @Override
                public boolean running() {
                    return this.console != null && (this.console.isRunning() || this.console.hasRunningProcesses());
                }

                @Override
                public void setPrompt(String prompt) {
                    this.setPrompt(prompt, null);
                }

                @Override
                public void setPrompt(String prompt, Character mask) {
                    if (!prompt.equals(this.console.getPrompt().getPromptAsString())) {
                        this.console.setPrompt(new Prompt(prompt, mask));
                    }
                }

                @Override
                public void redrawPrompt() {
                    this.console.clearBufferAndDisplayPrompt();
                }

                class HistoryImpl
                implements CommandHistory {
                    HistoryImpl() {
                    }

                    @Override
                    public List<String> asList() {
                        return console.getHistory().getAll();
                    }

                    @Override
                    public boolean isUseHistory() {
                        return console.getHistory().isEnabled();
                    }

                    @Override
                    public void setUseHistory(boolean useHistory) {
                        if (useHistory) {
                            console.getHistory().enable();
                        } else {
                            console.getHistory().disable();
                        }
                    }

                    @Override
                    public void clear() {
                        console.getHistory().clear();
                    }

                    @Override
                    public int getMaxSize() {
                        return settings.getHistorySize();
                    }
                }
            };
            return console;
        }
    }
}

