/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.AuditLogItem;
import org.jboss.as.controller.audit.AuditLogItemFormatter;
import org.jboss.dmr.ModelNode;

public final class InMemoryAuditLogHander
extends AuditLogHandler {
    public static final String OPERATION_DATE = "operation-date";
    private static final ModelNode UNDEFINED = new ModelNode();
    private static final String IN_MEMORY_FORMATTER_NAME = "in-memory-formatter";
    private final List<ModelNode> items;
    private int maxHistory;
    private final AuditLogItemFormatter myFormatter = new InMemoryFormatter();

    public InMemoryAuditLogHander(String name, int maxHistory) {
        super(name, IN_MEMORY_FORMATTER_NAME, maxHistory);
        this.items = new ArrayList<ModelNode>(maxHistory);
        this.maxHistory = maxHistory;
        this.setFormatter(this.myFormatter);
    }

    @Override
    public List<ModelNode> listLastEntries() {
        return Collections.unmodifiableList(this.items);
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
        while (maxHistory < this.items.size()) {
            this.items.remove(0);
        }
    }

    @Override
    void setFormatter(AuditLogItemFormatter formatter) {
        super.setFormatter(this.myFormatter);
    }

    public AuditLogItemFormatter getFormatter() {
        return this.myFormatter;
    }

    @Override
    boolean isDifferent(AuditLogHandler other) {
        if (!(other instanceof InMemoryAuditLogHander)) {
            return true;
        }
        return this.getName().equals(other.getName());
    }

    private void addItem(ModelNode item) {
        if (this.items.size() == this.maxHistory) {
            this.items.remove(0);
        }
        this.items.add(item);
    }

    @Override
    void initialize() {
    }

    @Override
    void stop() {
        this.items.clear();
    }

    @Override
    void writeLogItem(String formattedItem) throws IOException {
    }

    static {
        UNDEFINED.protect();
    }

    private class InMemoryFormatter
    extends AuditLogItemFormatter {
        public static final String BOOTING = "booting";

        public InMemoryFormatter() {
            super(InMemoryAuditLogHander.IN_MEMORY_FORMATTER_NAME, true, "", "yyyy-MM-dd hh:mm:ss");
        }

        @Override
        String formatAuditLogItem(AuditLogItem.ModelControllerAuditLogItem item) {
            ModelNode entry = new ModelNode().setEmptyObject();
            entry.get("type").set("core");
            this.addCommonFields(entry, item);
            entry.get("outcome").set(item.getResultAction() == OperationContext.ResultAction.KEEP ? "success" : "failed");
            if (item.getOperations() != null && !item.getOperations().isEmpty()) {
                ModelNode operations = entry.get("operations").setEmptyList();
                item.getOperations().stream().forEach(op -> operations.add((ModelNode)op));
            }
            InMemoryAuditLogHander.this.addItem(entry);
            return entry.asString();
        }

        @Override
        String formatAuditLogItem(AuditLogItem.JmxAccessAuditLogItem item) {
            ModelNode entry = new ModelNode();
            entry.get("type").set("jmx");
            this.addCommonFields(entry, item);
            entry.get("method").set(item.getMethodName());
            entry.get("sig");
            for (String sig : item.getMethodSignature()) {
                entry.get("sig").add(sig);
            }
            entry.get("params");
            for (Object param : item.getMethodParams()) {
                entry.get("params").add(param == null ? UNDEFINED : new ModelNode(param.toString()));
            }
            Throwable throwable = item.getError();
            if (throwable != null) {
                entry.get("error").set(throwable.getMessage());
            }
            InMemoryAuditLogHander.this.addItem(entry);
            return entry.asString();
        }

        private void addCommonFields(ModelNode entry, AuditLogItem item) {
            StringBuilder buffer = new StringBuilder(20);
            this.appendDate(buffer, item);
            entry.get(InMemoryAuditLogHander.OPERATION_DATE).set(buffer.toString());
            entry.get("read-only").set(item.isReadOnly());
            entry.get(BOOTING).set(item.isBooting());
            entry.get("version").set(item.getAsVersion());
            if (item.getUserId() != null) {
                entry.get("user").set(item.getUserId());
            }
            if (item.getDomainUUID() != null) {
                entry.get("domain-uuid").set(item.getDomainUUID());
            }
            if (item.getAccessMechanism() != null) {
                entry.get("access-mechanism").set(item.getAccessMechanism().toString());
            }
            if (item.getRemoteAddress() != null) {
                entry.get("remote-address").set(item.getRemoteAddress().toString());
            }
        }
    }
}

