/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.patching.generator.Distribution;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.DistributionItemFileImpl;
import org.jboss.as.patching.generator.DistributionStructureImpl;
import org.jboss.as.patching.generator.PatchGenerator;
import org.jboss.as.patching.installation.LayersConfig;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

class DistributionProcessor {
    private Set<DistributionContentItem> moduleRoots = new LinkedHashSet<DistributionContentItem>();
    private final FilenameFilter OVERLAYS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.equals(".overlays");
        }
    };

    DistributionProcessor() {
    }

    static void process(DistributionContentItem parent, File distributionRoot, Distribution distribution) throws IOException {
        DistributionProcessor processor = new DistributionProcessor();
        File[] children = distributionRoot.listFiles();
        if (children != null && children.length != 0) {
            for (File child : children) {
                processor.processMisc(parent, child, distribution);
            }
        }
        if (processor.moduleRoots.isEmpty()) {
            throw new IOException(distributionRoot.getAbsolutePath() + " is not a valid server distribution directory.");
        }
        ArrayList<File> mp = new ArrayList<File>();
        Set<DistributionContentItem> moduleRoots = processor.moduleRoots;
        for (DistributionContentItem item : moduleRoots) {
            File file = item.getFile(distributionRoot);
            mp.add(file);
        }
        LocalModuleLoader loader = new LocalModuleLoader(mp.toArray(new File[mp.size()]));
        try {
            Module module = loader.loadModule(ModuleIdentifier.create("org.jboss.as.version"));
            Class<?> clazz = module.getClassLoader().loadClass("org.jboss.as.version.ProductConfig");
            Method resolveName = clazz.getMethod("resolveName", new Class[0]);
            Method resolveVersion = clazz.getMethod("resolveVersion", new Class[0]);
            Constructor<?> constructor = clazz.getConstructor(ModuleLoader.class, String.class, Map.class);
            Object productConfig = constructor.newInstance(loader, distributionRoot.getAbsolutePath(), Collections.emptyMap());
            distribution.setName((String)resolveName.invoke(productConfig, new Object[0]));
            distribution.setVersion((String)resolveVersion.invoke(productConfig, new Object[0]));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    void processMisc(DistributionContentItem parent, File root, Distribution distribution) throws IOException {
        DistributionItemFileImpl item = new DistributionItemFileImpl(root, parent);
        if (distribution.isIgnored(item)) {
            return;
        }
        if (distribution.isModuleLookupPath(item)) {
            LayeredModuleContext lc = new LayeredModuleContext(distribution);
            this.processLayeredRoot(item, root, lc);
            return;
        }
        if (distribution.isBundleLookupPath(item)) {
            LayeredBundleContext lc = new LayeredBundleContext(distribution);
            this.processLayeredRoot(item, root, lc);
            return;
        }
        parent.getChildren().add(item);
        File[] children = root.listFiles();
        if (children != null && children.length != 0) {
            for (File child : children) {
                this.processMisc(item, child, distribution);
            }
        }
    }

    void processLayeredRoot(DistributionContentItem parent, File root, LayeredContext context) throws IOException {
        List<String> layers;
        LayersConfig layersConfig = LayersConfig.getLayersConfig(root);
        File layersDir = new File(root, layersConfig.getLayersPath());
        DistributionContentItem newParent = DistributionStructureImpl.createMiscItem(parent, layersConfig.getLayersPath());
        if (!layersDir.exists()) {
            if (layersConfig.isConfigured()) {
                throw PatchGenerator.processingError("No layers directory found at " + layersDir, new Object[0]);
            }
            return;
        }
        if (layersConfig.isConfigured()) {
            layers = layersConfig.getLayers();
            if (layers.size() != layersDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathName) {
                    return pathName.isDirectory();
                }
            }).length) {
                throw PatchGenerator.processingError("configured layers does not match actual ones %s", layers);
            }
        } else {
            layers = Collections.singletonList("base");
        }
        for (String layer : layers) {
            File layerDir = new File(layersDir, layer);
            if (!layerDir.exists()) {
                if (layersConfig.isConfigured()) {
                    throw PatchGenerator.processingError("Cannot find layer '%s' under directory %s", layer, layersDir);
                }
                return;
            }
            context.addLayer(newParent, layer, layerDir);
        }
        File addOnsDir = new File(root, layersConfig.getAddOnsPath());
        File[] addOnsList = addOnsDir.listFiles();
        if (addOnsList != null) {
            for (File addOn : addOnsList) {
                context.addAddOn(newParent, addOn.getName(), addOn);
            }
        }
    }

    void processModules(DistributionContentItem parent, File root, ModuleContext context) {
        File[] children;
        DistributionItemFileImpl item = new DistributionItemFileImpl(root, parent);
        File moduleXml = new File(root, "module.xml");
        if (moduleXml.exists()) {
            if (context.isIgnored(item)) {
                return;
            }
            context.addModule(item);
        }
        if ((children = root.listFiles(this.OVERLAYS_FILTER)) != null && children.length != 0) {
            for (File child : children) {
                this.processModules(item, child, context);
            }
        }
    }

    void processBundles(DistributionContentItem parent, File root, ModuleContext context) {
        DistributionItemFileImpl item = new DistributionItemFileImpl(root, parent);
        File[] children = root.listFiles(this.OVERLAYS_FILTER);
        if (children != null && children.length != 0) {
            for (File child : children) {
                if (child.isDirectory()) continue;
                if (context.isIgnored(item)) {
                    return;
                }
                context.addModule(item);
                return;
            }
            for (File child : children) {
                this.processBundles(item, child, context);
            }
        }
    }

    class LayeredBundleContext
    extends LayeredContext {
        LayeredBundleContext(Distribution distribution) {
            super(distribution);
        }

        @Override
        void process(DistributionContentItem parent, File layerDir, final Distribution.ProcessedLayer processedLayer) {
            DistributionProcessor.this.processBundles(parent, layerDir, new ModuleContext(){

                @Override
                public void addModule(DistributionContentItem module) {
                    processedLayer.addBundle(module);
                }

                @Override
                public boolean isIgnored(DistributionContentItem item) {
                    return LayeredBundleContext.this.distribution.isIgnored(item);
                }
            });
        }
    }

    class LayeredModuleContext
    extends LayeredContext {
        LayeredModuleContext(Distribution distribution) {
            super(distribution);
        }

        @Override
        void addModuleRoot(DistributionContentItem item) {
            DistributionProcessor.this.moduleRoots.add(item);
        }

        @Override
        void process(DistributionContentItem parent, File layerDir, final Distribution.ProcessedLayer processedLayer) {
            DistributionProcessor.this.processModules(parent, layerDir, new ModuleContext(){

                @Override
                public void addModule(DistributionContentItem module) {
                    processedLayer.addModule(module);
                }

                @Override
                public boolean isIgnored(DistributionContentItem item) {
                    return LayeredModuleContext.this.distribution.isIgnored(item);
                }
            });
        }
    }

    static abstract class LayeredContext
    implements ProcessorContext {
        protected final Distribution distribution;

        protected LayeredContext(Distribution distribution) {
            this.distribution = distribution;
        }

        @Override
        public boolean isIgnored(DistributionContentItem item) {
            return this.distribution.isIgnored(item);
        }

        void addLayer(DistributionContentItem parent, String layer, File layerDir) {
            Distribution.ProcessedLayer processedLayer = this.distribution.addLayer(layer);
            DistributionItemFileImpl item = new DistributionItemFileImpl(layerDir, parent);
            this.addModuleRoot(item);
            this.doProcess(layerDir, processedLayer);
        }

        void addAddOn(DistributionContentItem parent, String name, File addOn) {
            Distribution.ProcessedLayer processedLayer = this.distribution.addAddOn(name);
            DistributionItemFileImpl item = new DistributionItemFileImpl(addOn, parent);
            this.addModuleRoot(item);
            this.doProcess(addOn, processedLayer);
        }

        void addModuleRoot(DistributionContentItem item) {
        }

        void doProcess(File layerDir, Distribution.ProcessedLayer processedLayer) {
            File[] children = layerDir.listFiles();
            if (children != null && children.length > 0) {
                for (File child : children) {
                    this.process(null, child, processedLayer);
                }
            }
        }

        abstract void process(DistributionContentItem var1, File var2, Distribution.ProcessedLayer var3);
    }

    static interface ModuleContext
    extends ProcessorContext {
        public void addModule(DistributionContentItem var1);
    }

    static interface ProcessorContext {
        public boolean isIgnored(DistributionContentItem var1);
    }
}

