/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store;

import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStorePermission;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store.impl.MaskedPasswordStore;
import org.wildfly.security.password.interfaces.ClearPassword;

public abstract class CredentialStoreSpi {
    protected boolean initialized = false;
    public static final String CUSTOM_PROVIDER = "PROVIDER";

    protected CredentialStoreSpi() {
    }

    public abstract void initialize(Map<String, String> var1) throws CredentialStoreException;

    public boolean isInitialized() {
        return this.initialized;
    }

    public abstract boolean isModifiable();

    public abstract <C extends Credential> boolean exists(String var1, Class<C> var2) throws CredentialStoreException, UnsupportedCredentialTypeException;

    public abstract <C extends Credential> void store(String var1, C var2) throws CredentialStoreException, UnsupportedCredentialTypeException;

    public abstract <C extends Credential> C retrieve(String var1, Class<C> var2) throws CredentialStoreException, UnsupportedCredentialTypeException;

    public abstract <C extends Credential> void remove(String var1, Class<C> var2) throws CredentialStoreException, UnsupportedCredentialTypeException;

    public Set<String> getAliases() throws UnsupportedOperationException, CredentialStoreException {
        throw new UnsupportedOperationException();
    }

    protected <C extends Credential> C resolveMasterCredential(String commandSpec, Class<C> credentialType, Map<String, String> attributes) throws CredentialStoreException {
        String trimmedCommandSpec;
        Assert.assertNotNull(commandSpec);
        Assert.assertNotNull(credentialType);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CredentialStorePermission.LOAD_EXTERNAL_STORE_PASSWORD);
        }
        if ((trimmedCommandSpec = commandSpec.trim()).startsWith("{EXT")) {
            try {
                CredentialStore cs = CredentialStore.getInstance("ExecPasswordStore");
                return cs.retrieve(commandSpec, credentialType);
            }
            catch (NoSuchAlgorithmException | UnsupportedCredentialTypeException e) {
                throw new CredentialStoreException(e);
            }
        }
        if (trimmedCommandSpec.startsWith("{CMD")) {
            try {
                CredentialStore cs = CredentialStore.getInstance("CmdPasswordStore");
                return cs.retrieve(commandSpec, credentialType);
            }
            catch (NoSuchAlgorithmException | UnsupportedCredentialTypeException e) {
                throw new CredentialStoreException(e);
            }
        }
        if (trimmedCommandSpec.startsWith(MaskedPasswordStore.PASS_MASK_PREFIX)) {
            try {
                CredentialStore cs = CredentialStore.getInstance("MaskedPasswordStore");
                cs.initialize(attributes);
                return cs.retrieve(commandSpec, credentialType);
            }
            catch (NoSuchAlgorithmException | UnsupportedCredentialTypeException e) {
                throw new CredentialStoreException(e);
            }
        }
        if (trimmedCommandSpec.startsWith("{PROVIDER")) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(commandSpec, "{}");
                String providerSpec = tokenizer.nextToken();
                StringTokenizer providerTokenizer = new StringTokenizer(providerSpec, "@");
                String providerType = providerTokenizer.nextToken();
                CredentialStore execCS = CredentialStore.getInstance(providerType);
                execCS.initialize(attributes);
                return execCS.retrieve(commandSpec, credentialType);
            }
            catch (NoSuchAlgorithmException | UnsupportedCredentialTypeException e) {
                throw new CredentialStoreException(e);
            }
        }
        return (C)((Credential)credentialType.cast(new PasswordCredential(ClearPassword.createRaw("clear", commandSpec.toCharArray()))));
    }
}

