/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.EnterStateCharacterHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.arguments.ArgumentValueCallbackHandler;
import org.jboss.as.cli.parsing.arguments.ArgumentValueInitialState;
import org.jboss.as.cli.parsing.arguments.ArgumentValueState;
import org.jboss.as.cli.parsing.arguments.CompositeState;
import org.jboss.as.cli.parsing.arguments.NonObjectArgumentValueState;
import org.jboss.as.cli.util.CLIExpressionResolver;
import org.jboss.dmr.ModelNode;

public interface ArgumentValueConverter {
    public static final ArgumentValueConverter DEFAULT = new ArgumentValueConverter(){

        @Override
        public ModelNode fromString(CommandContext ctx, String value) throws CommandFormatException {
            if (value == null) {
                return new ModelNode();
            }
            if (ctx.isResolveParameterValues()) {
                value = CLIExpressionResolver.resolveLax(value);
            }
            ModelNode toSet = null;
            try {
                toSet = ModelNode.fromString(value);
            }
            catch (Exception e) {
                ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
                StateParser.parse(value, handler, ArgumentValueInitialState.INSTANCE);
                toSet = handler.getResult();
            }
            return toSet;
        }
    };
    public static final ArgumentValueConverter NON_OBJECT = new DMRWithFallbackConverter(){
        final DefaultParsingState initialState = new DefaultParsingState("IE"){
            {
                super(id);
                this.setDefaultHandler(new EnterStateCharacterHandler(NonObjectArgumentValueState.INSTANCE));
            }
        };

        @Override
        protected ModelNode fromNonDMRString(CommandContext ctx, String value) throws CommandFormatException {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            StateParser.parse(value, handler, this.initialState);
            return handler.getResult();
        }
    };
    public static final ArgumentValueConverter LIST = new DMRWithFallbackConverter(){
        final DefaultParsingState initialState = new DefaultParsingState("IL"){
            {
                super(id);
                this.setDefaultHandler(new EnterStateCharacterHandler(new CompositeState(true, new ArgumentValueState())));
            }
        };

        @Override
        protected ModelNode fromNonDMRString(CommandContext ctx, String value) throws CommandFormatException {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            StateParser.parse(value, handler, this.initialState);
            return handler.getResult();
        }
    };
    public static final ArgumentValueConverter PROPERTIES = new DMRWithFallbackConverter(){
        final DefaultParsingState initialState = new DefaultParsingState("IPL"){
            {
                super(id);
                this.setDefaultHandler(new EnterStateCharacterHandler(new CompositeState(true, new ArgumentValueState())));
            }
        };

        @Override
        protected ModelNode fromNonDMRString(CommandContext ctx, String value) throws CommandFormatException {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            StateParser.parse(value, handler, this.initialState);
            return handler.getResult();
        }
    };

    public ModelNode fromString(CommandContext var1, String var2) throws CommandFormatException;

    public static abstract class DMRWithFallbackConverter
    implements ArgumentValueConverter {
        @Override
        public ModelNode fromString(CommandContext ctx, String value) throws CommandFormatException {
            if (value == null) {
                return new ModelNode();
            }
            if (ctx.isResolveParameterValues()) {
                value = CLIExpressionResolver.resolveLax(value);
            }
            try {
                return ModelNode.fromString(value);
            }
            catch (Exception e) {
                return this.fromNonDMRString(ctx, value);
            }
        }

        protected abstract ModelNode fromNonDMRString(CommandContext var1, String var2) throws CommandFormatException;
    }
}

