/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.wildfly.common.Assert;

public final class AttributeAccess {
    private final AccessType access;
    private final Storage storage;
    private final OperationStepHandler readHandler;
    private final OperationStepHandler writeHandler;
    private final EnumSet<Flag> flags;
    private final AttributeDefinition definition;

    AttributeAccess(AccessType access, Storage storage, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeDefinition definition, EnumSet<Flag> flags) {
        Assert.assertNotNull(access);
        Assert.assertNotNull(storage);
        this.access = access;
        this.readHandler = readHandler;
        this.writeHandler = writeHandler;
        this.storage = storage;
        this.definition = definition;
        if (flags != null && flags.contains((Object)Flag.ALIAS)) {
            Assert.checkNotNullParam("readHandler", readHandler);
        }
        if (access == AccessType.READ_WRITE) {
            Assert.checkNotNullParam("writeHandler", writeHandler);
        }
        this.flags = flags == null ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(flags);
        switch (storage) {
            case CONFIGURATION: {
                this.flags.add(Flag.STORAGE_CONFIGURATION);
                this.flags.remove((Object)Flag.STORAGE_RUNTIME);
                break;
            }
            case RUNTIME: {
                this.flags.add(Flag.STORAGE_RUNTIME);
                this.flags.remove((Object)Flag.STORAGE_CONFIGURATION);
                break;
            }
            default: {
                throw ControllerLogger.ROOT_LOGGER.unexpectedStorage(storage);
            }
        }
    }

    public AccessType getAccessType() {
        return this.access;
    }

    public Storage getStorageType() {
        return this.storage;
    }

    public OperationStepHandler getReadHandler() {
        return this.readHandler;
    }

    public OperationStepHandler getWriteHandler() {
        return this.writeHandler;
    }

    public AttributeDefinition getAttributeDefinition() {
        return this.definition;
    }

    public Set<Flag> getFlags() {
        return EnumSet.copyOf(this.flags);
    }

    public static enum Flag {
        RESTART_NONE,
        RESTART_JVM,
        RESTART_ALL_SERVICES,
        RESTART_RESOURCE_SERVICES,
        STORAGE_CONFIGURATION,
        STORAGE_RUNTIME,
        ALIAS,
        RUNTIME_SERVICE_NOT_REQUIRED;

    }

    public static enum Storage {
        CONFIGURATION("configuration"),
        RUNTIME("runtime");

        private final String label;

        private Storage(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum AccessType {
        READ_ONLY("read-only", false),
        READ_WRITE("read-write", true),
        METRIC("metric", false);

        private final String label;
        private final boolean writable;
        private static final Map<String, AccessType> MAP;

        private AccessType(String label, boolean writable) {
            this.label = label;
            this.writable = writable;
        }

        public String toString() {
            return this.label;
        }

        public static AccessType forName(String localName) {
            return MAP.get(localName);
        }

        private String getLocalName() {
            return this.label;
        }

        public boolean isWritable() {
            return this.writable;
        }

        static {
            HashMap<String, AccessType> map = new HashMap<String, AccessType>();
            for (AccessType element : AccessType.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

