/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.Locale;
import java.util.ResourceBundle;

public class I18N {
    private static Locale locale;
    private static ResourceBundle bundle;

    public static String lookup(Key key) {
        I18N.init();
        return bundle.getString(key.toString());
    }

    public static String format(Key key, Object ... args) {
        return String.format(I18N.lookup(key), args);
    }

    public static void setLocale(Locale l) {
        locale = l;
    }

    public static String validationErrorIn(String docName) {
        return I18N.format(Key.VALIDATION_ERROR_IN, "OPVDX001", docName);
    }

    public static String failedToPrintError(Throwable ex) {
        return I18N.format(Key.PRINT_FAILURE, "OPVDX002", ex.getMessage());
    }

    public static String noSchemasAvailable(String resource) {
        return I18N.format(Key.NO_SCHEMAS_AVAILABLE, "OPVDX003", resource);
    }

    private static Locale activeLocale() {
        return locale == null ? Locale.getDefault() : locale;
    }

    private I18N() {
    }

    private static void init() {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("Messages", I18N.activeLocale());
        }
    }

    public static enum Key {
        AND_N_MORE,
        ATTRIBUTE_DUPLICATED,
        ATTRIBUTE_DUPLICATED_FIRST_OCCURRENCE,
        ATTRIBUTE_DUPLICATED_NO_ELEMENT,
        ATTRIBUTE_IS_ALLOWED_ON,
        ATTRIBUTE_NOT_ALLOWED,
        ATTRIBUTES_ALLOWED_HERE,
        ATTRIBUTE_INVALID_VALUE,
        ATTRIBUTE_REQUIRED_MISSING,
        ATTRIBUTE_REQUIRED_MISSING_LIST,
        DID_YOU_MEAN,
        ELEMENT_DUPLICATED,
        ELEMENT_DUPLICATED_FIRST_OCCURRENCE,
        ELEMENT_HAS_NO_ATTRIBUTES,
        ELEMENT_WITH_ATTRIBUTE_DUPLICATED,
        ELEMENT_WITH_ATTRIBUTE_DUPLICATED_FIRST_OCCURRENCE,
        ELEMENT_IS_ALLOWED_ON,
        ELEMENT_NOT_ALLOWED,
        ELEMENT_REQUIRED_MISSING,
        ELEMENT_REQUIRED_MISSING_LIST,
        ELEMENT_UNSUPPORTED,
        ELEMENT_UNSUPPORTED_NO_ALT,
        ELEMENTS_ALLOWED_HERE,
        ELEMENTS_REQUIRED_MISSING,
        ELEMENTS_REQUIRED_MISSING_LIST,
        MALFORMED_XML,
        NO_SCHEMAS_AVAILABLE,
        ORIGINAL_ERROR,
        PASSTHRU,
        PRINT_FAILURE,
        VALIDATION_ERROR_IN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

