/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonObject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.util.ByteStringBuilder;

public class OAuth2CredentialSource
implements CredentialSource {
    private final String grantType;
    private final URL tokenEndpointUri;
    private final Consumer<Map<String, String>> consumer;
    private String scopes;
    private final Supplier<SSLContext> sslContextSupplier;
    private final Supplier<HostnameVerifier> hostnameVerifierSupplier;

    public static Builder builder(URL tokenEndpointUrl) {
        return new Builder(tokenEndpointUrl);
    }

    private OAuth2CredentialSource(String grantType, URL tokenEndpointUri, String scopes, Supplier<SSLContext> sslContextSupplier, Supplier<HostnameVerifier> hostnameVerifierSupplier) {
        this(grantType, tokenEndpointUri, (Map<String, String> stringStringMap) -> {}, scopes, sslContextSupplier, hostnameVerifierSupplier);
    }

    private OAuth2CredentialSource(String grantType, URL tokenEndpointUrl, Consumer<Map<String, String>> consumer, String scopes, Supplier<SSLContext> sslContextSupplier, Supplier<HostnameVerifier> hostnameVerifierSupplier) {
        this.grantType = Assert.checkNotNullParam("grantType", grantType);
        this.tokenEndpointUri = Assert.checkNotNullParam("tokenEndpointUri", tokenEndpointUrl);
        if (this.isHttps(tokenEndpointUrl)) {
            Assert.checkNotNullParam("sslContextSupplier", sslContextSupplier);
        }
        this.consumer = consumer;
        this.scopes = scopes;
        this.sslContextSupplier = sslContextSupplier;
        this.hostnameVerifierSupplier = hostnameVerifierSupplier;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        return this.getCredential(credentialType, algorithmName, parameterSpec) != null ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        if (!BearerTokenCredential.class.isAssignableFrom(credentialType)) return null;
        try {
            HttpURLConnection connection = null;
            try {
                connection = this.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setInstanceFollowRedirects(false);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("grant_type", this.grantType);
                this.consumer.accept(parameters);
                if (this.scopes != null) {
                    parameters.put("scope", this.scopes);
                }
                byte[] paramBytes = this.buildParameters(parameters);
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(paramBytes);
                }
                var8_13 = null;
                try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());){
                    JsonObject jsonObject = Json.createReader((InputStream)inputStream).readObject();
                    String accessToken = jsonObject.getString("access_token");
                    Credential credential = (Credential)credentialType.cast(new BearerTokenCredential(accessToken));
                    return (C)credential;
                }
                catch (Throwable jsonObject) {
                    var8_13 = jsonObject;
                    throw jsonObject;
                }
            }
            catch (IOException ioe) {
                InputStream errorStream = null;
                if (connection == null) throw ElytronMessages.log.mechUnableToHandleResponseFromServer("OAuth2CredentialSource", ioe);
                if (connection.getErrorStream() == null) throw ElytronMessages.log.mechUnableToHandleResponseFromServer("OAuth2CredentialSource", ioe);
                errorStream = connection.getErrorStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));){
                    StringBuffer response = reader.lines().reduce(new StringBuffer(), StringBuffer::append, (buffer1, buffer2) -> buffer1);
                    ElytronMessages.log.errorf((Throwable)ioe, "Unexpected response from server [%s]. Response: [%s]", (Object)this.tokenEndpointUri, (Object)response);
                    throw ElytronMessages.log.mechUnableToHandleResponseFromServer("OAuth2CredentialSource", ioe);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ElytronMessages.log.mechUnableToHandleResponseFromServer("OAuth2CredentialSource", ioe);
            }
        }
        catch (Exception cause) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason("OAuth2CredentialSource", cause);
        }
    }

    private SSLContext resolveSSLContext() {
        if (!this.isHttps(this.tokenEndpointUri)) {
            return null;
        }
        return this.sslContextSupplier == null ? null : this.sslContextSupplier.get();
    }

    private HttpURLConnection openConnection() throws IOException {
        ElytronMessages.log.debugf("Opening connection to [%s]", (Object)this.tokenEndpointUri);
        HttpURLConnection connection = (HttpURLConnection)this.tokenEndpointUri.openConnection();
        if (this.isHttps(this.tokenEndpointUri)) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            https.setSSLSocketFactory(this.resolveSSLContext().getSocketFactory());
            if (this.hostnameVerifierSupplier != null) {
                https.setHostnameVerifier(Assert.checkNotNullParam("hostnameVerifier", this.hostnameVerifierSupplier.get()));
            }
        }
        return connection;
    }

    private byte[] buildParameters(Map<String, String> parameters) {
        ByteStringBuilder params = new ByteStringBuilder();
        parameters.entrySet().stream().forEach(entry -> {
            if (params.length() > 0) {
                params.append('&');
            }
            params.append((String)entry.getKey()).append('=').append((String)entry.getValue());
        });
        return params.toArray();
    }

    private boolean isHttps(URL tokenEndpointUrl) {
        return "https".equals(tokenEndpointUrl.getProtocol());
    }

    public static class Builder {
        private final URL tokenEndpointUrl;
        private Function<Builder, OAuth2CredentialSource> grantType;
        private String scopes;
        private Supplier<SSLContext> sslContextSupplier = new Supplier<SSLContext>(){

            @Override
            public SSLContext get() {
                AuthenticationContextConfigurationClient contextConfigurationClient = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
                try {
                    return contextConfigurationClient.getSSLContext(tokenEndpointUrl.toURI(), AuthenticationContext.captureCurrent());
                }
                catch (Exception cause) {
                    throw ElytronMessages.log.failedToObtainSSLContext(cause);
                }
            }
        };
        private Supplier<HostnameVerifier> hostnameVerifierSupplier;

        private Builder(URL tokenEndpointUrl) {
            this.tokenEndpointUrl = Assert.checkNotNullParam("tokenEndpointUrl", tokenEndpointUrl);
            this.grantType = builder -> new OAuth2CredentialSource("client_credentials", tokenEndpointUrl, builder.scopes, builder.sslContextSupplier, builder.hostnameVerifierSupplier);
        }

        public Builder grantScopes(String scopes) {
            this.scopes = Assert.checkNotNullParam("scopes", scopes);
            return this;
        }

        public Builder useResourceOwnerPassword(String userName, String password) {
            this.grantType = builder -> new OAuth2CredentialSource("password", this.tokenEndpointUrl, parameters -> {
                parameters.put("username", userName);
                parameters.put("password", password);
            }, builder.scopes, builder.sslContextSupplier, builder.hostnameVerifierSupplier);
            return this;
        }

        public Builder useSslContext(SSLContext sslContext) {
            Assert.checkNotNullParam("sslContext", sslContext);
            this.sslContextSupplier = () -> sslContext;
            return this;
        }

        public Builder useSslHostnameVerifier(HostnameVerifier hostnameVerifier) {
            Assert.checkNotNullParam("hostnameVerifier", hostnameVerifier);
            this.hostnameVerifierSupplier = () -> hostnameVerifier;
            return this;
        }

        public OAuth2CredentialSource build() {
            return this.grantType.apply(this);
        }
    }
}

