/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import javax.security.auth.Destroyable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CommandCredentialSource;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.CredentialStoreCredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.password.interfaces.ClearPassword;

public final class CredentialReference
implements Destroyable {
    public static final String CREDENTIAL_STORE_CAPABILITY = "org.wildfly.security.credential-store";
    public static final String CREDENTIAL_REFERENCE = "credential-reference";
    public static final String STORE = "store";
    public static final String ALIAS = "alias";
    public static final String TYPE = "type";
    public static final String CLEAR_TEXT = "clear-text";
    static final SimpleAttributeDefinition credentialStoreAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("store", ModelType.STRING, true).setXmlName("store")).build();
    static final SimpleAttributeDefinition credentialAliasAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, true).setXmlName("alias")).build();
    static final SimpleAttributeDefinition credentialTypeAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setXmlName("type")).build();
    static final SimpleAttributeDefinition clearTextAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("clear-text", ModelType.STRING, true).setXmlName("clear-text")).build();
    static final ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition = CredentialReference.getAttributeBuilder("credential-reference", "credential-reference", false).build();

    private CredentialReference() {
    }

    public static ObjectTypeAttributeDefinition getAttributeDefinition() {
        return credentialReferenceAttributeDefinition;
    }

    public static ObjectTypeAttributeDefinition.Builder getAttributeBuilder(String name, String xmlName, boolean allowNull) {
        return ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder(name, credentialStoreAttribute, credentialAliasAttribute, credentialTypeAttribute, clearTextAttribute).setXmlName(xmlName)).setAttributeMarshaller(CredentialReference.credentialReferenceAttributeMarshaller())).setAttributeParser(CredentialReference.credentialReferenceAttributeParser())).setAllowNull(allowNull);
    }

    public static String credentialReferencePartAsStringIfDefined(OperationContext context, ObjectTypeAttributeDefinition attributeDefinition, ModelNode model, String name) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            ModelNode namedNode = value.get(name);
            if (namedNode != null && namedNode.isDefined()) {
                return namedNode.asString();
            }
            return null;
        }
        return null;
    }

    private static AttributeMarshaller credentialReferenceAttributeMarshaller() {
        return new AttributeMarshaller(){

            @Override
            public void marshallAsElement(AttributeDefinition attribute, ModelNode credentialReferenceModelNode, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                writer.writeStartElement(attribute.getXmlName());
                if (credentialReferenceModelNode.hasDefined(clearTextAttribute.getName())) {
                    clearTextAttribute.marshallAsAttribute(credentialReferenceModelNode, writer);
                } else {
                    credentialStoreAttribute.marshallAsAttribute(credentialReferenceModelNode, writer);
                    credentialAliasAttribute.marshallAsAttribute(credentialReferenceModelNode, writer);
                    credentialTypeAttribute.marshallAsAttribute(credentialReferenceModelNode, writer);
                }
                writer.writeEndElement();
            }

            @Override
            public boolean isMarshallableAsElement() {
                return true;
            }
        };
    }

    private static AttributeParser credentialReferenceAttributeParser() {
        return new AttributeParser(){

            @Override
            public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
                AttributeParser.OBJECT_PARSER.parseElement(attribute, reader, operation);
            }

            @Override
            public boolean isParseAsElement() {
                return true;
            }
        };
    }

    public static ExceptionSupplier<CredentialSource, Exception> getCredentialSourceSupplier(OperationContext context, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, ModelNode model, ServiceBuilder<?> serviceBuilder) throws OperationFailedException {
        final String credentialStoreName = CredentialReference.credentialReferencePartAsStringIfDefined(context, credentialReferenceAttributeDefinition, model, STORE);
        final String credentialAlias = CredentialReference.credentialReferencePartAsStringIfDefined(context, credentialReferenceAttributeDefinition, model, ALIAS);
        final String credentialType = CredentialReference.credentialReferencePartAsStringIfDefined(context, credentialReferenceAttributeDefinition, model, TYPE);
        final String secret = CredentialReference.credentialReferencePartAsStringIfDefined(context, credentialReferenceAttributeDefinition, model, CLEAR_TEXT);
        final InjectedValue credentialStoreInjectedValue = new InjectedValue();
        if (credentialAlias != null) {
            String credentialStoreCapabilityName = RuntimeCapability.buildDynamicCapabilityName(CREDENTIAL_STORE_CAPABILITY, credentialStoreName);
            ServiceName credentialStoreServiceName = context.getCapabilityServiceName(credentialStoreCapabilityName, CredentialStore.class);
            serviceBuilder.addDependency(ServiceBuilder.DependencyType.REQUIRED, credentialStoreServiceName, CredentialStore.class, credentialStoreInjectedValue);
        }
        return new ExceptionSupplier<CredentialSource, Exception>(){

            private String[] parseCommand(String command) {
                String[] parsedCommand = command.split("(?<!\\\\),");
                for (int k = 0; k < parsedCommand.length; ++k) {
                    if (parsedCommand[k].indexOf(92) == -1) continue;
                    parsedCommand[k] = parsedCommand[k].replaceAll("\\\\,", ",");
                }
                return parsedCommand;
            }

            private String stripType(String commandSpec) {
                StringTokenizer tokenizer = new StringTokenizer(commandSpec, "{}");
                tokenizer.nextToken();
                return tokenizer.nextToken();
            }

            @Override
            public CredentialSource get() throws Exception {
                if (credentialAlias != null) {
                    return new CredentialStoreCredentialSource((CredentialStore)credentialStoreInjectedValue.getValue(), credentialAlias);
                }
                if (credentialType != null && credentialType.equalsIgnoreCase("COMMAND")) {
                    CommandCredentialSource.Builder command = CommandCredentialSource.builder();
                    String commandSpec = secret.trim();
                    if (commandSpec.startsWith("{EXT")) {
                        commandSpec = this.stripType(commandSpec);
                        command.addCommand(commandSpec);
                    } else if (commandSpec.startsWith("{CMD")) {
                        String[] parts;
                        for (String part : parts = this.parseCommand(this.stripType(commandSpec))) {
                            command.addCommand(part);
                        }
                    }
                    return command.build();
                }
                if (secret != null && secret.startsWith("MASK-")) {
                    if (credentialStoreName != null) {
                        return new CredentialStoreCredentialSource((CredentialStore)credentialStoreInjectedValue.getValue(), secret.substring("MASK-".length()));
                    }
                    throw ControllerLogger.ROOT_LOGGER.nameOfCredentialStoreHasToBeSpecified();
                }
                return new CredentialSource(){

                    @Override
                    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                        return credentialType == PasswordCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
                    }

                    @Override
                    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                        return (C)((Credential)credentialType.cast(new PasswordCredential(ClearPassword.createRaw("clear", secret.toCharArray()))));
                    }
                };
            }
        };
    }
}

