/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.MutableTargetImpl;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.LayerType;
import org.jboss.as.patching.runner.PatchUtils;

abstract class InstallationModificationImpl
extends MutableTargetImpl
implements InstallationManager.InstallationModification {
    private final String name;
    private final InstallationState installationState;
    private final List<String> allPatches;
    private final AtomicBoolean done = new AtomicBoolean();

    protected InstallationModificationImpl(PatchableTarget.TargetInfo identity, String name, String version, List<String> allPatches, InstallationState installationState) {
        super(identity, version);
        this.name = name;
        this.installationState = installationState;
        this.allPatches = new ArrayList<String>(allPatches);
    }

    @Override
    public InstallationManager.MutablePatchingTarget resolve(String name, LayerType type) {
        if (type == LayerType.Layer) {
            return (InstallationManager.MutablePatchingTarget)this.installationState.layers.get(name);
        }
        return (InstallationManager.MutablePatchingTarget)this.installationState.addOns.get(name);
    }

    @Override
    public void addInstalledPatch(String patchId) throws PatchingException {
        if (this.allPatches.contains(patchId)) {
            throw PatchLogger.ROOT_LOGGER.alreadyApplied(patchId);
        }
        this.allPatches.add(patchId);
    }

    @Override
    public void removeInstalledPatch(String patchId) throws PatchingException {
        if (!this.allPatches.contains(patchId)) {
            throw PatchLogger.ROOT_LOGGER.cannotRollbackPatch(patchId);
        }
        this.allPatches.remove(patchId);
    }

    List<String> getAllPatches() {
        return this.allPatches;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected void persist() throws IOException {
        this.getMutableProperties().put("installed-patches", PatchUtils.asString(this.allPatches));
        super.persist();
    }

    boolean setDone() {
        return this.done.compareAndSet(false, true);
    }

    InstallationState internalComplete() throws Exception {
        if (!this.setDone()) {
            throw new IllegalStateException();
        }
        try {
            this.installationState.persist();
        }
        catch (Exception e) {
            this.installationState.restore();
            throw e;
        }
        try {
            this.persist();
        }
        catch (Exception e) {
            this.installationState.restore();
        }
        return this.installationState;
    }

    static class InstallationState {
        private final Map<String, MutableTargetImpl> layers = new LinkedHashMap<String, MutableTargetImpl>();
        private final Map<String, MutableTargetImpl> addOns = new LinkedHashMap<String, MutableTargetImpl>();

        InstallationState() {
        }

        protected void putLayer(Layer layer) throws IOException {
            this.putPatchableTarget(layer.getName(), layer, this.layers);
        }

        protected void putAddOn(AddOn addOn) throws IOException {
            this.putPatchableTarget(addOn.getName(), addOn, this.addOns);
        }

        protected void putPatchableTarget(String name, PatchableTarget target, Map<String, MutableTargetImpl> map) throws IOException {
            PatchableTarget.TargetInfo info = target.loadTargetInfo();
            map.put(name, new MutableTargetImpl(info));
        }

        Map<String, MutableTargetImpl> getLayers() {
            return this.layers;
        }

        Map<String, MutableTargetImpl> getAddOns() {
            return this.addOns;
        }

        protected void persist() throws IOException {
            for (MutableTargetImpl target : this.layers.values()) {
                target.persist();
            }
            for (MutableTargetImpl target : this.addOns.values()) {
                target.persist();
            }
        }

        private void restore() {
            for (MutableTargetImpl target : this.layers.values()) {
                try {
                    target.restore();
                }
                catch (IOException e) {
                    PatchLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to restore original state for layer %s", (Object)target);
                }
            }
            for (MutableTargetImpl target : this.addOns.values()) {
                try {
                    target.restore();
                }
                catch (IOException e) {
                    PatchLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to restore original state for add-on %s", (Object)target);
                }
            }
        }
    }
}

