/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.util.Locale;
import org.wildfly.common.Assert;

public class AttributeMapping {
    public static final String DEFAULT_FILTERED_NAME = "filtered";
    public static final String DEFAULT_DN_NAME = "dn";
    private final String ldapName;
    private final String searchDn;
    private final boolean recursiveSearch;
    private final String filter;
    private final String reference;
    private final String name;
    private final String rdn;
    private final int roleRecursionDepth;

    String getLdapName() {
        return this.ldapName;
    }

    String getIdentityLdapName() {
        if (this.filter != null) {
            return null;
        }
        return this.reference != null ? this.reference : this.ldapName;
    }

    String getName() {
        return this.name;
    }

    String getSearchDn() {
        return this.searchDn;
    }

    boolean getRecursiveSearch() {
        return this.recursiveSearch;
    }

    String getFilter() {
        return this.filter;
    }

    String getRdn() {
        return this.rdn;
    }

    String getReference() {
        return this.reference;
    }

    int getRoleRecursionDepth() {
        return this.roleRecursionDepth;
    }

    boolean isFilteredOrReference() {
        return this.filter != null || this.reference != null;
    }

    boolean searchInIdentityContext() {
        return this.reference != null;
    }

    public static Builder fromIdentity() {
        Builder builder = new Builder();
        builder.ldapName = null;
        return builder;
    }

    public static Builder fromFilter(String filter) {
        Assert.checkNotNullParam("filter", filter);
        Builder builder = new Builder();
        builder.filter = filter;
        return builder;
    }

    public static Builder fromReference(String reference) {
        Assert.checkNotNullParam("reference", reference);
        Builder builder = new Builder();
        builder.reference = reference;
        return builder;
    }

    AttributeMapping(String searchDn, boolean recursiveSearch, String filter, String reference, String ldapName, String name, String rdn, int roleRecursionDepth) {
        this.searchDn = searchDn;
        this.recursiveSearch = recursiveSearch;
        this.filter = filter;
        this.reference = reference;
        this.ldapName = ldapName;
        this.name = name;
        this.rdn = rdn;
        this.roleRecursionDepth = roleRecursionDepth;
    }

    public static class Builder {
        private String ldapName;
        private String searchDn;
        private boolean recursiveSearch = true;
        private String filter;
        private String reference;
        private String name;
        private String rdn;
        private int roleRecursionDepth;

        public Builder extractRdn(String rdn) {
            Assert.checkNotNullParam("rdn", rdn);
            this.rdn = rdn;
            return this;
        }

        public Builder from(String ldapName) {
            Assert.checkNotNullParam("ldapName", ldapName);
            this.ldapName = ldapName.toUpperCase(Locale.ROOT);
            return this;
        }

        public Builder to(String name) {
            Assert.checkNotNullParam("name", name);
            this.name = name;
            return this;
        }

        public Builder searchDn(String searchDn) {
            Assert.checkNotNullParam("searchDn", searchDn);
            Assert.checkNotNullParam("filter", this.filter);
            this.searchDn = searchDn;
            return this;
        }

        public Builder searchRecursively(boolean recursiveSearch) {
            Assert.checkNotNullParam("filter", this.filter);
            this.recursiveSearch = recursiveSearch;
            return this;
        }

        public Builder roleRecursion(int roleRecursionDepth) {
            Assert.checkMinimumParameter("roleRecursionDepth", 0, roleRecursionDepth);
            this.roleRecursionDepth = roleRecursionDepth;
            return this;
        }

        public AttributeMapping build() {
            if (this.name == null) {
                this.name = this.ldapName != null ? this.ldapName : (this.filter != null ? AttributeMapping.DEFAULT_FILTERED_NAME : AttributeMapping.DEFAULT_DN_NAME);
            }
            return new AttributeMapping(this.searchDn, this.recursiveSearch, this.filter, this.reference, this.ldapName, this.name, this.rdn, this.roleRecursionDepth);
        }
    }
}

