/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.JarDiffUtils;
import org.jboss.as.patching.generator.PatchGenerator;

class DistributionItemFileImpl
extends DistributionContentItem {
    private final File file;
    private final Set<DistributionContentItem> children;
    private byte[] cachedMetadataHash = null;

    protected DistributionItemFileImpl(File file, DistributionContentItem parent) {
        this(file, parent, file.getName());
    }

    protected DistributionItemFileImpl(File file, DistributionContentItem parent, String name) {
        super(parent, name);
        this.file = file;
        this.children = file.isDirectory() ? new TreeSet<DistributionContentItem>() : NO_CHILDREN;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public byte[] getMetadataHash() {
        try {
            if (this.cachedMetadataHash == null) {
                this.cachedMetadataHash = HashUtils.hashFile((File)this.file);
            }
            return this.cachedMetadataHash;
        }
        catch (IOException e) {
            throw PatchGenerator.processingError(e, "failed to generate hash", new Object[0]);
        }
    }

    @Override
    public byte[] getComparisonHash() {
        try {
            return JarDiffUtils.calculateHash(this.file, this);
        }
        catch (Exception e) {
            throw PatchGenerator.processingError(e, "failed to generate hash", new Object[0]);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.file.isFile();
    }

    public Set<DistributionContentItem> getChildren() {
        return this.children;
    }
}

