/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectMapAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public interface AttributeMarshallers {
    public static final AttributeMarshaller SIMPLE = new DefaultAttributeMarshaller();
    public static final AttributeMarshaller SIMPLE_ELEMENT = new AttributeMarshaller.WrappedSimpleAttributeMarshaller();
    public static final AttributeMarshaller STRING_LIST = AttributeMarshaller.STRING_LIST;
    public static final AttributeMarshaller STRING_LIST_COMMA_DELIMITED = AttributeMarshaller.COMMA_STRING_LIST;
    public static final AttributeMarshaller STRING_LIST_NAMED_ELEMENT = new NamedStringListMarshaller();
    public static final AttributeMarshaller OBJECT_ELEMENT_ONLY = new AttributeMarshaller.ObjectMarshaller(true);
    public static final AttributeMarshaller OBJECT_ATTRIBUTE = new AttributeMarshaller.ObjectMarshaller(false);
    public static final AttributeMarshaller OBJECT_LIST_WRAPPED = new AttributeMarshaller.ObjectListMarshaller();
    public static final AttributeMarshaller OBJECT_LIST_UNWRAPPED = new AttributeMarshaller.UnwrappedObjectListMarshaller();
    public static final AttributeMarshaller OBJECT_LIST = OBJECT_LIST_WRAPPED;
    public static final AttributeMarshaller OBJECT_MAP_MARSHALLER = new ObjectMapAttributeMarshaller();
    public static final AttributeMarshaller PROPERTIES_WRAPPED = new PropertiesAttributeMarshaller();
    public static final AttributeMarshaller PROPERTIES_UNWRAPPED = new PropertiesAttributeMarshaller(null, false);

    public static AttributeMarshaller getObjectMapAttributeMarshaller(String keyElementName) {
        return new ObjectMapAttributeMarshaller(null, null, true, keyElementName);
    }

    public static AttributeMarshaller getObjectMapAttributeMarshaller(String elementName, String keyElementName, boolean wrapElement) {
        return new ObjectMapAttributeMarshaller(null, elementName, wrapElement, keyElementName);
    }

    public static AttributeMarshaller getObjectMapAttributeMarshaller(String elementName, boolean wrapElement) {
        return new ObjectMapAttributeMarshaller(null, elementName, wrapElement, null);
    }

    public static AttributeMarshaller getObjectMapAttributeMarshaller(String wrapperElementName, boolean wrapElement, String elementName, String keyElementName) {
        return new ObjectMapAttributeMarshaller(wrapperElementName, elementName, wrapElement, keyElementName);
    }

    public static AttributeMarshaller getSimpleListMarshaller(boolean wrapper) {
        return new SimpleListAttributeMarshaller(wrapper);
    }

    public static class NamedStringListMarshaller
    extends AttributeMarshaller.AttributeElementMarshaller {
        private final String xmlName;

        public NamedStringListMarshaller() {
            this.xmlName = null;
        }

        public NamedStringListMarshaller(String xmlName) {
            this.xmlName = xmlName;
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            assert (attribute instanceof StringListAttributeDefinition);
            try {
                List<String> list = ((StringListAttributeDefinition)attribute).unwrap(ExpressionResolver.SIMPLE, resourceModel);
                if (list.isEmpty()) {
                    return;
                }
                if (resourceModel.hasDefined(attribute.getName())) {
                    for (ModelNode value : resourceModel.get(attribute.getName()).asList()) {
                        writer.writeStartElement(this.xmlName == null ? attribute.getXmlName() : this.xmlName);
                        writer.writeAttribute("name", value.asString());
                        writer.writeEndElement();
                    }
                }
            }
            catch (OperationFailedException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public static class SimpleListAttributeMarshaller
    extends AttributeMarshaller {
        private final boolean wrap;

        SimpleListAttributeMarshaller(boolean wrap) {
            this.wrap = wrap;
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            assert (attribute instanceof SimpleListAttributeDefinition);
            SimpleListAttributeDefinition attr = (SimpleListAttributeDefinition)attribute;
            if (resourceModel.hasDefined(attribute.getName())) {
                if (this.wrap) {
                    writer.writeStartElement(attribute.getXmlName());
                }
                for (ModelNode handler : resourceModel.get(attribute.getName()).asList()) {
                    attr.getValueType().getMarshaller().marshallAsElement(attribute, handler, true, writer);
                }
                if (this.wrap) {
                    writer.writeEndElement();
                }
            }
        }
    }

    public static class ObjectMapAttributeMarshaller
    extends MapAttributeMarshaller {
        protected final String keyAttributeName;

        public ObjectMapAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement, String keyAttributeName) {
            super(wrapperElement, elementName, wrapElement);
            this.keyAttributeName = keyAttributeName == null ? "key" : keyAttributeName;
        }

        public ObjectMapAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement) {
            this(wrapperElement, elementName, wrapElement, null);
        }

        public ObjectMapAttributeMarshaller(String wrapperElement, boolean wrapElement) {
            this(wrapperElement, null, wrapElement);
        }

        public ObjectMapAttributeMarshaller(String keyAttributeName) {
            this(null, null, true, keyAttributeName);
        }

        public ObjectMapAttributeMarshaller() {
            this(null, null, true);
        }

        @Override
        public void marshallSingleElement(AttributeDefinition attribute, ModelNode property, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            ObjectMapAttributeDefinition map = (ObjectMapAttributeDefinition)attribute;
            AttributeDefinition[] valueTypes = map.getValueType().getValueTypes();
            writer.writeEmptyElement(this.elementName);
            Property p = property.asProperty();
            writer.writeAttribute(this.keyAttributeName, p.getName());
            for (AttributeDefinition valueType : valueTypes) {
                valueType.getMarshaller().marshall(valueType, p.getValue(), false, writer);
            }
        }
    }

    public static class PropertiesAttributeMarshaller
    extends MapAttributeMarshaller {
        public PropertiesAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement) {
            super(wrapperElement, elementName, wrapElement);
        }

        public PropertiesAttributeMarshaller(String wrapperElement, boolean wrapElement) {
            this(wrapperElement, null, wrapElement);
        }

        public PropertiesAttributeMarshaller() {
            this(null, null, true);
        }

        @Override
        public void marshallSingleElement(AttributeDefinition attribute, ModelNode property, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEmptyElement(this.elementName);
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.asProperty().getName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), property.asProperty().getValue().asString());
        }
    }

    public static abstract class MapAttributeMarshaller
    extends AttributeMarshaller {
        protected final String wrapperElement;
        protected final String elementName;
        protected final boolean wrapElement;

        public MapAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement) {
            this.wrapperElement = wrapperElement;
            this.elementName = elementName == null ? "property" : elementName;
            this.wrapElement = wrapElement;
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (!(resourceModel = resourceModel.get(attribute.getName())).isDefined()) {
                return;
            }
            String wrapper = this.wrapperElement == null ? attribute.getName() : this.wrapperElement;
            List<ModelNode> elementList = resourceModel.asList();
            if (elementList.isEmpty()) {
                if (this.wrapElement) {
                    writer.writeEmptyElement(wrapper);
                } else {
                    ControllerLogger.MGMT_OP_LOGGER.debugf("%s found ambigous empty value for unwrapped property %s", (Object)this.getClass().getSimpleName(), (Object)attribute.getName());
                }
                return;
            }
            if (this.wrapElement) {
                writer.writeStartElement(wrapper);
            }
            for (ModelNode property : elementList) {
                this.marshallSingleElement(attribute, property, marshallDefault, writer);
            }
            if (this.wrapElement) {
                writer.writeEndElement();
            }
        }

        @Override
        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            this.marshallAsElement(attribute, resourceModel, marshallDefault, writer);
        }

        @Override
        public boolean isMarshallableAsElement() {
            return true;
        }

        public abstract void marshallSingleElement(AttributeDefinition var1, ModelNode var2, boolean var3, XMLStreamWriter var4) throws XMLStreamException;
    }
}

