/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.EnumSet;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

final class OperationHeaders {
    private static final AttributeDefinition ROLLBACK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("rollback-on-runtime-failure", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.TRUE)).build();
    private static final AttributeDefinition RESTART = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("allow-resource-service-restart", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).build();
    private static final AttributeDefinition BLOCKING = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("blocking-timeout", ModelType.INT).setRequired(false)).build();
    private static final OperationHeaders INTERNAL = new OperationHeaders(EnumSet.noneOf(AbstractOperationContext.ContextFlag.class), null, null, null, null);
    private final EnumSet<AbstractOperationContext.ContextFlag> contextFlags;
    private final Integer blockingTimeout;
    private final String warningLevel;
    private final String domainUUID;
    private final AccessMechanism accessMechanism;

    static OperationHeaders forInternalCall() {
        return INTERNAL;
    }

    static OperationHeaders fromOperation(ModelNode operation) throws OperationFailedException {
        EnumSet<AbstractOperationContext.ContextFlag> contextFlags;
        Integer blockingTimeout = null;
        String warningLevel = null;
        String domainUUID = null;
        AccessMechanism accessMechanism = null;
        if (operation.hasDefined("operation-headers")) {
            ModelNode blockingTimeoutConfig;
            ModelNode headers = operation.get("operation-headers").clone();
            boolean rollbackOnFailure = ROLLBACK.resolveModelAttribute(ExpressionResolver.REJECTING, headers).asBoolean();
            boolean restartResourceServices = RESTART.resolveModelAttribute(ExpressionResolver.REJECTING, headers).asBoolean();
            EnumSet<AbstractOperationContext.ContextFlag> enumSet = contextFlags = rollbackOnFailure ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
            if (restartResourceServices) {
                contextFlags.add(AbstractOperationContext.ContextFlag.ALLOW_RESOURCE_SERVICE_RESTART);
            }
            if ((blockingTimeoutConfig = BLOCKING.resolveModelAttribute(ExpressionResolver.REJECTING, headers)).isDefined() && (blockingTimeout = Integer.valueOf(blockingTimeoutConfig.asInt())) < 1) {
                throw ControllerLogger.MGMT_OP_LOGGER.invalidBlockingTimeout(blockingTimeout.longValue(), "blocking-timeout");
            }
            warningLevel = headers.hasDefined("warning-level") ? headers.get("warning-level").asString() : null;
            domainUUID = headers.hasDefined("domain-uuid") ? headers.get("domain-uuid").asString() : null;
            accessMechanism = headers.hasDefined("access-mechanism") ? AccessMechanism.valueOf(headers.get("access-mechanism").asString()) : null;
        } else {
            contextFlags = EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL);
        }
        return new OperationHeaders(contextFlags, blockingTimeout, warningLevel, domainUUID, accessMechanism);
    }

    static OperationHeaders forBoot(boolean rollbackOnRuntimeFailure) {
        EnumSet<AbstractOperationContext.ContextFlag> contextFlags = rollbackOnRuntimeFailure ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
        return new OperationHeaders(contextFlags, null, null, null, null);
    }

    static OperationResponse fromFailure(OperationFailedException ofe) {
        ModelNode responseNode = new ModelNode();
        responseNode.get("outcome").set("failed");
        responseNode.get("failure-description").set(ofe.getFailureDescription());
        return OperationResponse.Factory.createSimple(responseNode);
    }

    private OperationHeaders(EnumSet<AbstractOperationContext.ContextFlag> contextFlags, Integer blockingTimeout, String warningLevel, String domainUUID, AccessMechanism accessMechanism) {
        this.contextFlags = contextFlags;
        this.blockingTimeout = blockingTimeout;
        this.warningLevel = warningLevel;
        this.domainUUID = domainUUID;
        this.accessMechanism = accessMechanism;
    }

    EnumSet<AbstractOperationContext.ContextFlag> getContextFlags() {
        return this.contextFlags;
    }

    Integer getBlockingTimeout() {
        return this.blockingTimeout;
    }

    String getWarningLevel() {
        return this.warningLevel;
    }

    String getDomainUUID() {
        return this.domainUUID;
    }

    AccessMechanism getAccessMechanism() {
        return this.accessMechanism;
    }
}

