/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.ZipUtils;
import org.jboss.as.patching.generator.Distribution;
import org.jboss.as.patching.generator.ModuleDiffUtils;
import org.jboss.as.patching.generator.PatchBuilderWrapper;
import org.jboss.as.patching.generator.PatchBundleGenerator;
import org.jboss.as.patching.generator.PatchConfig;
import org.jboss.as.patching.generator.PatchConfigXml;
import org.jboss.as.patching.generator.PatchContentWriter;
import org.jboss.as.patching.generator.PatchGenLogger;
import org.jboss.as.patching.generator.TemplateGenerator;
import org.jboss.as.patching.generator.Usage;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchMerger;
import org.jboss.as.version.ProductConfig;
import org.jboss.modules.Module;

public class PatchGenerator {
    public static final String APPLIES_TO_DIST = "--applies-to-dist";
    public static final String ASSEMBLE_PATCH_BUNDLE = "--assemble-patch-bundle";
    public static final String CREATE_TEMPLATE = "--create-template";
    public static final String DETAILED_INSPECTION = "--detailed-inspection";
    public static final String INCLUDE_VERSION = "--include-version";
    public static final String COMBINE_WITH = "--combine-with";
    public static final String OUTPUT_FILE = "--output-file";
    public static final String PATCH_CONFIG = "--patch-config";
    public static final String UPDATED_DIST = "--updated-dist";
    private final boolean includeVersion;
    private final File patchConfigFile;
    private final File oldRoot;
    private final File newRoot;
    private File patchFile;
    private final File previousCp;
    private File tmp;

    public static void main(String[] args) {
        try {
            PatchGenerator patchGenerator = PatchGenerator.parse(args);
            if (patchGenerator != null) {
                patchGenerator.process();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PatchGenerator(File patchConfig, File oldRoot, File newRoot, File patchFile, boolean includeVersion, File previousCp) {
        this.patchConfigFile = patchConfig;
        this.oldRoot = oldRoot;
        this.newRoot = newRoot;
        this.patchFile = patchFile;
        this.includeVersion = includeVersion;
        this.previousCp = previousCp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws PatchingException, IOException, XMLStreamException {
        try {
            String[] stringArray;
            boolean includeVersion;
            PatchConfig patchConfig = this.parsePatchConfig();
            TreeSet<String> required = new TreeSet<String>();
            if (this.newRoot == null) {
                required.add(UPDATED_DIST);
            }
            if (this.oldRoot == null) {
                required.add(APPLIES_TO_DIST);
            }
            if (this.patchFile == null) {
                if (this.newRoot != null) {
                    this.patchFile = new File(this.newRoot, "patch-" + System.currentTimeMillis() + ".par");
                } else {
                    required.add(OUTPUT_FILE);
                }
            }
            if (!required.isEmpty()) {
                System.err.printf(PatchGenLogger.missingRequiredArgs(required), new Object[0]);
                PatchGenerator.usage();
                return;
            }
            this.createTempStructure(patchConfig.getPatchId());
            boolean bl = includeVersion = patchConfig.getPatchType() == Patch.PatchType.CUMULATIVE ? true : this.includeVersion;
            if (includeVersion) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "org/jboss/as/product";
                stringArray = stringArray2;
                stringArray2[1] = "org/jboss/as/version";
            }
            String[] ignored = stringArray;
            Distribution base = Distribution.create(this.oldRoot, ignored);
            Distribution updated = Distribution.create(this.newRoot, ignored);
            if (!patchConfig.isOverrideIdentity()) {
                if (!base.getName().equals(updated.getName())) {
                    throw PatchGenerator.processingError("distribution names don't match, expected: %s, but was %s ", base.getName(), updated.getName());
                }
                if (patchConfig.getAppliesToProduct() != null && !patchConfig.getAppliesToProduct().equals(base.getName())) {
                    throw PatchGenerator.processingError("patch target does not match, expected: %s, but was %s", patchConfig.getAppliesToProduct(), base.getName());
                }
                if (patchConfig.getAppliesToVersion() != null && !patchConfig.getAppliesToVersion().equals(base.getVersion())) {
                    throw PatchGenerator.processingError("patch target version does not match, expected: %s, but was %s", patchConfig.getAppliesToVersion(), base.getVersion());
                }
            }
            PatchBuilderWrapper builder = patchConfig.toPatchBuilder();
            builder.setPatchId(patchConfig.getPatchId());
            builder.setDescription(patchConfig.getDescription());
            builder.setOptionalPaths(patchConfig.getOptionalPaths());
            if (patchConfig.getPatchType() == Patch.PatchType.CUMULATIVE) {
                if (base.getVersion().equals(updated.getVersion())) {
                    System.out.println("WARN: cumulative patch does not upgrade version " + base.getVersion());
                }
                String name = base.getName();
                String version = base.getVersion();
                String toVersion = updated.getVersion();
                if (patchConfig.isOverrideIdentity()) {
                    name = patchConfig.getAppliesToProduct();
                    version = patchConfig.getAppliesToVersion();
                    toVersion = patchConfig.getResultingVersion();
                }
                builder.upgradeIdentity(name, version, toVersion);
            } else if (patchConfig.isOverrideIdentity()) {
                builder.oneOffPatchIdentity(patchConfig.getAppliesToProduct(), patchConfig.getAppliesToVersion());
            } else {
                builder.oneOffPatchIdentity(base.getName(), base.getVersion());
            }
            Patch patch = builder.compare(base, updated, includeVersion);
            PatchContentWriter.process(this.tmp, this.newRoot, patch);
            if (this.previousCp != null) {
                PatchMerger.merge((File)this.previousCp, (File)this.tmp, (File)this.patchFile);
            } else {
                ZipUtils.zip((File)this.tmp, (File)this.patchFile);
            }
        }
        finally {
            IoUtils.recursiveDelete((File)this.tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PatchConfig parsePatchConfig() throws FileNotFoundException, XMLStreamException {
        PatchConfig patchConfig;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.patchConfigFile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            patchConfig = PatchConfigXml.parse(bis);
        }
        catch (Throwable throwable) {
            IoUtils.safeClose(fis);
            throw throwable;
        }
        IoUtils.safeClose((Closeable)fis);
        return patchConfig;
    }

    private void createTempStructure(String patchId) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        int count = 0;
        while (this.tmp == null || this.tmp.exists()) {
            this.tmp = new File(tmpDir, "jboss-as-patch-" + patchId + "-" + ++count);
        }
        if (!this.tmp.mkdirs()) {
            throw PatchGenerator.processingError("Cannot create tmp dir for patch create at %s", this.tmp.getAbsolutePath());
        }
        this.tmp.deleteOnExit();
        File metaInf = new File(this.tmp, "META-INF");
        metaInf.mkdir();
        metaInf.deleteOnExit();
        File misc = new File(this.tmp, "misc");
        misc.mkdir();
        misc.deleteOnExit();
    }

    private static PatchGenerator parse(String[] args) throws Exception {
        File patchConfig = null;
        File oldFile = null;
        File newFile = null;
        File patchFile = null;
        boolean includeVersion = false;
        File combineWith = null;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                String val;
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    String homeDir = System.getSecurityManager() == null ? System.getProperty("jboss.home.dir") : Usage.getSystemProperty("jboss.home.dir");
                    ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), homeDir, Collections.emptyMap());
                    System.out.println(productConfig.getPrettyVersionString());
                    return null;
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-H".equals(arg)) {
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.startsWith(APPLIES_TO_DIST)) {
                    val = arg.substring(APPLIES_TO_DIST.length() + 1);
                    oldFile = new File(val);
                    if (!oldFile.exists()) {
                        System.err.printf(PatchLogger.ROOT_LOGGER.fileDoesNotExist(arg), new Object[0]);
                        PatchGenerator.usage();
                        return null;
                    }
                    if (oldFile.isDirectory()) continue;
                    System.err.printf(PatchGenLogger.fileIsNotADirectory(arg), new Object[0]);
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.startsWith(UPDATED_DIST)) {
                    val = arg.substring(UPDATED_DIST.length() + 1);
                    newFile = new File(val);
                    if (!newFile.exists()) {
                        System.err.printf(PatchLogger.ROOT_LOGGER.fileDoesNotExist(arg), new Object[0]);
                        PatchGenerator.usage();
                        return null;
                    }
                    if (newFile.isDirectory()) continue;
                    System.err.printf(PatchGenLogger.fileIsNotADirectory(arg), new Object[0]);
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.startsWith(PATCH_CONFIG)) {
                    val = arg.substring(PATCH_CONFIG.length() + 1);
                    patchConfig = new File(val);
                    if (!patchConfig.exists()) {
                        System.err.printf(PatchLogger.ROOT_LOGGER.fileDoesNotExist(arg), new Object[0]);
                        PatchGenerator.usage();
                        return null;
                    }
                    if (!patchConfig.isDirectory()) continue;
                    System.err.printf(PatchGenLogger.fileIsADirectory(arg), new Object[0]);
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.startsWith(OUTPUT_FILE)) {
                    val = arg.substring(OUTPUT_FILE.length() + 1);
                    patchFile = new File(val);
                    if (!patchFile.exists() || !patchFile.isDirectory()) continue;
                    System.err.printf(PatchGenLogger.fileIsADirectory(arg), new Object[0]);
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.equals(DETAILED_INSPECTION)) {
                    ModuleDiffUtils.deepInspection = true;
                    continue;
                }
                if (arg.equals(INCLUDE_VERSION)) {
                    includeVersion = true;
                    continue;
                }
                if (arg.equals(CREATE_TEMPLATE)) {
                    TemplateGenerator.generate(args);
                    return null;
                }
                if (arg.equals(ASSEMBLE_PATCH_BUNDLE)) {
                    PatchBundleGenerator.assemble(args);
                    return null;
                }
                if (!arg.startsWith(COMBINE_WITH) || (combineWith = new File(val = arg.substring(COMBINE_WITH.length() + 1))).exists()) continue;
                System.err.printf(PatchLogger.ROOT_LOGGER.fileDoesNotExist(arg), new Object[0]);
                PatchGenerator.usage();
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf(PatchGenLogger.argumentExpected(arg), new Object[0]);
                PatchGenerator.usage();
                return null;
            }
        }
        if (patchConfig == null) {
            System.err.printf(PatchGenLogger.missingRequiredArgs(Collections.singleton(PATCH_CONFIG)), new Object[0]);
            PatchGenerator.usage();
            return null;
        }
        return new PatchGenerator(patchConfig, oldFile, newFile, patchFile, includeVersion, combineWith);
    }

    private static void usage() {
        Usage usage = new Usage();
        usage.addArguments("--applies-to-dist=<file>");
        usage.addInstruction("Filesystem path of a pristine unzip of the distribution of the version of the software to which the generated patch applies");
        usage.addArguments("-h", "--help");
        usage.addInstruction("Display this message and exit");
        usage.addArguments("--output-file=<file>");
        usage.addInstruction("Filesystem location to which the generated patch file should be written");
        usage.addArguments("--patch-config=<file>");
        usage.addInstruction("Filesystem path of the patch generation configuration file to use");
        usage.addArguments("--updated-dist=<file>");
        usage.addInstruction("Filesystem path of a pristine unzip of a distribution of software which contains the changes that should be incorporated in the patch");
        usage.addArguments("-v", "--version");
        usage.addInstruction("Print version and exit");
        usage.addArguments(DETAILED_INSPECTION);
        usage.addInstruction("Enable detailed inspection for all modules.");
        usage.addArguments("--combine-with=<file>");
        usage.addInstruction("Filesystem path of the previous CP to be included into the same package with the newly generated one");
        String headline = usage.getDefaultUsageHeadline("patch-gen");
        System.out.print(usage.usage(headline));
    }

    static RuntimeException processingError(String message, Object ... arguments) {
        return new RuntimeException(String.format(message, arguments));
    }

    static RuntimeException processingError(Exception e, String message, Object ... arguments) {
        return new RuntimeException(String.format(message, arguments), e);
    }
}

