/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class ManagementInterfaceAddStepHandler
extends AbstractAddStepHandler {
    public static final OperationContext.AttachmentKey<Boolean> MANAGEMENT_INTERFACE_KEY = OperationContext.AttachmentKey.create(Boolean.class);

    protected ManagementInterfaceAddStepHandler(AttributeDefinition[] attributeDefinitions) {
        super(attributeDefinitions);
    }

    protected ManagementInterfaceAddStepHandler() {
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return WildFlySecurityManager.getPropertyPrivileged("jboss.as.test.disable.runtime", null) == null;
    }

    protected void addVerifyInstallationStep(OperationContext context, List<ServiceName> requiredServices) {
        if (context.isBooting()) {
            context.addStep(new LenientVerifyInstallationStep(requiredServices), OperationContext.Stage.VERIFY);
        }
    }

    protected String asStringIfDefined(OperationContext context, AttributeDefinition attribute, ModelNode model) throws OperationFailedException {
        ModelNode attributeValue = attribute.resolveModelAttribute(context, model);
        return attributeValue.isDefined() ? attributeValue.asString() : null;
    }

    private static class VerifyInstallationStep
    implements OperationStepHandler {
        private VerifyInstallationStep() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Boolean attachment = context.getAttachment(MANAGEMENT_INTERFACE_KEY);
            if (attachment == null || !context.getAttachment(MANAGEMENT_INTERFACE_KEY).booleanValue()) {
                ControllerLogger.ROOT_LOGGER.missingManagementServices();
                context.setRollbackOnly();
            }
        }
    }

    private static class LenientVerifyInstallationStep
    implements OperationStepHandler {
        private final List<ServiceName> requiredServices;

        private LenientVerifyInstallationStep(List<ServiceName> requiredServices) {
            assert (requiredServices != null);
            this.requiredServices = requiredServices;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ArrayList<ServiceName> failures = new ArrayList<ServiceName>();
            ServiceRegistry registry = context.getServiceRegistry(false);
            for (ServiceName serviceName : this.requiredServices) {
                try {
                    ServiceController<?> controller = registry.getService(serviceName);
                    if (controller != null && ServiceController.State.UP == controller.getState()) continue;
                    failures.add(serviceName);
                }
                catch (ServiceNotFoundException ex) {
                    failures.add(serviceName);
                }
            }
            if (!failures.isEmpty()) {
                Boolean attachment = context.getAttachment(MANAGEMENT_INTERFACE_KEY);
                if (attachment == null || !context.getAttachment(MANAGEMENT_INTERFACE_KEY).booleanValue()) {
                    context.attach(MANAGEMENT_INTERFACE_KEY, false);
                    context.addStep(new VerifyInstallationStep(), OperationContext.Stage.VERIFY);
                }
            } else {
                context.attach(MANAGEMENT_INTERFACE_KEY, true);
            }
        }
    }
}

