/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.patching.cli.AbstractDistributionCommand;
import org.jboss.as.patching.cli.PatchIdCompleter;
import org.jboss.as.patching.tool.PatchOperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependRejectOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.AbstractRejectOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;

@CommandDefinition(name="info", description="")
public class PatchInfo
extends AbstractDistributionCommand {
    @Option(name="patch-stream", hasValue=true, required=false, activator=PatchIdNoStreamsActivator.class)
    private String patchStream;
    @Argument(completer=PatchIdCompleter.class, activator=NoStreamsActivator.class)
    private String patchIdArg;
    @Option(name="patch-id", completer=PatchIdCompleter.class, activator=HideOptionActivator.class)
    private String patchId;
    @Option(hasValue=false, shortName=118, required=false, activator=PatchIdNoStreamsActivator.class)
    boolean verbose;
    @Option(hasValue=false, required=false, activator=NoPatchIdActivator.class)
    boolean streams;
    @Deprecated
    @Option(name="json-output", hasValue=false, required=false, activator=HideOptionActivator.class)
    boolean jsonOutput;

    public PatchInfo() {
        super("info");
    }

    private String getPatchId() throws CommandException {
        if (this.patchId != null && this.patchIdArg != null) {
            throw new CommandException("patch-id argument and options can't be set al together.");
        }
        if (this.patchId != null) {
            return this.patchId;
        }
        if (this.patchIdArg != null && !this.patchIdArg.isEmpty()) {
            return this.patchIdArg;
        }
        return null;
    }

    @Override
    protected PatchOperationBuilder createPatchOperationBuilder(CommandContext ctx) throws CommandException {
        if (this.streams) {
            return PatchOperationBuilder.Factory.streams();
        }
        String pId = this.getPatchId();
        PatchOperationBuilder builder = pId == null ? PatchOperationBuilder.Factory.info(this.patchStream) : PatchOperationBuilder.Factory.info(this.patchStream, pId, this.verbose);
        return builder;
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response) throws CommandException {
        if (this.getPatchId() != null) {
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return;
            }
            SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
            table.addLine("Patch ID:", result.get("patch-id").asString());
            table.addLine("Type:", result.get("type").asString());
            table.addLine("Identity name:", result.get("identity-name").asString());
            table.addLine("Identity version:", result.get("identity-version").asString());
            table.addLine("Description:", result.get("description").asString());
            if (result.hasDefined("link")) {
                table.addLine("Link:", result.get("link").asString());
            }
            ctx.printLine(table.toString(false));
            ModelNode elements = result.get("elements");
            if (elements.isDefined()) {
                ctx.printLine("");
                ctx.printLine("ELEMENTS");
                for (ModelNode e : elements.asList()) {
                    table = new SimpleTable(2, ctx.getTerminalWidth());
                    table.addLine("Patch ID:", e.get("patch-id").asString());
                    table.addLine("Name:", e.get("name").asString());
                    table.addLine("Type:", e.get("type").asString());
                    table.addLine("Description:", e.get("description").asString());
                    ctx.printLine("");
                    ctx.printLine(table.toString(false));
                }
            }
        } else if (this.jsonOutput) {
            ctx.printLine(response.toJSONString(false));
        } else if (this.streams) {
            List<ModelNode> list = response.get("result").asList();
            if (list.size() == 1) {
                ctx.printLine(list.get(0).asString());
            } else {
                ArrayList<String> streams = new ArrayList<String>(list.size());
                for (ModelNode stream : list) {
                    streams.add(stream.asString());
                }
                ctx.printColumns(streams);
            }
        } else {
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return;
            }
            SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
            table.addLine("Version:", result.get("version").asString());
            this.addPatchesInfo(result, table);
            ctx.printLine(table.toString(false));
            if (this.verbose) {
                this.printLayerPatches(ctx, result, "add-on");
                this.printLayerPatches(ctx, result, "layer");
            }
        }
    }

    private void printLayerPatches(CommandContext ctx, ModelNode result, String type) {
        ModelNode layer = result.get(type);
        if (layer.isDefined()) {
            String header = Character.toUpperCase(type.charAt(0)) + type.substring(1) + ':';
            for (String name : layer.keys()) {
                ModelNode node = layer.get(name);
                SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
                table.addLine(header, name);
                this.addPatchesInfo(node, table);
                ctx.printLine(lineSeparator + table.toString(false));
            }
        }
    }

    private void addPatchesInfo(ModelNode result, SimpleTable table) {
        String patchesStr;
        table.addLine("Cumulative patch ID:", result.get("cumulative-patch-id").asString());
        List<ModelNode> patches = result.get("patches").asList();
        if (patches.isEmpty()) {
            patchesStr = "none";
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(patches.get(0).asString());
            for (int i = 1; i < patches.size(); ++i) {
                buf.append(',').append(patches.get(i).asString());
            }
            patchesStr = buf.toString();
        }
        table.addLine("One-off patches:", patchesStr);
    }

    @Override
    String getPatchStream() {
        return this.patchStream;
    }

    public static class PatchIdNoStreamsActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> NOT_EXPECTED = new HashSet<String>();

        public PatchIdNoStreamsActivator() {
            super(true, EXPECTED, NOT_EXPECTED);
        }

        static {
            EXPECTED.add("");
            NOT_EXPECTED.add("streams");
        }
    }

    public static class NoPatchIdActivator
    extends AbstractRejectOptionActivator {
        public NoPatchIdActivator() {
            super("");
        }
    }

    public static class NoStreamsActivator
    extends AbstractRejectOptionActivator {
        public NoStreamsActivator() {
            super("streams");
        }
    }
}

