/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchInfo;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.LayerType;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchElementProvider;
import org.jboss.as.patching.metadata.PatchImpl;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.metadata.impl.IdentityImpl;
import org.jboss.as.patching.metadata.impl.PatchElementImpl;
import org.jboss.as.patching.runner.ContentTaskDefinitions;
import org.jboss.as.patching.runner.FailedFileRenaming;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchContentProvider;
import org.jboss.as.patching.runner.PatchModuleInvalidationUtils;
import org.jboss.as.patching.runner.PatchUtils;
import org.jboss.as.patching.runner.PatchingTask;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.as.patching.tool.PatchingResult;

class IdentityPatchContext
implements PatchContentProvider {
    private final File miscBackup;
    private final File configBackup;
    private final File miscTargetRoot;
    private final PatchEntry identityEntry;
    private final InstalledImage installedImage;
    private final PatchContentProvider contentProvider;
    private final ContentVerificationPolicy contentPolicy;
    private final InstallationManager.InstallationModification modification;
    private final Map<String, PatchContentLoader> contentLoaders = new HashMap<String, PatchContentLoader>();
    private final PatchingHistory history;
    private final Map<String, PatchEntry> layers = new LinkedHashMap<String, PatchEntry>();
    private final Map<String, PatchEntry> addOns = new LinkedHashMap<String, PatchEntry>();
    private PatchingTaskContext.Mode mode;
    private volatile State state = State.NEW;
    private boolean checkForGarbageOnRestart;
    private static final AtomicReferenceFieldUpdater<IdentityPatchContext, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(IdentityPatchContext.class, State.class, "state");
    private final List<File> moduleInvalidations = new ArrayList<File>();
    private List<File> modulesToReenable = Collections.emptyList();
    private List<File> modulesToDisable = Collections.emptyList();
    private final Map<String, FailedFileRenaming> renames = new LinkedHashMap<String, FailedFileRenaming>();
    static final FileFilter CONFIG_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathName) {
            return pathName.isFile() && pathName.getName().endsWith(".xml");
        }
    };

    IdentityPatchContext(File backup, PatchContentProvider contentProvider, ContentVerificationPolicy contentPolicy, InstallationManager.InstallationModification modification, PatchingTaskContext.Mode mode, InstalledImage installedImage) {
        this.miscTargetRoot = installedImage.getJbossHome();
        this.mode = mode;
        this.contentProvider = contentProvider;
        this.contentPolicy = contentPolicy;
        this.modification = modification;
        this.installedImage = installedImage;
        this.history = PatchingHistory.Factory.getHistory(modification.getUnmodifiedInstallationState());
        if (backup != null) {
            this.miscBackup = new File(backup, "misc");
            this.configBackup = new File(backup, "configuration");
        } else {
            this.miscBackup = null;
            this.configBackup = null;
        }
        this.identityEntry = new IdentityEntry(modification, null);
    }

    PatchEntry getIdentityEntry() {
        return this.identityEntry;
    }

    PatchEntry getEntry(String name, boolean addOn) {
        return addOn ? this.addOns.get(name) : this.layers.get(name);
    }

    Collection<PatchEntry> getLayers() {
        return this.layers.values();
    }

    Collection<PatchEntry> getAddOns() {
        return this.addOns.values();
    }

    InstallationManager.InstallationModification getModification() {
        return this.modification;
    }

    PatchingHistory getHistory() {
        return this.history;
    }

    PatchingTaskContext.Mode getMode() {
        return this.mode;
    }

    protected void failedToCleanupDir(File file) {
        this.checkForGarbageOnRestart = true;
        PatchLogger.ROOT_LOGGER.cannotDeleteFile(file.getAbsolutePath());
    }

    protected void failedToRenameFile(File file, File target) {
        if (!this.renames.containsKey(file.getAbsolutePath())) {
            this.renames.put(file.getAbsolutePath(), new FailedFileRenaming(file, target, this.getIdentityEntry().applyPatchId));
            PatchLogger.ROOT_LOGGER.cannotRenameFile(file.getAbsolutePath());
        }
    }

    @Override
    public PatchContentLoader getLoader(String patchId) {
        PatchContentLoader loader = this.contentLoaders.get(patchId);
        if (loader != null) {
            return loader;
        }
        return this.contentProvider.getLoader(patchId);
    }

    @Override
    public void cleanup() {
        if (this.state != State.PREPARED) {
            this.undoChanges();
        }
    }

    protected PatchEntry resolveForElement(PatchElement element) throws PatchingException {
        assert (this.state == State.NEW);
        PatchElementProvider provider = element.getProvider();
        String layerName = provider.getName();
        LayerType layerType = provider.getLayerType();
        Map<String, PatchEntry> map = layerType == LayerType.Layer ? this.layers : this.addOns;
        PatchEntry entry = map.get(layerName);
        if (entry == null) {
            InstallationManager.MutablePatchingTarget target = this.modification.resolve(layerName, layerType);
            if (target == null) {
                throw PatchLogger.ROOT_LOGGER.noSuchLayer(layerName);
            }
            entry = new PatchEntry(target, element);
            map.put(layerName, entry);
        }
        entry.updateElement(element);
        return entry;
    }

    protected PatchingResult finalize(final FinalizeCallback callback) throws Exception {
        assert (this.state == State.NEW);
        final Patch original = callback.getPatch();
        Patch.PatchType patchType = original.getIdentity().getPatchType();
        String patchId = patchType == Patch.PatchType.CUMULATIVE ? this.modification.getCumulativePatchID() : original.getPatchId();
        try {
            Patch processedPatch = this.createProcessedPatch(original);
            RollbackPatch rollbackPatch = this.createRollbackPatch(patchId, patchType);
            callback.finishPatch(processedPatch, rollbackPatch, this);
        }
        catch (Exception e) {
            if (this.undoChanges()) {
                callback.operationCancelled(this);
            }
            throw e;
        }
        this.state = State.PREPARED;
        return new PatchingResult(){

            @Override
            public String getPatchId() {
                return original.getPatchId();
            }

            @Override
            public PatchInfo getPatchInfo() {
                return new PatchInfo(){

                    @Override
                    public String getVersion() {
                        return IdentityPatchContext.this.identityEntry.getResultingVersion();
                    }

                    @Override
                    public String getCumulativePatchID() {
                        return IdentityPatchContext.this.identityEntry.delegate.getModifiedState().getCumulativePatchID();
                    }

                    @Override
                    public List<String> getPatchIDs() {
                        return IdentityPatchContext.this.identityEntry.delegate.getModifiedState().getPatchIDs();
                    }
                };
            }

            @Override
            public void commit() {
                if (IdentityPatchContext.this.state != State.PREPARED) {
                    IdentityPatchContext.this.undoChanges();
                    throw new IllegalStateException();
                }
                IdentityPatchContext.this.complete(IdentityPatchContext.this.modification, callback);
            }

            @Override
            public void rollback() {
                if (IdentityPatchContext.this.undoChanges()) {
                    try {
                        callback.operationCancelled(IdentityPatchContext.this);
                    }
                    finally {
                        IdentityPatchContext.this.modification.cancel();
                    }
                }
            }
        };
    }

    protected void cancel(FinalizeCallback callback) {
        try {
            this.undoChanges();
        }
        finally {
            callback.operationCancelled(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(InstallationManager.InstallationModification modification, FinalizeCallback callback) {
        ArrayList<File> processed = new ArrayList<File>();
        List reenabled = Collections.emptyList();
        List disabled = Collections.emptyList();
        try {
            try {
                if (stateUpdater.compareAndSet(this, State.PREPARED, State.INVALIDATE)) {
                    if (this.mode == PatchingTaskContext.Mode.APPLY) {
                        for (File invalidation : this.moduleInvalidations) {
                            processed.add(invalidation);
                            PatchModuleInvalidationUtils.processFile(this, invalidation, this.mode);
                        }
                        if (!this.modulesToReenable.isEmpty()) {
                            reenabled = new ArrayList(this.modulesToReenable.size());
                            for (File path : this.modulesToReenable) {
                                reenabled.add(path);
                                PatchModuleInvalidationUtils.processFile(this, path, PatchingTaskContext.Mode.ROLLBACK);
                            }
                        }
                    } else if (this.mode == PatchingTaskContext.Mode.ROLLBACK && !this.modulesToDisable.isEmpty()) {
                        disabled = new ArrayList(this.modulesToDisable.size());
                        for (File path : this.modulesToDisable) {
                            disabled.add(path);
                            PatchModuleInvalidationUtils.processFile(this, path, PatchingTaskContext.Mode.APPLY);
                        }
                    }
                }
                modification.complete();
                callback.completed(this);
                this.state = State.COMPLETED;
            }
            catch (Exception e) {
                this.moduleInvalidations.clear();
                this.moduleInvalidations.addAll(processed);
                this.modulesToReenable.clear();
                this.modulesToReenable.addAll(reenabled);
                this.modulesToDisable.clear();
                this.moduleInvalidations.addAll(disabled);
                throw new RuntimeException(e);
            }
        }
        finally {
            if (this.state != State.COMPLETED) {
                try {
                    modification.cancel();
                }
                finally {
                    try {
                        this.undoChanges();
                    }
                    finally {
                        callback.operationCancelled(this);
                    }
                }
            }
            try {
                if (this.checkForGarbageOnRestart) {
                    File cleanupMarker = new File(this.installedImage.getInstallationMetadata(), "cleanup-patching-dirs");
                    cleanupMarker.createNewFile();
                }
                this.storeFailedRenaming();
            }
            catch (IOException e) {
                PatchLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to create cleanup marker", new Object[0]);
            }
        }
    }

    private void storeFailedRenaming() throws IOException {
        if (!this.renames.isEmpty()) {
            File failedRenaming = new File(this.installedImage.getInstallationMetadata(), "cleanup-renaming-files");
            if (!failedRenaming.exists()) {
                failedRenaming.createNewFile();
            }
            ArrayList<String> failures = new ArrayList<String>(this.renames.keySet());
            PatchUtils.writeRefs(failedRenaming, failures, true);
        }
    }

    boolean undoChanges() {
        State state = stateUpdater.getAndSet(this, State.ROLLBACK_ONLY);
        if (state == State.COMPLETED || state == State.ROLLBACK_ONLY) {
            return false;
        }
        PatchingTaskContext.Mode currentMode = this.mode;
        this.mode = PatchingTaskContext.Mode.UNDO;
        PatchContentLoader loader = PatchContentLoader.create(this.miscBackup, null, null);
        IdentityPatchContext.undoChanges(this.identityEntry, loader);
        if (state == State.INVALIDATE || currentMode == PatchingTaskContext.Mode.ROLLBACK) {
            PatchingTaskContext.Mode mode = currentMode == PatchingTaskContext.Mode.APPLY ? PatchingTaskContext.Mode.ROLLBACK : PatchingTaskContext.Mode.APPLY;
            for (File file : this.moduleInvalidations) {
                try {
                    PatchModuleInvalidationUtils.processFile(this, file, mode);
                }
                catch (Exception e) {
                    PatchLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to restore state for %s", (Object)file);
                }
            }
            if (!this.modulesToReenable.isEmpty()) {
                for (File file : this.modulesToReenable) {
                    try {
                        PatchModuleInvalidationUtils.processFile(this, file, PatchingTaskContext.Mode.APPLY);
                    }
                    catch (Exception e) {
                        PatchLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to restore state for %s", (Object)file);
                    }
                }
            }
            if (!this.modulesToDisable.isEmpty()) {
                for (File file : this.modulesToDisable) {
                    try {
                        PatchModuleInvalidationUtils.processFile(this, file, PatchingTaskContext.Mode.ROLLBACK);
                    }
                    catch (Exception e) {
                        PatchLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to restore state for %s", (Object)file);
                    }
                }
            }
        }
        return true;
    }

    static void undoChanges(PatchEntry entry, PatchContentLoader loader) {
        ArrayList modifications = new ArrayList(entry.rollbackActions);
        for (ContentModification modification : modifications) {
            ContentItem item = modification.getItem();
            if (item.getContentType() != ContentType.MISC) continue;
            PatchingTaskDescription description = new PatchingTaskDescription(entry.applyPatchId, modification, loader, false, false, false);
            try {
                PatchingTask task = PatchingTask.Factory.create(description, entry);
                task.execute(entry);
            }
            catch (Exception e) {
                PatchLogger.ROOT_LOGGER.failedToUndoChange(item.toString());
            }
        }
    }

    private void recordRollbackLoader(String patchId, PatchableTarget.TargetInfo target) {
        DirectoryStructure structure = target.getDirectoryStructure();
        InstalledImage image = structure.getInstalledImage();
        File historyDir = image.getPatchHistoryDir(patchId);
        File miscRoot = new File(historyDir, "misc");
        File modulesRoot = structure.getModulePatchDirectory(patchId);
        File bundlesRoot = structure.getBundlesPatchDirectory(patchId);
        PatchContentLoader loader = PatchContentLoader.create(miscRoot, bundlesRoot, modulesRoot);
        this.recordContentLoader(patchId, loader);
    }

    protected void recordContentLoader(String patchID, PatchContentLoader contentLoader) {
        if (this.contentLoaders.containsKey(patchID)) {
            throw new IllegalStateException("Content loader already registered for patch " + patchID);
        }
        this.contentLoaders.put(patchID, contentLoader);
    }

    public boolean isIgnored(ContentItem item) {
        return this.contentPolicy.ignoreContentValidation(item);
    }

    public boolean isExcluded(ContentItem item) {
        return this.contentPolicy.preserveExisting(item);
    }

    public File getTargetFile(MiscContentItem item) {
        State state = this.state;
        if (state == State.NEW || state == State.ROLLBACK_ONLY) {
            return IdentityPatchContext.getTargetFile(this.miscTargetRoot, item);
        }
        throw new IllegalStateException();
    }

    protected Patch createProcessedPatch(Patch original) {
        PatchElement element;
        ArrayList<PatchElement> elements = new ArrayList<PatchElement>();
        for (PatchEntry entry : this.getLayers()) {
            element = IdentityPatchContext.createPatchElement(entry, entry.element.getId(), entry.modifications);
            elements.add(element);
        }
        for (PatchEntry entry : this.getAddOns()) {
            element = IdentityPatchContext.createPatchElement(entry, entry.element.getId(), entry.modifications);
            elements.add(element);
        }
        return new PatchImpl(original.getPatchId(), original.getDescription(), original.getLink(), original.getIdentity(), elements, this.identityEntry.modifications);
    }

    protected RollbackPatch createRollbackPatch(String patchId, Patch.PatchType patchType) {
        PatchElement element;
        ArrayList<PatchElement> elements = new ArrayList<PatchElement>();
        for (PatchEntry entry : this.getLayers()) {
            element = IdentityPatchContext.createRollbackElement(entry);
            elements.add(element);
        }
        for (PatchEntry entry : this.getAddOns()) {
            element = IdentityPatchContext.createRollbackElement(entry);
            elements.add(element);
        }
        InstalledIdentity installedIdentity = this.modification.getUnmodifiedInstallationState();
        String name = installedIdentity.getIdentity().getName();
        IdentityImpl identity = new IdentityImpl(name, this.modification.getVersion());
        if (patchType == Patch.PatchType.CUMULATIVE) {
            identity.setPatchType(Patch.PatchType.CUMULATIVE);
            identity.setResultingVersion(installedIdentity.getIdentity().getVersion());
        } else if (patchType == Patch.PatchType.ONE_OFF) {
            identity.setPatchType(Patch.PatchType.ONE_OFF);
        }
        List modifications = this.identityEntry.rollbackActions;
        PatchImpl delegate = new PatchImpl(patchId, "rollback patch", identity, elements, modifications);
        return new PatchImpl.RollbackPatchImpl(delegate, installedIdentity);
    }

    static File getTargetFile(File root, MiscContentItem item) {
        return PatchContentLoader.getMiscPath(root, item);
    }

    protected static PatchElement createRollbackElement(PatchEntry entry) {
        PatchElement patchElement = entry.element;
        Patch.PatchType patchType = patchElement.getProvider().getPatchType();
        String patchId = patchType == Patch.PatchType.CUMULATIVE ? entry.getCumulativePatchID() : patchElement.getId();
        return IdentityPatchContext.createPatchElement(entry, patchId, entry.rollbackActions);
    }

    protected static PatchElement createPatchElement(PatchEntry entry, String patchId, List<ContentModification> modifications) {
        PatchElement patchElement = entry.element;
        PatchElementImpl element = new PatchElementImpl(patchId);
        element.setProvider(patchElement.getProvider());
        element.getModifications().addAll(modifications);
        element.setDescription(patchElement.getDescription());
        return element;
    }

    void backupConfiguration() throws IOException {
        String configuration = "configuration";
        File a = new File(this.installedImage.getAppClientDir(), "configuration");
        File d = new File(this.installedImage.getDomainDir(), "configuration");
        File s = new File(this.installedImage.getStandaloneDir(), "configuration");
        if (a.exists()) {
            File ab = new File(this.configBackup, "appclient");
            IdentityPatchContext.backupDirectory(a, ab);
        }
        if (d.exists()) {
            File db = new File(this.configBackup, "domain");
            IdentityPatchContext.backupDirectory(d, db);
        }
        if (s.exists()) {
            File sb = new File(this.configBackup, "standalone");
            IdentityPatchContext.backupDirectory(s, sb);
        }
    }

    static void backupDirectory(File source, File target) throws IOException {
        File[] files;
        if (!target.exists() && !target.mkdirs()) {
            throw PatchLogger.ROOT_LOGGER.cannotCreateDirectory(target.getAbsolutePath());
        }
        for (File file : files = source.listFiles(CONFIG_FILTER)) {
            File t = new File(target, file.getName());
            IoUtils.copyFile(file, t);
        }
    }

    void restoreConfiguration(String rollingBackPatchID, boolean resetConfiguration) throws IOException {
        File backupConfigurationDir = new File(this.installedImage.getPatchHistoryDir(rollingBackPatchID), "configuration");
        File ba = new File(backupConfigurationDir, "appclient");
        File bd = new File(backupConfigurationDir, "domain");
        File bs = new File(backupConfigurationDir, "standalone");
        String configuration = resetConfiguration ? "configuration" : "configuration" + File.separator + "restored-configuration";
        if (ba.exists()) {
            File a = new File(this.installedImage.getAppClientDir(), configuration);
            IdentityPatchContext.backupDirectory(ba, a);
        }
        if (bd.exists()) {
            File d = new File(this.installedImage.getDomainDir(), configuration);
            IdentityPatchContext.backupDirectory(bd, d);
        }
        if (bs.exists()) {
            File s = new File(this.installedImage.getStandaloneDir(), configuration);
            IdentityPatchContext.backupDirectory(bs, s);
        }
    }

    static void writePatch(Patch rollbackPatch, File file) throws IOException {
        File parent = file.getParentFile();
        if (!(parent.isDirectory() || parent.mkdirs() || parent.exists())) {
            throw PatchLogger.ROOT_LOGGER.cannotCreateDirectory(file.getAbsolutePath());
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            PatchXml.marshal((OutputStream)os, rollbackPatch);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    static interface FinalizeCallback {
        public Patch getPatch();

        public void finishPatch(Patch var1, RollbackPatch var2, IdentityPatchContext var3) throws Exception;

        public void completed(IdentityPatchContext var1);

        public void operationCancelled(IdentityPatchContext var1);
    }

    class PatchEntry
    extends ContentTaskDefinitions
    implements InstallationManager.MutablePatchingTarget,
    PatchingTaskContext {
        private String applyPatchId;
        private PatchElement element;
        private final InstallationManager.MutablePatchingTarget delegate;
        private final List<ContentModification> modifications = new ArrayList<ContentModification>();
        private final List<ContentModification> rollbackActions = new ArrayList<ContentModification>();
        private final Set<String> rollbacks = new HashSet<String>();

        PatchEntry(InstallationManager.MutablePatchingTarget delegate, PatchElement element) {
            assert (delegate != null);
            this.delegate = delegate;
            this.element = element;
        }

        protected void updateElement(PatchElement element) {
            this.element = element;
        }

        protected String getResultingVersion() {
            throw new IllegalStateException();
        }

        public void setResultingVersion(String resultingVersion) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isApplied(String patchId) {
            return this.delegate.isApplied(patchId);
        }

        @Override
        public void rollback(String patchId) {
            this.rollbacks.add(patchId);
            this.delegate.rollback(patchId);
            IdentityPatchContext.this.recordRollbackLoader(patchId, this.delegate);
        }

        @Override
        public boolean isRolledback(String patchId) {
            return this.rollbacks.contains(patchId);
        }

        @Override
        public void apply(String patchId, Patch.PatchType patchType) {
            this.delegate.apply(patchId, patchType);
            this.applyPatchId = patchId;
        }

        @Override
        public String getCumulativePatchID() {
            return this.delegate.getCumulativePatchID();
        }

        @Override
        public List<String> getPatchIDs() {
            return this.delegate.getPatchIDs();
        }

        @Override
        public Properties getProperties() {
            return this.delegate.getProperties();
        }

        @Override
        public DirectoryStructure getDirectoryStructure() {
            return this.delegate.getDirectoryStructure();
        }

        @Override
        public File getBackupFile(MiscContentItem item) {
            if (IdentityPatchContext.this.state == State.NEW) {
                return IdentityPatchContext.getTargetFile(IdentityPatchContext.this.miscBackup, item);
            }
            if (IdentityPatchContext.this.state == State.ROLLBACK_ONLY) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean isExcluded(ContentItem contentItem) {
            return IdentityPatchContext.this.contentPolicy.preserveExisting(contentItem);
        }

        @Override
        public boolean isIgnored(ContentItem contentItem) {
            return IdentityPatchContext.this.contentPolicy.ignoreContentValidation(contentItem);
        }

        @Override
        public void recordChange(ContentModification change, ContentModification rollbackAction) {
            if (IdentityPatchContext.this.state == State.ROLLBACK_ONLY) {
                return;
            }
            if (change != null) {
                this.modifications.add(change);
            }
            if (rollbackAction != null) {
                this.rollbackActions.add(rollbackAction);
            }
        }

        @Override
        public PatchingTaskContext.Mode getCurrentMode() {
            return IdentityPatchContext.this.mode;
        }

        @Override
        public PatchableTarget.TargetInfo getModifiedState() {
            return this.delegate.getModifiedState();
        }

        @Override
        public File[] getTargetBundlePath() {
            PatchableTarget.TargetInfo updated = IdentityPatchContext.this.mode == PatchingTaskContext.Mode.APPLY ? this.delegate : this.delegate.getModifiedState();
            return PatchUtils.getBundlePath(this.delegate.getDirectoryStructure(), updated);
        }

        @Override
        public File[] getTargetModulePath() {
            PatchableTarget.TargetInfo updated = IdentityPatchContext.this.mode == PatchingTaskContext.Mode.APPLY ? this.delegate : this.delegate.getModifiedState();
            return PatchUtils.getModulePath(this.delegate.getDirectoryStructure(), updated);
        }

        @Override
        public File getTargetFile(ContentItem item) {
            if (item.getContentType() == ContentType.MISC) {
                return IdentityPatchContext.this.getTargetFile((MiscContentItem)item);
            }
            if (this.applyPatchId == null || IdentityPatchContext.this.state == State.ROLLBACK_ONLY) {
                throw new IllegalStateException("cannot process rollback tasks for modules/bundles");
            }
            DirectoryStructure structure = this.delegate.getDirectoryStructure();
            File root = item.getContentType() == ContentType.BUNDLE ? structure.getBundlesPatchDirectory(this.applyPatchId) : structure.getModulePatchDirectory(this.applyPatchId);
            return PatchContentLoader.getModulePath(root, (ModuleItem)item);
        }

        @Override
        public void invalidateRoot(File moduleRoot) throws IOException {
            List<File> files = this.listFiles(moduleRoot);
            if (files != null && !files.isEmpty()) {
                for (File file : files) {
                    IdentityPatchContext.this.moduleInvalidations.add(file);
                    if (IdentityPatchContext.this.mode != PatchingTaskContext.Mode.ROLLBACK) continue;
                    PatchModuleInvalidationUtils.processFile(null, file, IdentityPatchContext.this.mode);
                }
            }
        }

        void prepareForPortForward(ContentItem item, String patchId) throws IOException {
            File targetFile;
            List<File> files;
            if (item.getContentType() == ContentType.MODULE && (files = this.listFiles(targetFile = this.delegate.getDirectoryStructure().getModulePatchDirectory(patchId))) != null && !files.isEmpty()) {
                for (File file : files) {
                    IdentityPatchContext.this.moduleInvalidations.add(file);
                    PatchModuleInvalidationUtils.processFile(IdentityPatchContext.this, file, PatchingTaskContext.Mode.ROLLBACK);
                }
            }
        }

        void reenableBaseModule(ModuleItem item) throws IOException {
            File modulePath;
            List<File> files;
            if (IdentityPatchContext.this.modulesToReenable.isEmpty()) {
                IdentityPatchContext.this.modulesToReenable = new ArrayList();
            }
            if ((files = this.listFiles(modulePath = PatchContentLoader.getModulePath(this.getDirectoryStructure().getModuleRoot(), item.getName(), item.getSlot()))) != null && !files.isEmpty()) {
                for (File file : files) {
                    IdentityPatchContext.this.modulesToReenable.add(file);
                }
            }
        }

        void disableBaseModule(ModuleItem item) throws IOException {
            File modulePath;
            List<File> files;
            if (IdentityPatchContext.this.modulesToDisable.isEmpty()) {
                IdentityPatchContext.this.modulesToDisable = new ArrayList();
            }
            if ((files = this.listFiles(modulePath = PatchContentLoader.getModulePath(this.getDirectoryStructure().getModuleRoot(), item.getName(), item.getSlot()))) != null && !files.isEmpty()) {
                for (File file : files) {
                    IdentityPatchContext.this.modulesToDisable.add(file);
                }
            }
        }

        protected List<File> listFiles(File ... files) {
            ArrayList<File> result = new ArrayList<File>();
            for (File f : files) {
                String name = f.getName();
                if (f.isFile() && (name.endsWith(".jar") || name.endsWith(".jar.patched"))) {
                    result.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                result.addAll(this.listFiles(f.listFiles()));
            }
            return result;
        }

        protected void cleanupRollbackPatchHistory() {
            DirectoryStructure structure = this.getDirectoryStructure();
            for (String rollback : this.rollbacks) {
                if (!IoUtils.recursiveDelete(structure.getBundlesPatchDirectory(rollback))) {
                    IdentityPatchContext.this.failedToCleanupDir(structure.getBundlesPatchDirectory(rollback));
                }
                if (IoUtils.recursiveDelete(structure.getModulePatchDirectory(rollback))) continue;
                IdentityPatchContext.this.failedToCleanupDir(structure.getModulePatchDirectory(rollback));
            }
        }
    }

    class IdentityEntry
    extends PatchEntry {
        IdentityEntry(InstallationManager.MutablePatchingTarget delegate, PatchElement element) {
            super(delegate, element);
        }

        @Override
        protected String getResultingVersion() {
            return IdentityPatchContext.this.modification.getVersion();
        }

        @Override
        public void setResultingVersion(String resultingVersion) {
            IdentityPatchContext.this.modification.setResultingVersion(resultingVersion);
        }
    }

    static enum State {
        NEW,
        PREPARED,
        COMPLETED,
        INVALIDATE,
        ROLLBACK_ONLY;

    }
}

