/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aspects.security.support;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.EntitlementHolder;
import org.jboss.security.authorization.Permission;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.RoleGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockAuthorizationManager
implements AuthorizationManager {
    Map<String, Set<Principal>> roles = new HashMap<String, Set<Principal>>();

    public MockAuthorizationManager() {
        HashSet<SimplePrincipal> userRoles = new HashSet<SimplePrincipal>();
        userRoles.add(new SimplePrincipal("guest"));
        this.roles.put("user1", userRoles);
        userRoles = new HashSet();
        userRoles.add(new SimplePrincipal("administrator"));
        this.roles.put("user2", userRoles);
        userRoles = new HashSet();
        userRoles.add(new SimplePrincipal("administrator"));
        userRoles.add(new SimplePrincipal("manager"));
        this.roles.put("user3", userRoles);
    }

    public int authorize(Resource resource) throws AuthorizationException {
        return 0;
    }

    public int authorize(Resource resource, Subject subject) throws AuthorizationException {
        return 0;
    }

    public int authorize(Resource resource, Subject subject, RoleGroup role) throws AuthorizationException {
        return 0;
    }

    public int authorize(Resource resource, Subject subject, Group roleGroup) throws AuthorizationException {
        return 0;
    }

    public int authorize(Resource resource, Identity identity, Permission permission) throws AuthorizationException {
        return 0;
    }

    public boolean doesUserHaveRole(Principal principal, Set<Principal> roles) {
        Set<Principal> userRoles = this.roles.get(principal.getName());
        if (userRoles != null) {
            for (Principal role : roles) {
                if (!userRoles.contains(role)) continue;
                return true;
            }
        }
        return false;
    }

    public <T> EntitlementHolder<T> getEntitlements(Class<T> clazz, Resource resource, Identity identity) throws AuthorizationException {
        return null;
    }

    public RoleGroup getSubjectRoles(Subject authenticatedSubject, CallbackHandler cbh) {
        return null;
    }

    public Group getTargetRoles(Principal targetPrincipal, Map<String, Object> contextMap) {
        return null;
    }

    public Set<Principal> getUserRoles(Principal principal) {
        return this.roles.get(principal.getName());
    }

    public String getSecurityDomain() {
        return "other";
    }
}

