/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aspects.security.test;

import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;
import org.jboss.test.aspects.security.support.AnnotatedPOJO;

public class SecurityInterceptorsTestCase
extends TestCase {
    private static Logger logger = Logger.getLogger(SecurityInterceptorsTestCase.class);

    public void testAuthenticationInterceptor() throws Exception {
        AnnotatedPOJO pojo = null;
        try {
            pojo = new AnnotatedPOJO();
            SecurityInterceptorsTestCase.fail();
        }
        catch (RuntimeException re) {
            logger.info((Object)re.getMessage());
        }
        SecurityClient client = SecurityClientFactory.getSecurityClient();
        client.setSimple((Object)"user1", (Object)"badpass");
        client.login();
        try {
            pojo = new AnnotatedPOJO();
            SecurityInterceptorsTestCase.fail();
        }
        catch (SecurityException se) {
            logger.info((Object)se.getMessage());
        }
        client.logout();
        for (int i = 1; i < 5; ++i) {
            client.setSimple((Object)("user" + i), (Object)("pass" + i));
            client.login();
            pojo = new AnnotatedPOJO();
            client.logout();
        }
    }

    public void testAuthorizationInterceptor() throws Exception {
        AnnotatedPOJO pojo = null;
        SecurityClient client = SecurityClientFactory.getSecurityClient();
        client.setSimple((Object)"user1", (Object)"pass1");
        client.login();
        pojo = new AnnotatedPOJO();
        pojo.uncheckedOperation();
        try {
            pojo.excludedOperation();
            SecurityInterceptorsTestCase.fail();
        }
        catch (SecurityException se) {
            logger.info((Object)se.getMessage());
        }
        try {
            pojo.manageProtectedValue();
            SecurityInterceptorsTestCase.fail();
        }
        catch (SecurityException se) {
            logger.info((Object)se.getMessage());
        }
        try {
            pojo = new AnnotatedPOJO("Secret Phrase");
            SecurityInterceptorsTestCase.fail();
        }
        catch (SecurityException se) {
            logger.info((Object)se.getMessage());
        }
        client.logout();
        client.setSimple((Object)"user3", (Object)"pass3");
        client.login();
        pojo = new AnnotatedPOJO();
        pojo.uncheckedOperation();
        String phrase = pojo.manageProtectedValue();
        SecurityInterceptorsTestCase.assertNull((Object)phrase);
        pojo = new AnnotatedPOJO("Protected Info");
        pojo.uncheckedOperation();
        phrase = pojo.manageProtectedValue();
        SecurityInterceptorsTestCase.assertEquals((String)"Protected Info", (String)phrase);
        try {
            pojo.excludedOperation();
            SecurityInterceptorsTestCase.fail();
        }
        catch (SecurityException se) {
            logger.info((Object)se.getMessage());
        }
        client.logout();
    }

    public void testRunAsInterceptor() throws Exception {
        AnnotatedPOJO pojo = null;
        SecurityClient client = SecurityClientFactory.getSecurityClient();
        client.setSimple((Object)"user1", (Object)"pass1");
        client.login();
        pojo = new AnnotatedPOJO();
        String result = pojo.invokeDelegateRunAs();
        SecurityInterceptorsTestCase.assertEquals((String)"Delegate Result", (String)result);
        try {
            pojo.invokeDelegate();
            SecurityInterceptorsTestCase.fail();
        }
        catch (SecurityException se) {
            logger.info((Object)se.getMessage());
        }
        client.logout();
        client.setSimple((Object)"user3", (Object)"pass3");
        client.login();
        pojo = new AnnotatedPOJO("Protected Info");
        result = pojo.invokeDelegate();
        SecurityInterceptorsTestCase.assertEquals((String)"Delegate Result", (String)result);
        result = pojo.invokeDelegateRunAs();
        SecurityInterceptorsTestCase.assertEquals((String)"Delegate Result", (String)result);
        client.logout();
    }
}

