/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.classloader.domain.test;

import junit.framework.Test;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.test.support.MockClassLoaderPolicy;
import org.jboss.test.classloader.AbstractClassLoaderTest;
import org.jboss.test.classloader.domain.support.A;

/**
 * DomainCacheTestCase.
 *
 * @author <a href="aogburn@redhat.com">Aaron Ogburn</a>
 * @author <a href="ales.justin@jboss.org">Ales Justin</a>
 */
public class DomainCacheTestCase extends AbstractClassLoaderTest
{
   public static Test suite()
   {
      return suite(DomainCacheTestCase.class);
   }

   public DomainCacheTestCase(String name)
   {
      super(name);
   }

   public void testCache() throws Exception
   {
      ClassLoaderSystem system = createClassLoaderSystemWithModifiedBootstrap();
      //setup a parent classloader in the default domain.
      MockClassLoaderPolicy policyA = createMockClassLoaderPolicy("a");
      policyA.setPathsAndPackageNames(A.class);
      ClassLoader clA = system.registerClassLoaderPolicy(policyA);

      //set up a child domain/classloader with the default domain
      ClassLoaderDomain childDomain = system.createAndRegisterDomain("childDomain", ParentPolicy.BEFORE, system.getDefaultDomain());
      MockClassLoaderPolicy policyB = createMockClassLoaderPolicy("b");
      policyB.setImportAll(true); // AS5 has by default import-all
      BaseClassLoader clB = (BaseClassLoader) system.registerClassLoaderPolicy("childDomain", policyB);
      assertLoadClass(A.class, clB, clA);

      //We should have cached the result of the above lookup in the childDomain's globalClassCache to avoid potential performance issues (JBCL-185).  Did we?
      if (childDomain.checkClassCache(clB, A.class.getName(), "org/jboss/test/classloader/domain/support/A.class", policyB.isImportAll()) == null)
         fail("Failed to store and find class from domain globalClassCache");

      assertLoadClass(A.class, clB, clA); // find a way to check if we really hit cache
   }
}
