/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.classloader.resources.tests;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import junit.framework.Test;

import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.test.support.MockClassLoaderPolicy;
import org.jboss.test.classloader.domain.support.MockLoader;
import org.jboss.test.classloader.domain.test.ParentPolicyUnitTestCase;

import java.net.URL;
import java.net.URLClassLoader;

public class JBPAPP6824TestBase extends org.jboss.test.classloader.AbstractClassLoaderTestWithSecurity
{
   private String SYSTEM_PROPERTY = "org.jboss.classloader.honor.resource.delegation";
   private ClassLoader previousClassLoader;

   public JBPAPP6824TestBase(String name)
   {
      super(name);
   }

   public static Test suite()
   {
      return suite(JBPAPP6824TestBase.class);
   }

   protected void setSystemProperty(final String key, final String value)
   {      
      SecurityManager sm = suspendSecurity();
      try
      {
         java.security.AccessController.doPrivileged
          (
              new java.security.PrivilegedAction<String>()
              {
                public String run()
                {
                  return System.setProperty(key, value);               
                }
              }
          );
      }
      finally
      {
         resumeSecurity(sm);
      }
   }
   
   protected Boolean getSystemProperty()
   {
      SecurityManager sm = suspendSecurity();

      try
      {        
         Boolean useCorrectParentFirstResourceLoading =
            java.security.AccessController.doPrivileged
          (
              new java.security.PrivilegedAction<Boolean>()
              {
                public Boolean run()
                {
                  Boolean value = Boolean.valueOf ( System.getProperty(SYSTEM_PROPERTY, "false") );
                  return value;
                }
              }
          );
         return useCorrectParentFirstResourceLoading;
      }
      finally
      {
         resumeSecurity(sm);
      }
   }
   
   protected URL assertGetResource(String prefix, String resourcePath, ClassLoader classLoader) throws Exception
   {
      URL url = classLoader.getResource(resourcePath);     
      assertNotNull("Should have got resource prefix=" + prefix + " resourcePath " + resourcePath + " from " + classLoader, url);
      SecurityManager sm = suspendSecurity();
      try
      {
         InputStream is = url.openStream();
         try
         {
            InputStreamReader reader = new InputStreamReader(is);
            char[] chars = new char[1000];
            int count = 0;
            int read = reader.read(chars);
            while (read != -1)
            {
               count += read;
               read = reader.read(chars, read, 1000 - read);
            }
            String string = new String(chars, 0, count);
            assertEquals("Should have read the correct resource", prefix + resourcePath, string);
         }
         finally
         {
            is.close();
         }
      }
      finally
      {
         resumeSecurity(sm);
      }
      return url;
   }
}
