/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.classloader.resources.tests;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import junit.framework.Test;

import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.test.support.MockClassLoaderPolicy;
import org.jboss.test.classloader.domain.support.MockLoader;
import org.jboss.test.classloader.domain.test.ParentPolicyUnitTestCase;

import java.net.URL;
import java.net.URLClassLoader;

// extending base class, this is because maven will not run tests in a testcase in a separate jvm which is needed to test system property
public class JBPAPP6824EnabledTestCase extends JBPAPP6824TestBase
{
   private String SYSTEM_PROPERTY = "org.jboss.classloader.honor.resource.delegation";
   private ClassLoader previousClassLoader;

   public JBPAPP6824EnabledTestCase(String name)
   {
      super(name);
   }

   public static Test suite()
   {
      return suite(JBPAPP6824EnabledTestCase.class);
   }

   // base on org.jboss.test.classloader.resources.tests.ResourceUnitTestCase extends org.jboss.test.classloader.AbstractClassLoaderTestWithSecurity
   public void testGetResourceFromParentBeforeJBPAPP682() throws Exception
   {
      System.out.println("property: " + getSystemProperty());
      setSystemProperty(SYSTEM_PROPERTY, "true");
      System.out.println("property after: " + getSystemProperty());
      System.out.println("Classloader type: " + Thread.currentThread().getContextClassLoader().getClass());        

      try
      {
         // prefix is only on MockClassLoaderPolicy, it looks like it is just used to verify where the resource was found. So there will be two 
         // testResources in the same package but will be prefixed with a (parent) and b (child)
         // The testResources are packaged in the resources directory, the policy is overriding getResource and prepending the prefix
         ClassLoaderSystem system = createClassLoaderSystem();
         ClassLoaderDomain parent = system.createAndRegisterDomain("parent");
         MockClassLoaderPolicy policy = createMockClassLoaderPolicy();
         policy.setPrefix("a/");
         policy.setPath("com/acme/p1");
         policy.setPackageNames(new String[] { "com.acme.p1" } );
         system.registerClassLoaderPolicy(parent, policy);
   
         ClassLoaderDomain child = system.createAndRegisterDomain("child", ParentPolicy.BEFORE, parent);
         MockClassLoaderPolicy policy2 = createMockClassLoaderPolicy();
         policy2.setPrefix("b/");
         policy2.setPath("com/acme/p1");
         ClassLoader classLoader = system.registerClassLoaderPolicy(child, policy2);
         
         assertGetResource("a/", "com/acme/p1/testResource", classLoader);
      }
      finally
      {
         setSystemProperty(SYSTEM_PROPERTY, "false");
      }
   }
}
