/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.UpdateableCacheLoader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;
import org.jboss.classloader.spi.base.BaseClassLoaderSystem;
import org.jboss.classloader.spi.base.BaseDelegateLoader;
import org.jboss.classloader.spi.base.ClassLoaderInformation;
import org.jboss.classloader.spi.base.ClassLoaderManager;
import org.jboss.classloader.spi.base.ClassLoadingTask;
import org.jboss.logging.Logger;
import org.jboss.util.collection.ConcurrentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClassLoaderDomain
implements UpdateableCacheLoader {
    private static final Logger log = Logger.getLogger(BaseClassLoaderDomain.class);
    private BaseClassLoaderSystem system;
    private List<ClassLoaderInformation> classLoaders = new CopyOnWriteArrayList<ClassLoaderInformation>();
    private Map<ClassLoader, ClassLoaderInformation> infos = new ConcurrentHashMap<ClassLoader, ClassLoaderInformation>();
    private Map<String, List<ClassLoaderInformation>> classLoadersByPackageName = new ConcurrentHashMap<String, List<ClassLoaderInformation>>();
    private Map<String, ClassCacheItem> globalClassCache = new ConcurrentHashMap<String, ClassCacheItem>();
    private Set<String> globalClassBlackList = new ConcurrentSet();
    private Map<String, URL> globalResourceCache = new ConcurrentHashMap<String, URL>();
    private Map<String, Set<URL>> globalResourcesCache = new ConcurrentHashMap<String, Set<URL>>();
    private Set<String> globalResourceBlackList = new ConcurrentSet();
    private int order = 0;
    private static final Boolean honorResourceDelegation = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.valueOf(System.getProperty("org.jboss.classloader.honor.resource.delegation", "false"));
        }
    });

    public void flushCaches() {
        this.globalClassCache.clear();
        this.globalClassBlackList.clear();
        this.globalResourceCache.clear();
        this.globalResourcesCache.clear();
        this.globalResourceBlackList.clear();
        for (ClassLoaderInformation info : this.classLoaders) {
            info.flushCaches();
        }
    }

    public int getClassBlackListSize() {
        return this.globalClassBlackList.size();
    }

    public int getClassCacheSize() {
        return this.globalClassCache.size();
    }

    public int getResourceBlackListSize() {
        return this.globalResourceBlackList.size();
    }

    public int getResourceCacheSize() {
        return this.globalResourceCache.size();
    }

    public int getResourcesCacheSize() {
        return this.globalResourcesCache.size();
    }

    public Set<String> listClassBlackList() {
        return Collections.unmodifiableSet(this.globalClassBlackList);
    }

    public Map<String, String> listClassCache() {
        HashMap<String, String> result = new HashMap<String, String>(this.globalClassCache.size());
        for (Map.Entry<String, ClassCacheItem> entry : this.globalClassCache.entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public Set<String> listResourceBlackList() {
        return Collections.unmodifiableSet(this.globalResourceBlackList);
    }

    public Map<String, URL> listResourceCache() {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.putAll(this.globalResourceCache);
        for (Map.Entry<String, Set<URL>> e : this.globalResourcesCache.entrySet()) {
            if (map.containsKey(e.getKey()) || e.getValue().isEmpty()) continue;
            map.put(e.getKey(), e.getValue().iterator().next());
        }
        return map;
    }

    protected synchronized BaseClassLoaderSystem getClassLoaderSystem() {
        return this.system;
    }

    synchronized void setClassLoaderSystem(BaseClassLoaderSystem system) {
        if (system == null) {
            this.shutdownDomain();
        }
        this.system = system;
    }

    protected void shutdownDomain() {
        Iterator<ClassLoaderInformation> iterator;
        log.debug((Object)(this.toString() + " shutdown!"));
        while ((iterator = this.classLoaders.iterator()).hasNext()) {
            while (iterator.hasNext()) {
                ClassLoaderInformation info = iterator.next();
                if (info == null) continue;
                this.unregisterClassLoader(info.getClassLoader());
            }
        }
        this.flushCaches();
    }

    public boolean hasClassLoaders() {
        return !this.classLoaders.isEmpty();
    }

    protected boolean isBlackListedClass(String name) {
        return this.globalClassBlackList.contains(name);
    }

    public abstract boolean isUseLoadClassForParent();

    protected byte[] transform(ClassLoader classLoader, String className, byte[] byteCode, ProtectionDomain protectionDomain) throws Exception {
        BaseClassLoaderSystem system = this.getClassLoaderSystem();
        if (system != null) {
            return system.transform(classLoader, className, byteCode, protectionDomain);
        }
        return byteCode;
    }

    protected Class<?> loadClass(BaseClassLoader classLoader, String name, boolean allExports) throws ClassNotFoundException {
        ClassLoaderPolicy policy;
        ClassLoader hack;
        Class<?> clazz;
        Class<?> clazz2;
        boolean findInParent;
        boolean trace = log.isTraceEnabled();
        String path = ClassLoaderUtils.classNameToPath(name);
        boolean bl = findInParent = !this.isUseLoadClassForParent();
        if (!findInParent && (clazz2 = this.loadClassBefore(name)) != null) {
            return clazz2;
        }
        Loader loader = this.findLoader(classLoader, path, allExports, findInParent);
        if (loader != null) {
            Thread thread = Thread.currentThread();
            ClassLoadingTask task = new ClassLoadingTask(name, classLoader, thread);
            ClassLoaderManager.scheduleTask(task, loader, false);
            Class<?> result = ClassLoaderManager.process(thread, task);
            if (loader instanceof UpdateableCacheLoader) {
                ((UpdateableCacheLoader)UpdateableCacheLoader.class.cast(loader)).updateClassCache(classLoader, path, result);
            } else {
                ClassCacheItem item = this.globalClassCache.get(path);
                if (item != null) {
                    item.clazz = result;
                }
            }
            return result;
        }
        if (!findInParent && (clazz = this.loadClassAfter(name)) != null) {
            return clazz;
        }
        if (classLoader != null && (hack = ((BaseClassLoaderPolicy)(policy = classLoader.getPolicy())).isJDKRequest(name)) != null) {
            Class<?> result;
            if (trace) {
                log.trace((Object)(this + " trying to load " + name + " using hack " + hack));
            }
            if ((result = Class.forName(name, false, hack)) != null) {
                if (trace) {
                    log.trace((Object)(this + " loaded from hack " + hack + " " + ClassLoaderUtils.classToString(result)));
                }
                this.globalClassCache.put(path, new ClassCacheItem(result));
                return result;
            }
        }
        return null;
    }

    protected Loader findLoader(String name) {
        return this.findLoader(null, name, true, true);
    }

    Loader findLoader(BaseClassLoader classLoader, String name, boolean allExports, boolean findInParent) {
        ClassLoaderPolicy policy;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " findLoader " + name + " classLoader=" + classLoader + " allExports=" + allExports + " findInParent=" + findInParent));
        }
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        Loader loader = null;
        if (findInParent) {
            loader = this.findBeforeLoader(name);
        }
        if (loader != null) {
            return loader;
        }
        ClassLoaderInformation info = null;
        if (classLoader != null) {
            info = this.infos.get(classLoader);
            policy = classLoader.getPolicy();
            if (((BaseClassLoaderPolicy)policy).isImportAll()) {
                allExports = true;
            }
        }
        if (allExports) {
            loader = this.findLoaderInExports(classLoader, name, trace);
            if (loader != null) {
                return loader;
            }
        } else if (trace) {
            log.trace((Object)(this + " not loading " + name + " from all exports"));
        }
        if (info != null && (loader = this.findLoaderInImports(info, name, trace)) != null) {
            return loader;
        }
        if (classLoader != null) {
            if (trace) {
                log.trace((Object)(this + " trying to load " + name + " from requesting " + classLoader));
            }
            if (classLoader.getResourceLocally(name) != null) {
                loader = classLoader.getLoader();
                policy = classLoader.getPolicy();
                if (((BaseClassLoaderPolicy)policy).isCacheable()) {
                    this.globalClassCache.put(name, new ClassCacheItem(loader));
                }
                return loader;
            }
        }
        if (findInParent) {
            return this.findAfterLoader(name);
        }
        return null;
    }

    URL getResource(BaseClassLoader classLoader, String name, boolean allExports) {
        boolean trace = log.isTraceEnabled();
        URL result = null;
        if (honorResourceDelegation.booleanValue() && (result = this.beforeGetResource(name)) != null) {
            return result;
        }
        if (classLoader != null) {
            if (trace) {
                log.trace((Object)(this + " trying to get resource " + name + " from requesting " + classLoader));
            }
            if ((result = classLoader.getResourceLocally(name)) != null) {
                if (trace) {
                    log.trace((Object)(this + " got resource from requesting " + classLoader + " " + result));
                }
                return result;
            }
        }
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        if (!honorResourceDelegation.booleanValue() && (result = this.beforeGetResource(name)) != null) {
            return result;
        }
        ClassLoaderInformation info = null;
        if (classLoader != null) {
            ClassLoaderPolicy policy = classLoader.getPolicy();
            info = this.infos.get(classLoader);
            if (((BaseClassLoaderPolicy)policy).isImportAll()) {
                allExports = true;
            }
        }
        if (allExports) {
            result = this.getResourceFromExports(classLoader, name, trace);
            if (result != null) {
                return result;
            }
        } else if (trace) {
            log.trace((Object)(this + " not getting resource " + name + " from all exports"));
        }
        if (info != null && (result = this.getResourceFromImports(info, name, trace)) != null) {
            return result;
        }
        result = this.afterGetResource(name);
        if (result != null) {
            return result;
        }
        return null;
    }

    void getResources(BaseClassLoader classLoader, String name, Set<URL> urls, boolean allExports) throws IOException {
        boolean trace = log.isTraceEnabled();
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        this.beforeGetResources(name, urls);
        ClassLoaderInformation info = null;
        if (classLoader != null) {
            ClassLoaderPolicy policy = classLoader.getPolicy();
            info = this.infos.get(classLoader);
            if (((BaseClassLoaderPolicy)policy).isImportAll()) {
                allExports = true;
            }
        }
        if (allExports) {
            this.getResourcesFromExports(classLoader, name, urls, trace);
        } else if (trace) {
            log.trace((Object)(this + " not getting resource " + name + " from all exports"));
        }
        if (info != null) {
            this.getResourcesFromImports(info, name, urls, trace);
        }
        if (classLoader != null) {
            if (trace) {
                log.trace((Object)(this + " trying to get resources " + name + " from requesting " + classLoader));
            }
            classLoader.getResourcesLocally(name, urls);
        }
        this.afterGetResources(name, urls);
    }

    Package getPackage(BaseClassLoader classLoader, String name, boolean allExports) {
        boolean trace = log.isTraceEnabled();
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        Package result = this.beforeGetPackage(name);
        if (result != null) {
            return result;
        }
        ClassLoaderInformation info = null;
        if (classLoader != null) {
            ClassLoaderPolicy policy = classLoader.getPolicy();
            info = this.infos.get(classLoader);
            if (((BaseClassLoaderPolicy)policy).isImportAll()) {
                allExports = true;
            }
        }
        if (allExports) {
            result = this.getPackageFromExports(classLoader, name, trace);
            if (result != null) {
                return result;
            }
        } else if (trace) {
            log.trace((Object)(this + " not getting package " + name + " from all exports"));
        }
        if (info != null && (result = this.getPackageFromImports(info, name, trace)) != null) {
            return result;
        }
        if (classLoader != null) {
            if (trace) {
                log.trace((Object)(this + " trying to get package " + name + " from requesting " + classLoader));
            }
            if ((result = classLoader.getPackageLocally(name)) != null) {
                if (trace) {
                    log.trace((Object)(this + " got package from requesting " + classLoader + " " + result));
                }
                return result;
            }
        }
        if ((result = this.afterGetPackage(name)) != null) {
            return result;
        }
        return null;
    }

    void getPackages(BaseClassLoader classLoader, Set<Package> packages, boolean allExports) {
        boolean trace = log.isTraceEnabled();
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        this.beforeGetPackages(packages);
        ClassLoaderInformation info = null;
        if (classLoader != null) {
            ClassLoaderPolicy policy = classLoader.getPolicy();
            info = this.infos.get(classLoader);
            if (((BaseClassLoaderPolicy)policy).isImportAll()) {
                allExports = true;
            }
        }
        if (allExports) {
            this.getPackagesFromExports(classLoader, packages, trace);
        } else if (trace) {
            log.trace((Object)(this + " not getting packages from all exports"));
        }
        if (info != null) {
            this.getPackagesFromImports(info, packages, trace);
        }
        if (classLoader != null) {
            if (trace) {
                log.trace((Object)(this + " trying to get packages from requesting " + classLoader));
            }
            classLoader.getPackagesLocally(packages);
        }
        this.afterGetPackages(packages);
    }

    private Loader findLoaderInExports(BaseClassLoader classLoader, String name, boolean trace) {
        Loader loader;
        ClassCacheItem item = this.globalClassCache.get(name);
        if (item != null && (loader = item.loader) != null) {
            if (trace) {
                log.trace((Object)(this + " found loader " + loader + " in global class cache " + name));
            }
            return loader;
        }
        if (this.isBlackListedClass(name)) {
            if (trace) {
                log.trace((Object)(this + " class is black listed " + name));
            }
            return null;
        }
        boolean canCache = true;
        boolean canBlackList = true;
        String packageName = ClassLoaderUtils.getResourcePackageName(name);
        List<ClassLoaderInformation> list = this.classLoadersByPackageName.get(packageName);
        if (trace) {
            log.trace((Object)(this + " trying to load " + name + " from all exports of package " + packageName + " " + list));
        }
        if (list != null && !list.isEmpty()) {
            for (ClassLoaderInformation info : list) {
                BaseDelegateLoader exported = info.getExported();
                BaseClassLoaderPolicy loaderPolicy = exported.getPolicy();
                if (loaderPolicy == null || !loaderPolicy.isCacheable()) {
                    canCache = false;
                }
                if (loaderPolicy == null || !loaderPolicy.isBlackListable()) {
                    canBlackList = false;
                }
                if (exported.getResource(name) == null) continue;
                if (canCache) {
                    this.globalClassCache.put(name, new ClassCacheItem(exported));
                }
                return exported;
            }
        }
        if (canBlackList) {
            this.globalClassBlackList.add(name);
        }
        return null;
    }

    private URL getResourceFromExports(BaseClassLoader classLoader, String name, boolean trace) {
        URL result = this.globalResourceCache.get(name);
        if (result != null) {
            if (trace) {
                log.trace((Object)(this + " got resource from cache " + name));
            }
            return result;
        }
        Set<URL> results = this.globalResourcesCache.get(name);
        if (results != null) {
            if (trace) {
                log.trace((Object)(this + " got resource from resources cache " + name));
            }
            return results.isEmpty() ? null : results.iterator().next();
        }
        if (this.globalResourceBlackList.contains(name)) {
            if (trace) {
                log.trace((Object)(this + " resource is black listed, not looking at exports " + name));
            }
            return null;
        }
        boolean canCache = true;
        boolean canBlackList = true;
        String packageName = ClassLoaderUtils.getResourcePackageName(name);
        List<ClassLoaderInformation> list = this.classLoadersByPackageName.get(packageName);
        if (trace) {
            log.trace((Object)(this + " trying to get resource " + name + " from all exports " + list));
        }
        if (list != null && !list.isEmpty()) {
            for (ClassLoaderInformation info : list) {
                BaseDelegateLoader loader = info.getExported();
                BaseClassLoaderPolicy loaderPolicy = loader.getPolicy();
                if (loaderPolicy == null || !loaderPolicy.isCacheable()) {
                    canCache = false;
                }
                if (loaderPolicy == null || !loaderPolicy.isBlackListable()) {
                    canBlackList = false;
                }
                if ((result = loader.getResource(name)) == null) continue;
                if (canCache) {
                    this.globalResourceCache.put(name, result);
                }
                return result;
            }
        }
        if (canBlackList) {
            this.globalResourceBlackList.add(name);
        }
        return null;
    }

    void getResourcesFromExports(BaseClassLoader classLoader, String name, Set<URL> urls, boolean trace) throws IOException {
        Set<URL> results = this.globalResourcesCache.get(name);
        if (results != null) {
            if (trace) {
                log.trace((Object)(this + " got resources from cache " + name));
            }
            urls.addAll(results);
            return;
        }
        if (this.globalResourceBlackList.contains(name)) {
            return;
        }
        String packageName = ClassLoaderUtils.getResourcePackageName(name);
        List<ClassLoaderInformation> list = this.classLoadersByPackageName.get(packageName);
        if (trace) {
            log.trace((Object)(this + " trying to get resources " + name + " from all exports " + list));
        }
        boolean canCache = true;
        boolean canBlackList = true;
        LinkedHashSet<URL> tmp = new LinkedHashSet<URL>();
        if (list != null && !list.isEmpty()) {
            for (ClassLoaderInformation info : list) {
                BaseDelegateLoader loader = info.getExported();
                BaseClassLoaderPolicy loaderPolicy = loader.getPolicy();
                if (loaderPolicy == null || !loaderPolicy.isCacheable()) {
                    canCache = false;
                }
                if (loaderPolicy == null || !loaderPolicy.isBlackListable()) {
                    canBlackList = false;
                }
                loader.getResources(name, tmp);
            }
        }
        if (tmp.isEmpty()) {
            if (canCache) {
                this.globalResourcesCache.put(name, Collections.emptySet());
            }
            if (canBlackList) {
                this.globalResourceBlackList.add(name);
            }
        } else {
            urls.addAll(tmp);
            if (canCache) {
                this.globalResourcesCache.put(name, tmp);
            }
        }
    }

    private Package getPackageFromExports(BaseClassLoader classLoader, String name, boolean trace) {
        List<ClassLoaderInformation> list = this.classLoadersByPackageName.get(name);
        if (trace) {
            log.trace((Object)(this + " trying to get package " + name + " from all exports " + list));
        }
        if (list != null && !list.isEmpty()) {
            for (ClassLoaderInformation info : list) {
                BaseDelegateLoader loader = info.getExported();
                Package result = loader.getPackage(name);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    void getPackagesFromExports(BaseClassLoader classLoader, Set<Package> packages, boolean trace) {
        List<ClassLoaderInformation> list = this.classLoaders;
        if (trace) {
            log.trace((Object)(this + " trying to get all packages from all exports " + list));
        }
        if (list != null && !list.isEmpty()) {
            for (ClassLoaderInformation info : list) {
                BaseDelegateLoader loader = info.getExported();
                loader.getPackages(packages);
            }
        }
    }

    Loader findLoaderInImports(ClassLoaderInformation info, String name, boolean trace) {
        List<? extends DelegateLoader> delegates = info.getDelegates();
        if (delegates == null || delegates.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " not loading " + name + " from imports it has no delegates"));
            }
            return null;
        }
        Loader loader = info.getCachedLoader(name);
        if (loader != null) {
            if (trace) {
                log.trace((Object)(this + " found in import cache " + name));
            }
            return loader;
        }
        if (info.isBlackListedClass(name)) {
            if (trace) {
                log.trace((Object)(this + " class is black listed in imports " + name));
            }
            return null;
        }
        for (DelegateLoader delegateLoader : delegates) {
            if (trace) {
                log.trace((Object)(this + " trying to load " + name + " from import " + delegateLoader + " for " + info.getClassLoader()));
            }
            if (delegateLoader.getResource(name) == null) continue;
            info.cacheLoader(name, delegateLoader);
            return delegateLoader;
        }
        info.blackListClass(name);
        return null;
    }

    private URL getResourceFromImports(ClassLoaderInformation info, String name, boolean trace) {
        List<? extends DelegateLoader> delegates = info.getDelegates();
        if (delegates == null || delegates.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " not getting resource " + name + " from imports it has no delegates"));
            }
            return null;
        }
        URL url = info.getCachedResource(name);
        if (url != null) {
            if (trace) {
                log.trace((Object)(this + " found resource in import cache " + name));
            }
            return url;
        }
        if (info.isBlackListedResource(name)) {
            if (trace) {
                log.trace((Object)(this + " resource is black listed in imports " + name));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " trying to get resource " + name + " from imports " + delegates + " for " + info.getClassLoader()));
        }
        for (DelegateLoader delegateLoader : delegates) {
            URL result = delegateLoader.getResource(name);
            if (result == null) continue;
            info.cacheResource(name, result);
            return result;
        }
        info.blackListResource(name);
        return null;
    }

    void getResourcesFromImports(ClassLoaderInformation info, String name, Set<URL> urls, boolean trace) throws IOException {
        List<? extends DelegateLoader> delegates = info.getDelegates();
        if (delegates == null || delegates.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " not getting resources " + name + " from imports it has no delegates"));
            }
            return;
        }
        Set<URL> cached = info.getCachedResources(name);
        if (cached != null) {
            if (trace) {
                log.trace((Object)(this + " found resources in import cache " + name));
            }
            urls.addAll(cached);
            return;
        }
        if (info.isBlackListedResource(name)) {
            if (trace) {
                log.trace((Object)(this + " resource is black listed in imports " + name));
            }
            return;
        }
        if (trace) {
            log.trace((Object)(this + " trying to get resources " + name + " from imports " + delegates + " for " + info.getClassLoader()));
        }
        cached = new LinkedHashSet<URL>();
        for (DelegateLoader delegateLoader : delegates) {
            delegateLoader.getResources(name, cached);
        }
        if (cached.isEmpty()) {
            info.blackListResource(name);
            info.cacheResources(name, Collections.<URL>emptySet());
        } else {
            urls.addAll(cached);
            info.cacheResources(name, cached);
        }
    }

    private Package getPackageFromImports(ClassLoaderInformation info, String name, boolean trace) {
        List<? extends DelegateLoader> delegates = info.getDelegates();
        if (delegates == null || delegates.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " not getting package " + name + " from imports it has no delegates"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " trying to get package " + name + " from imports " + delegates + " for " + info.getClassLoader()));
        }
        for (DelegateLoader delegateLoader : delegates) {
            Package result = delegateLoader.getPackage(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    void getPackagesFromImports(ClassLoaderInformation info, Set<Package> packages, boolean trace) {
        List<? extends DelegateLoader> delegates = info.getDelegates();
        if (delegates == null || delegates.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " not getting all packages from imports it has no delegates"));
            }
            return;
        }
        if (trace) {
            log.trace((Object)(this + " trying to get all pacakges from imports " + delegates + " for " + info.getClassLoader()));
        }
        for (DelegateLoader delegateLoader : delegates) {
            delegateLoader.getPackages(packages);
        }
    }

    protected abstract Class<?> loadClassBefore(String var1);

    protected abstract Class<?> loadClassAfter(String var1);

    protected abstract Loader findBeforeLoader(String var1);

    protected abstract Loader findAfterLoader(String var1);

    protected abstract void beforeGetResources(String var1, Set<URL> var2) throws IOException;

    protected abstract void afterGetResources(String var1, Set<URL> var2) throws IOException;

    protected abstract URL beforeGetResource(String var1);

    protected abstract URL afterGetResource(String var1);

    protected abstract void beforeGetPackages(Set<Package> var1);

    protected abstract void afterGetPackages(Set<Package> var1);

    protected abstract Package beforeGetPackage(String var1);

    protected abstract Package afterGetPackage(String var1);

    @Override
    public Class<?> loadClass(String name) {
        try {
            return this.loadClass(null, name, true);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    Class<?> loadClass(BaseClassLoader classLoader, String name) throws ClassNotFoundException {
        return this.loadClass(classLoader, name, false);
    }

    @Override
    public URL getResource(String name) {
        return this.getResource(null, name, true);
    }

    URL getResource(BaseClassLoader classLoader, String name) {
        return this.getResource(classLoader, name, false);
    }

    @Override
    public void getResources(String name, Set<URL> urls) throws IOException {
        this.getResources(null, name, urls, true);
    }

    void getResources(BaseClassLoader classLoader, String name, Set<URL> urls) throws IOException {
        this.getResources(classLoader, name, urls, false);
    }

    @Override
    public Package getPackage(String name) {
        return this.getPackage(null, name, true);
    }

    Package getPackage(BaseClassLoader classLoader, String name) {
        return this.getPackage(classLoader, name, false);
    }

    @Override
    public void getPackages(Set<Package> packages) {
        this.getPackages(null, packages, true);
    }

    void getPackages(BaseClassLoader classLoader, Set<Package> packages) {
        this.getPackages(classLoader, packages, false);
    }

    protected ClassLoaderPolicy getClassLoaderPolicy(Object object) {
        if (object instanceof BaseClassLoader) {
            return ((BaseClassLoader)object).getPolicy();
        }
        if (object instanceof BaseClassLoaderSource) {
            return this.getClassLoaderPolicy(((BaseClassLoaderSource)object).getClassLoader());
        }
        return null;
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{");
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void toLongString(StringBuilder builder) {
    }

    protected void beforeRegisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
    }

    protected void afterRegisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
    }

    protected void beforeUnregisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
    }

    protected void afterUnregisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
    }

    protected ClassLoader getParentClassLoader() {
        return this.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerClassLoader(BaseClassLoader classLoader) {
        log.debug((Object)(this + " registerClassLoader " + classLoader.toString()));
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        ClassLoaderPolicy policy = classLoader.getPolicy();
        DelegateLoader exported = policy.getExported();
        if (exported != null && ((BaseDelegateLoader)exported).getPolicy() == null) {
            throw new IllegalStateException("The exported delegate " + exported + " is too lazy for " + policy.toLongString());
        }
        try {
            this.beforeRegisterClassLoader(classLoader, policy);
        }
        catch (Throwable t) {
            log.warn((Object)("Error in beforeRegisterClassLoader: " + this + " classLoader=" + classLoader.toLongString()), t);
        }
        ClassLoaderPolicy basePolicy = classLoader.getPolicy();
        basePolicy.setClassLoaderDomain(this);
        List<ClassLoaderInformation> list = this.classLoaders;
        synchronized (list) {
            ClassLoaderInformation info = new ClassLoaderInformation(classLoader, policy, this.order++);
            this.classLoaders.add(info);
            this.infos.put(classLoader, info);
            String[] packageNames = policy.getPackageNames();
            if (packageNames != null && info.getExported() != null) {
                for (String packageName : packageNames) {
                    List<ClassLoaderInformation> list2 = this.classLoadersByPackageName.get(packageName);
                    if (list2 == null) {
                        list2 = new CopyOnWriteArrayList<ClassLoaderInformation>();
                        this.classLoadersByPackageName.put(packageName, list2);
                    }
                    list2.add(info);
                    log.trace((Object)("Registered " + policy + " as providing package=" + packageName));
                }
            }
            this.flushCaches();
        }
        try {
            this.afterRegisterClassLoader(classLoader, classLoader.getPolicy());
        }
        catch (Throwable t) {
            log.warn((Object)("Error in afterRegisterClassLoader: " + this + " classLoader=" + classLoader.toLongString()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterClassLoader(BaseClassLoader classLoader) {
        log.debug((Object)(this + " unregisterClassLoader " + classLoader.toString()));
        try {
            this.beforeUnregisterClassLoader(classLoader, classLoader.getPolicy());
        }
        catch (Throwable t) {
            log.warn((Object)("Error in beforeUnegisterClassLoader: " + this + " classLoader=" + classLoader.toLongString()), t);
        }
        ClassLoaderPolicy policy = classLoader.getPolicy();
        policy.unsetClassLoaderDomain(this);
        List<ClassLoaderInformation> list = this.classLoaders;
        synchronized (list) {
            ClassLoaderInformation info = this.infos.remove(classLoader);
            this.classLoaders.remove(info);
            String[] packageNames = ((BaseClassLoaderPolicy)policy).getPackageNames();
            if (packageNames != null && info.getExported() != null) {
                for (String packageName : packageNames) {
                    List<ClassLoaderInformation> list2 = this.classLoadersByPackageName.get(packageName);
                    if (list2 == null) continue;
                    list2.remove(info);
                    log.trace((Object)("Unregistered " + policy + " as providing package=" + packageName));
                    if (!list2.isEmpty()) continue;
                    this.classLoadersByPackageName.remove(packageName);
                }
            }
            this.flushCaches();
        }
        try {
            this.afterUnregisterClassLoader(classLoader, classLoader.getPolicy());
        }
        catch (Throwable t) {
            log.warn((Object)("Error in afterUnegisterClassLoader: " + this + " classLoader=" + classLoader.toLongString()), t);
        }
    }

    protected List<ClassLoader> getAllClassLoaders() {
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>();
        for (ClassLoaderInformation info : this.classLoaders) {
            result.add(info.getClassLoader());
        }
        return result;
    }

    protected Map<String, List<ClassLoader>> getClassLoadersByPackage() {
        HashMap<String, List<ClassLoader>> result = new HashMap<String, List<ClassLoader>>();
        for (Map.Entry<String, List<ClassLoaderInformation>> entry : this.classLoadersByPackageName.entrySet()) {
            ArrayList<BaseClassLoader> cls = new ArrayList<BaseClassLoader>();
            for (ClassLoaderInformation info : entry.getValue()) {
                cls.add(info.getClassLoader());
            }
            result.put(entry.getKey(), cls);
        }
        return result;
    }

    protected List<ClassLoader> getClassLoaders(String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Null package name");
        }
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>();
        List<ClassLoaderInformation> infos = this.classLoadersByPackageName.get(packageName);
        if (infos != null) {
            for (ClassLoaderInformation info : infos) {
                result.add(info.getClassLoader());
            }
        }
        return result;
    }

    @Override
    public Class<?> checkClassCache(BaseClassLoader classLoader, String name, String path, boolean allExports) {
        Class<?> result = this.checkCacheBefore(classLoader, name, path, allExports);
        if (result != null) {
            return result;
        }
        result = this.checkCacheAfter(classLoader, name, path, allExports);
        if (result != null) {
            return result;
        }
        result = this.checkClassCacheLocally(classLoader, name, path, allExports);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void updateClassCache(BaseClassLoader classLoader, String path, Class<?> result) {
        ClassCacheItem item = this.globalClassCache.get(path);
        if (item != null) {
            item.clazz = result;
        }
    }

    protected Class<?> checkCacheBefore(BaseClassLoader classLoader, String name, String path, boolean allExports) {
        return null;
    }

    protected Class<?> checkCacheAfter(BaseClassLoader classLoader, String name, String path, boolean allExports) {
        return null;
    }

    Class<?> checkClassCacheLocally(BaseClassLoader classLoader, String name, String path, boolean allExports) {
        ClassCacheItem item;
        if (allExports && (item = this.globalClassCache.get(path)) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found " + name + " in global cache"));
            }
            return item.clazz;
        }
        return null;
    }

    void checkClassBlackList(BaseClassLoader classLoader, String name, String path, boolean allExports, boolean failIfBlackListed) throws ClassNotFoundException {
        if (allExports && failIfBlackListed && this.isBlackListedClass(path)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found " + name + " in global blacklist"));
            }
            throw new ClassNotFoundException(name + " not found - blacklisted");
        }
    }

    protected Class<?> checkClassCacheAndBlackList(BaseClassLoader classLoader, String name, String path, boolean allExports, boolean failIfBlackListed) throws ClassNotFoundException {
        Class<?> result;
        if (path == null) {
            path = ClassLoaderUtils.classNameToPath(name);
        }
        if ((result = this.checkClassCache(classLoader, name, path, allExports)) != null) {
            return result;
        }
        this.checkClassBlackList(classLoader, name, path, allExports, failIfBlackListed);
        return null;
    }

    protected void clearBlackList(String name) {
        if (this.globalClassBlackList != null) {
            this.globalClassBlackList.remove(name);
        }
        if (this.globalResourceBlackList != null) {
            this.globalResourceBlackList.remove(name);
        }
        List<ClassLoaderInformation> infos = this.classLoaders;
        for (ClassLoaderInformation info : infos) {
            info.clearBlackList(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassCacheItem {
        Loader loader;
        Class<?> clazz;

        public ClassCacheItem(Loader loader) {
            this.loader = loader;
        }

        public ClassCacheItem(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String toString() {
            if (this.loader != null) {
                return this.loader.toString();
            }
            return "";
        }
    }
}

