/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.ClassLoadingSpace;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.logging.Logger;

public class Domain {
    private static final Logger log = Logger.getLogger(Domain.class);
    private String name;
    private ClassLoading classLoading;
    private String parentDomainName;
    private boolean parentFirst;
    private List<Module> modules = new CopyOnWriteArrayList<Module>();
    private Map<String, Module> modulesByName = new ConcurrentHashMap<String, Module>();

    public Domain(ClassLoading classLoading, String name, String parentDomainName, boolean parentFirst) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (classLoading == null) {
            throw new IllegalArgumentException("Null classLoading");
        }
        this.classLoading = classLoading;
        this.name = name;
        this.parentDomainName = parentDomainName;
        this.parentFirst = parentFirst;
    }

    public String getName() {
        return this.name;
    }

    public String getParentDomainName() {
        return this.parentDomainName;
    }

    public Domain getParentDomain() {
        if (this.parentDomainName != null) {
            return this.classLoading.getDomain(this.parentDomainName);
        }
        return null;
    }

    public boolean isParentFirst() {
        return this.parentFirst;
    }

    public synchronized void addModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        Domain domain = module.getDomain();
        if (domain != null) {
            throw new IllegalArgumentException("The module is already registered with the domain " + domain.getName());
        }
        String contextName = module.getContextName();
        if (this.modulesByName.containsKey(contextName)) {
            throw new IllegalArgumentException("The context " + contextName + " is already registered in domain " + this.getName());
        }
        log.debug((Object)(this + " add module " + module));
        module.setDomain(this);
        this.modulesByName.put(contextName, module);
        this.modules.add(module);
        try {
            module.createDependencies();
            if (!module.isImportAll()) {
                ClassLoadingSpace space = new ClassLoadingSpace();
                space.join(module);
            }
        }
        catch (Throwable t) {
            this.removeModule(module);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException("Error adding module " + module, t);
        }
    }

    protected synchronized void removeModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        log.debug((Object)(this + " remove module " + module));
        this.modulesByName.remove(module.getContextName());
        this.modules.remove(module);
        module.setDomain(null);
        module.removeDependencies();
        ClassLoadingSpace space = module.getClassLoadingSpace();
        if (space != null) {
            space.split(module);
        }
    }

    public Module getModule(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null module name");
        }
        Module module = this.modulesByName.get(name);
        if (module != null) {
            return module;
        }
        Domain parent = this.getParentDomain();
        if (parent != null) {
            return parent.getModule(name);
        }
        return null;
    }

    protected Module resolveModule(Module module, Requirement requirement) {
        Module result;
        Domain parentDomain = null;
        if (this.parentDomainName != null && (parentDomain = this.getParentDomain()) == null) {
            return null;
        }
        if (parentDomain != null && this.parentFirst && (result = parentDomain.resolveModule(module, requirement)) != null) {
            return result;
        }
        for (Module other : this.modules) {
            List<Capability> capabilities = other.getCapabilities();
            if (capabilities == null) continue;
            for (Capability capability : capabilities) {
                if (!capability.resolves(module, requirement)) continue;
                return other;
            }
        }
        if (parentDomain != null && !this.parentFirst) {
            return parentDomain.resolveModule(module, requirement);
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append('{').append(this.getName()).append('}');
        return builder.toString();
    }
}

