/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins.loader;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Set;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderToLoaderAdapter
extends BaseClassLoaderSource
implements Loader {
    private static final Logger log = Logger.getLogger(ClassLoaderToLoaderAdapter.class);
    private AccessControlContext accessControlContext = AccessController.getContext();
    private static Method getPackage;
    private static Method getPackages;

    public ClassLoaderToLoaderAdapter(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public URL getResource(final String name) {
        final ClassLoader classLoader = this.getClassLoader();
        SecurityManager sm = System.getSecurityManager();
        URL url = sm != null ? AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return classLoader.getResource(name);
            }
        }, this.accessControlContext) : classLoader.getResource(name);
        if (log.isTraceEnabled()) {
            if (url != null) {
                log.trace((Object)("Resource " + name + " found in " + classLoader));
            } else {
                log.trace((Object)("Resource " + name + " NOT found in " + classLoader));
            }
        }
        return url;
    }

    @Override
    public void getResources(final String name, Set<URL> urls) throws IOException {
        Enumeration<URL> enumeration;
        final ClassLoader classLoader = this.getClassLoader();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                enumeration = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                    @Override
                    public Enumeration<URL> run() throws Exception {
                        return classLoader.getResources(name);
                    }
                }, this.accessControlContext);
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                if (e1 instanceof RuntimeException) {
                    throw (RuntimeException)e1;
                }
                if (e1 instanceof IOException) {
                    throw (IOException)e1;
                }
                IOException e2 = new IOException("Unexpected error");
                e2.initCause(e1);
                throw e2;
            }
        } else {
            enumeration = classLoader.getResources(name);
        }
        while (enumeration.hasMoreElements()) {
            urls.add(enumeration.nextElement());
        }
    }

    @Override
    public Class<?> loadClass(String className) {
        ClassLoader classLoader = this.getClassLoader();
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Package getPackage(String name) {
        ClassLoader classLoader = this.getClassLoader();
        if (getPackage == null) {
            return null;
        }
        try {
            return (Package)getPackage.invoke((Object)classLoader, name);
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected error retrieving package " + name + " from classloader " + classLoader), (Throwable)e);
            return null;
        }
    }

    @Override
    public void getPackages(Set<Package> packages) {
        ClassLoader classLoader = this.getClassLoader();
        if (getPackages == null) {
            return;
        }
        try {
            getPackages.invoke((Object)classLoader, new Object[0]);
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected error retrieving packages from classloader " + classLoader), (Throwable)e);
        }
    }

    public String toString() {
        return this.getClassLoader().toString();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                    getPackage.setAccessible(true);
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to set accessible on ClassLoader.getPackage()", (Throwable)e);
                }
                try {
                    getPackages = ClassLoader.class.getDeclaredMethod("getPackages", new Class[0]);
                    getPackages.setAccessible(true);
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to set accessible on ClassLoader.getPackages()", (Throwable)e);
                }
                return null;
            }
        });
    }
}

