/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs.helpers;

import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathTokenizer {
    private static final String CURRENT_PATH = ".";
    private static final String REVERSE_PATH = "..";
    private static boolean errorOnSuspiciousTokens;
    private static Permission flagPermission;

    private PathTokenizer() {
    }

    protected static String getRemainingPath(List<String> tokens, int i, int end) {
        if (tokens == null) {
            throw new IllegalArgumentException("Null tokens");
        }
        if (i < 0 || i >= end) {
            throw new IllegalArgumentException("i is not in the range of tokens: 0-" + (end - 1));
        }
        if (i == end - 1) {
            return tokens.get(end - 1);
        }
        StringBuilder buffer = new StringBuilder();
        while (i < end - 1) {
            buffer.append(tokens.get(i));
            buffer.append("/");
            ++i;
        }
        buffer.append(tokens.get(end - 1));
        return buffer.toString();
    }

    public static List<String> getTokens(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        char[] chars = path.toCharArray();
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        String specialToken = null;
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch == '/') {
                if (index <= 0 || buffer.length() == 0 && specialToken == null) continue;
                if (specialToken != null) {
                    list.add(specialToken);
                } else {
                    list.add(buffer.toString());
                }
                buffer.setLength(0);
                specialToken = null;
                continue;
            }
            if (ch == '.') {
                int bufferLength = buffer.length();
                if (specialToken == null && bufferLength == 0) {
                    specialToken = CURRENT_PATH;
                    continue;
                }
                if (specialToken == CURRENT_PATH && bufferLength == 0) {
                    specialToken = REVERSE_PATH;
                    continue;
                }
                if (specialToken == REVERSE_PATH && bufferLength == 0) {
                    if (errorOnSuspiciousTokens) {
                        throw new IllegalArgumentException("Illegal token (" + specialToken + ch + ") in path: " + path);
                    }
                    buffer.append(specialToken).append(ch);
                    specialToken = null;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            if (specialToken != null) {
                if (errorOnSuspiciousTokens && specialToken == REVERSE_PATH) {
                    throw new IllegalArgumentException("Illegal token (" + specialToken + ch + ") in path: " + path);
                }
                buffer.append(specialToken);
                specialToken = null;
            }
            buffer.append(ch);
        }
        if (specialToken != null) {
            list.add(specialToken);
        } else if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        return list;
    }

    public static String getRemainingPath(List<String> tokens, int i) {
        if (tokens == null) {
            throw new IllegalArgumentException("Null tokens");
        }
        return PathTokenizer.getRemainingPath(tokens, i, tokens.size());
    }

    public static String applySpecialPaths(String path) throws IOException {
        List<String> tokens = PathTokenizer.getTokens(path);
        if (tokens == null) {
            return null;
        }
        int i = 0;
        for (int j = 0; j < tokens.size(); ++j) {
            String token = tokens.get(j);
            if (PathTokenizer.isCurrentToken(token)) continue;
            if (PathTokenizer.isReverseToken(token)) {
                --i;
            } else {
                tokens.set(i++, token);
            }
            if (i >= 0) continue;
            throw new IOException("Using reverse path on top path: " + path);
        }
        return PathTokenizer.getRemainingPath(tokens, 0, i);
    }

    public static boolean isCurrentToken(String token) {
        return CURRENT_PATH == token;
    }

    public static boolean isReverseToken(String token) {
        return REVERSE_PATH == token;
    }

    public static void setErrorOnSuspiciousTokens(boolean errorOnSuspiciousTokens) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(flagPermission);
        }
        PathTokenizer.errorOnSuspiciousTokens = errorOnSuspiciousTokens;
    }

    static {
        flagPermission = new RuntimePermission(PathTokenizer.class.getName() + ".setErrorOnSuspiciousTokens");
    }
}

